/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.ColoredCircle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class DiodeSwitch
extends GenericGate
implements Wakeable,
Assignable {
    protected PortStdLogic1164 port_A;
    protected PortStdLogic1164 port_Y = new PortStdLogic1164(this, "Y", 1, null);
    protected StdLogic1164 startValue;
    protected double delay = 0.0;
    protected int state;
    protected ColoredCircle showOnOff;

    public DiodeSwitch() {
        this.port_A = new PortStdLogic1164(this, "A", 0, null);
        this.ports = new Port[2];
        this.ports[0] = this.port_Y;
        this.ports[1] = this.port_A;
        this.startValue = new StdLogic1164();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public String getStartValue() {
        return "" + this.startValue.getChar();
    }

    public void setStartValue(String s) {
        if (s != null && s.length() > 0) {
            this.startValue = new StdLogic1164(s.charAt(0));
        }
    }

    public boolean initialize(String s) {
        block5: {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                if (n_tokens == 0) {
                    this.versionId = 1001L;
                    break block5;
                }
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.startValue = Const1164.__U;
                    break block5;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    char c = st.nextToken().charAt(0);
                    this.startValue = new StdLogic1164(c);
                    this.setStartState();
                    break block5;
                }
                throw new Exception("invalid number of arguments");
            }
            catch (Exception e) {
                this.message("-E- DiodeSwitch.initialize(): " + e + " " + s);
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.startValue.getChar());
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredCircle)) continue;
                this.showOnOff = (ColoredCircle)tmp;
            }
            this.setStartState();
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- DiodeSwitch.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void setStartState() {
        this.state = this.startValue.intValue();
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        if (this.showOnOff == null) {
            return;
        }
        FigAttribs attr = this.showOnOff.getAttributes();
        attr.fillStyle = 2;
        if (this.state == 2) {
            attr.fillColor = Const1164.__0.getColor();
            attr.fig_fill_color = 0;
            attr.fig_area_fill = 5;
        } else if (this.state == 3) {
            attr.fillColor = Const1164.__1.getColor();
            attr.fig_fill_color = 4;
            attr.fig_area_fill = 20;
        } else if (this.state == 4) {
            attr.fillColor = Const1164.__Z.getColor();
            attr.fig_fill_color = 6;
            attr.fig_area_fill = 20;
        } else if (this.state == 0) {
            attr.fillColor = Const1164.__U.getColor();
            attr.fig_fill_color = 3;
            attr.fig_area_fill = 20;
        } else {
            this.message("-E- internal error in DiodeSwitch: illegal state=" + this.state);
            attr.fillColor = Const1164.__U.getColor();
            this.state = 0;
        }
        this.showOnOff.setAttributes(attr);
        if (this.showOnOff.painter != null) {
            this.showOnOff.painter.paint(this.showOnOff);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.state = this.state == 0 ? 2 : (this.state == 2 ? 3 : (this.state == 3 ? 2 : 0));
        this.scheduleAfter(this.state, 5.0E-9, true);
        this.showState();
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.setStartState();
        this.scheduleAfter(this.state, 0.0, false);
        this.showState();
    }

    private void scheduleAfter(int state, double delay, boolean interactive) {
        if (this.simulator == null) {
            return;
        }
        this.schedule(state, this.simulator.getSimTime() + delay, interactive);
    }

    private void schedule(int state, double simTime, boolean interactive) {
        if (this.simulator == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        StdLogic1164 value_A = this.port_A.getValueOrU();
        Const1164 output = state == 3 ? (value_A.is_0() ? Const1164.__0 : (value_A.is_L() ? Const1164.__L : (value_A.is_1() ? Const1164.__Z : (value_A.is_H() ? Const1164.__Z : (value_A.is_Z() ? Const1164.__Z : Const1164.__X))))) : (state == 2 ? Const1164.__Z : Const1164.__X);
        SimEvent1164 se = SimEvent1164.createNewSimEvent((Simulatable)signal_Y, simTime, output, (Object)this.port_Y);
        if (interactive) {
            this.simulator.scheduleInteractiveEvent(se);
        } else {
            this.simulator.scheduleEvent(se);
        }
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message(this.toString() + ".evaluate()");
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            this.message("DiodeSwitch.evaluate: simulator is null...");
            return;
        }
        this.scheduleAfter(this.state, this.delay, false);
    }

    public void assign(String value, double simTime) {
        try {
            StdLogic1164 tmp = new StdLogic1164(value.charAt(0));
            this.schedule(tmp.intValue(), simTime, false);
            if (this.visible) {
                this.simulator.scheduleWakeup(this, simTime, tmp);
            }
        }
        catch (Exception e) {
            System.err.println("-E- internal in Ipin.assign: " + e);
        }
    }

    public void wakeup(Object arg) {
        try {
            WakeupEvent we = (WakeupEvent)arg;
            StdLogic1164 sl = (StdLogic1164)we.getArg();
            this.state = sl.intValue();
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "start value  [U,0,1,Z]:", "startValue", "output delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value, and delay:");
        this.propertySheet.setVisible(true);
    }
}

