/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.Circle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.objects.FigAttribs;

public class ClockGen2
extends GenericGate
implements Simulatable,
Wakeable,
Serializable {
    protected PortStdLogic1164 port_Y;
    protected StdLogic1164 state;
    protected StdLogic1164 output_U;
    protected StdLogic1164 output_0;
    protected StdLogic1164 output_1;
    protected double period = 1.0;
    protected double dutycycle = 0.5;
    protected double offset = 0.0;
    protected int n_cycles = 0;
    protected int n_clicks = 0;
    protected boolean running = true;
    protected boolean debug = false;
    protected String bindkey = null;
    protected Circle circleOnOff;
    protected Color runningColor = new Color(100, 255, 0);

    public ClockGen2() {
        this.port_Y = new PortStdLogic1164(this, "clk", 1, null);
        this.ports = new Port[1];
        this.ports[0] = this.port_Y;
        this.output_U = Const1164.__U;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
        this.state = this.output_U;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public double getPeriod() {
        return this.period;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getDutycycle() {
        return this.dutycycle;
    }

    public void setPeriod(double d) {
        this.period = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setDutycycle(double d) {
        this.dutycycle = d;
        if (this.dutycycle < 0.0 || this.dutycycle > 1.0) {
            this.message("-W- ClockGen2: illegal value for 'dutycycle': " + this.dutycycle);
            this.message("-W- must be between 0.0 (0%) and 1.0 (100%), using 0.5!");
            this.dutycycle = 0.5;
        }
    }

    public void setPeriod(String s) {
        this.period = this.parse(s);
    }

    public void setOffset(String s) {
        this.offset = this.parse(s);
    }

    public void setDutycycle(String s) {
        this.setDutycycle(this.parse(s));
    }

    public String getBindkey() {
        return this.bindkey;
    }

    public void setBindkey(String s) {
        this.bindkey = NameMangler.getBindkey(this, s);
    }

    public double parse(String s) {
        double d = 0.0;
        try {
            d = Double.valueOf(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        return d;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.period = Double.valueOf(st.nextToken());
            this.dutycycle = Double.valueOf(st.nextToken());
            this.offset = Double.valueOf(st.nextToken());
            if (st.hasMoreTokens()) {
                this.setBindkey(st.nextToken());
            }
            if (this.debug) {
                this.message("ClockGen2.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- ClockGen2.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.period + " " + this.dutycycle + " " + this.offset + " " + this.bindkey);
    }

    public void configure() {
        if (this.debug) {
            this.message("-I- starting to configure this ClockGen2...");
        }
        String[] fields = new String[]{"instance name:", "name", "period [sec]:", "period", "duty cycle [0.0 .. 1.0]:", "dutycycle", "offset [sec]:", "offset", "bindkey [a-z]:", "bindkey"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Timing parameters:\n________---_____---_____---____ ... \n^       ^  ^    ^  ^    ^  ^        \n|offset |period |period |period ... \n        |dc|    |dc|    |dc|    ... \nall times are given in seconds\nClick to toggle 0/1 output.\nShift-click to start/stop.\n");
        this.propertySheet.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (this.debug) {
            this.message(this.toString() + ".mousePressed: " + me);
        }
        this.mouseOrKeyPressed(me.isShiftDown());
    }

    public void keyPressed(KeyEvent ke) {
        if (this.debug) {
            this.message(this.toString() + ".keyPressed: " + ke);
        }
        this.mouseOrKeyPressed(ke.isShiftDown());
    }

    public void mouseOrKeyPressed(boolean isShiftDown) {
        SimKernel simulator = this.parent.getSimulator();
        if (simulator == null) {
            return;
        }
        double t_now = simulator.getSimTime();
        ++this.n_clicks;
        System.out.println("-#- ClockGen2.mouseOrKeyPressed: " + this.n_clicks);
        if (isShiftDown) {
            if (this.running) {
                this.running = false;
            } else {
                this.running = true;
                Integer I = new Integer(this.n_clicks);
                if (this.state == this.output_1) {
                    this.state = this.output_0;
                    this.schedule(this.output_0, t_now + this.dutycycle * this.period);
                    this.schedule(this.output_1, t_now + this.period);
                    simulator.scheduleWakeup(this, t_now + this.period, I);
                } else {
                    this.state = this.output_1;
                    this.schedule(this.output_0, t_now + this.dutycycle * this.period);
                    this.schedule(this.output_1, t_now + this.period);
                    simulator.scheduleWakeup(this, t_now + this.period, I);
                }
            }
        } else {
            this.running = false;
            if (this.state == this.output_1) {
                this.state = this.output_0;
                this.schedule(this.output_0, t_now);
            } else {
                this.state = this.output_1;
                this.schedule(this.output_1, t_now);
            }
        }
        this.showState();
    }

    private void initDisplay() {
        this.circleOnOff = new Circle();
        this.circleOnOff.initialize("600 1200 300 300");
        this.getSymbol().addMember(this.circleOnOff);
        this.showState();
    }

    private void showState() {
        if (this.getSymbol() == null) {
            return;
        }
        FigAttribs attr = this.circleOnOff.getAttributes();
        attr.fillStyle = 2;
        attr.fillColor = this.running ? this.runningColor : (this.state == this.output_1 ? this.output_1.getColor() : this.output_0.getColor());
        this.circleOnOff.setAttributes(attr);
        if (this.circleOnOff.painter != null) {
            this.circleOnOff.painter.paint(this.circleOnOff);
        }
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message(this.toString() + ".elaborate()" + arg);
        }
        this.n_cycles = 0;
        this.n_clicks = 0;
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (this.debug) {
                this.message(this.toString() + "elaborate(): SIMULATOR IS NULL!");
            }
            return;
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + this.offset, new Integer(this.n_clicks));
        if (this.offset > 0.0) {
            this.schedule(this.output_U, time);
        }
        this.schedule(this.output_1, time + this.offset);
    }

    public void evaluate(Object arg) {
        this.message("-E- " + this.toString() + ".evaluate()");
        this.message("-E- Don't call evaluate() on a ClockGen2");
    }

    public void wakeup(Object arg) {
        Integer I = null;
        try {
            WakeupEvent w = (WakeupEvent)arg;
            Object t = w.getArg();
            System.out.println("-#- ClockGen2.wakeup: " + t);
            I = (Integer)t;
        }
        catch (Exception e) {
            System.err.println("-#- ClockGen2.wakeup: payload not an Integer?" + arg);
            e.printStackTrace();
        }
        if (this.running && I == this.n_clicks) {
            ++this.n_cycles;
            double time = this.simulator.getSimTime();
            this.schedule(this.output_0, time + this.dutycycle * this.period);
            this.schedule(this.output_1, time + this.period);
            this.simulator.scheduleWakeup(this, time + this.period, I);
        } else {
            System.err.println("-#- ClockGen2.wakeup: ignored" + I + " " + this.n_clicks);
        }
    }

    private void schedule(StdLogic1164 value, double time) {
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            if (this.debug) {
                this.message("ClockGen2.evaluate: signal is null...");
            }
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, value, (Object)this.port_Y));
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "period= " + this.period + " [sec] " + "dutycycle= " + 100.0 * this.dutycycle + " [%]\n" + "offset= " + this.offset + " [sec] " + "n_cycles= " + this.n_cycles + "\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public String toString() {
        return "ClockGen2: " + this.getFullName() + "[timing: " + this.period + "," + this.dutycycle + "," + this.offset + "]";
    }
}

