/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.Label;
import hades.symbols.Polyline;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigAttribs;

public class BitReg6
extends SimObject
implements Simulatable,
Serializable {
    public static final int w = 1200;
    public static final int h = 1200;
    protected int n_bits = 6;
    protected Port port_C;
    protected Port port_NR;
    protected StdLogic1164 value_U;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164[] data;
    protected Label[] labels;
    static double t_pass = 8.0E-9;
    static double t_setup = 4.0E-9;

    public BitReg6() {
        this.ports = new Port[2 + this.n_bits + this.n_bits];
        int i = 0;
        this.ports[i++] = new Port(this, "C", 0, null);
        this.ports[i++] = new Port(this, "NR", 0, null);
        this.port_C = this.ports[0];
        this.port_NR = this.ports[1];
        int j = 0;
        while (j < this.n_bits) {
            this.ports[i++] = new Port(this, "D" + j, 3, null);
            ++j;
        }
        int j2 = 0;
        while (j2 < this.n_bits) {
            this.ports[i++] = new Port(this, "Q" + j2, 1, null);
            ++j2;
        }
        this.value_U = Const1164.__U;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.data = new StdLogic1164[this.n_bits];
        int j3 = 0;
        while (j3 < this.n_bits) {
            this.data[j3] = this.value_U;
            ++j3;
        }
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.initDisplay();
    }

    public void initDisplay() {
        int x;
        if (SimObject.debug) {
            this.message("-#- BitReg6.initDisplay...");
        }
        this.labels = new Label[this.n_bits];
        Rectangle background = new Rectangle();
        int xmax = 1200 + this.n_bits * 1200 - 50;
        background.initialize("1250 50 " + xmax + " 1150");
        FigAttribs attr = background.getAttributes();
        attr.currentLayer = 95;
        attr.fillStyle = 2;
        attr.fillColor = new Color(220, 220, 220);
        attr.lineColor = new Color(220, 220, 220);
        background.setAttributes(attr);
        this.symbol.fastAddMember(background);
        int i = 0;
        while (i < this.n_bits) {
            x = (int)(((double)(this.n_bits - i) + 0.5) * 1200.0);
            int y = 950;
            this.labels[i] = new Label();
            this.labels[i].initialize("" + x + " " + y + " 2 U");
            attr = this.labels[i].getAttributes();
            attr.fontSize = 24;
            attr.fig_font = 12;
            attr.currentLayer = 10;
            this.labels[i].setAttributes(attr);
            this.symbol.fastAddMember(this.labels[i]);
            ++i;
        }
        int i2 = 1;
        while (i2 < this.n_bits) {
            Polyline polyline = new Polyline();
            x = (i2 + 1) * 1200;
            polyline.initialize("2 " + x + " 1000 " + x + " 1200");
            this.symbol.fastAddMember(polyline);
            ++i2;
        }
        this.symbol.update_bbox();
    }

    public void show() {
        if (SimObject.debug) {
            this.message("-#- BitReg6.show...");
        }
        int i = 0;
        while (i < this.n_bits) {
            char value = StdLogic1164.chars[this.data[i].intValue()];
            this.labels[i].setText("" + value);
            ++i;
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 100);
        }
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("BitReg6: mousePressed...");
        }
        try {
            FigCanvasEvent ME = (FigCanvasEvent)me;
            Point WP = ME.getWorldCoordinatePoint();
            int dx = WP.x - this.symbol.getPos().x;
            int index = this.n_bits - dx / 1200;
            if (SimObject.debug) {
                this.message("dx= " + dx + " index= " + index);
            }
            if (index < 0 || index > this.n_bits - 1) {
                return;
            }
            StdLogic1164 tmp = this.data[index];
            this.data[index] = tmp.is_0() ? this.value_1 : (tmp.is_1() && ME.isShiftDown() ? this.value_X : (tmp.is_1() ? this.value_0 : this.value_0));
            if (this.symbol != null) {
                this.show();
            }
            double time = this.simulator.getSimTime() + t_pass;
            this.schedule(index, time);
        }
        catch (Exception e) {
            this.message("-W- Exception in BitReg6.mousePressed: " + e);
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void evaluate(Object arg) {
        int i;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate...");
        }
        StdLogic1164 value_NR = null;
        StdLogic1164 value_C = null;
        double time = this.simulator.getSimTime() + t_pass;
        Signal signal_NR = this.port_NR.getSignal();
        value_NR = signal_NR != null ? (StdLogic1164)signal_NR.getValue() : this.value_U;
        Signal signal_C = this.port_C.getSignal();
        value_C = signal_C != null ? (StdLogic1164)signal_C.getValue() : this.value_U;
        if (value_NR.is_0()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_0;
                ++i;
            }
        } else if (!value_NR.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_U;
                ++i;
            }
        } else if (signal_C == null) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_U;
                ++i;
            }
        } else if (signal_C.hasEvent() && value_C.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                Signal signal_tmp = this.ports[2 + i].getSignal();
                this.data[i] = signal_tmp == null ? this.value_U : (StdLogic1164)signal_tmp.getValue();
                ++i;
            }
        } else {
            return;
        }
        this.show();
        int i2 = 0;
        while (i2 < this.n_bits) {
            Port port_Q = this.ports[2 + this.n_bits + i2];
            SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
            if (signal_Q != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[i2], (Object)port_Q));
            }
            ++i2;
        }
    }

    public void schedule(int bitIndex, double time) {
        Port port_Q = this.ports[2 + this.n_bits + bitIndex];
        SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
        if (signal_Q != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[bitIndex], (Object)port_Q));
        }
    }
}

