/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.ColoredPolyline;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class AsciiDisplay
extends SimObject {
    int index;
    public static final int DEFAULT = 32;
    public static final int VERTICAL = 14;
    public static final int SLANTED = 13;
    protected int displayStyle = 14;
    protected ColoredPolyline[] segments;
    protected FigCompound display;
    protected Color dark_gray;
    protected Color medium_gray;
    protected StdLogic1164 undefined;
    private static int[][] CMATRIX = new int[][]{{32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {34, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {35, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {36, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {37, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0}, {38, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0}, {39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0}, {41, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}, {42, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0}, {48, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {50, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}, {51, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0}, {52, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0}, {53, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0}, {54, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0}, {55, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {56, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0}, {57, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0}, {58, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {59, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {60, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0}, {61, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {62, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {63, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0}, {64, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0}, {65, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {66, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0}, {67, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {68, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {69, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {70, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {71, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {72, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {73, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {74, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {75, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0}, {76, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {77, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0}, {78, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {79, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {80, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {81, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {82, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0}, {83, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {84, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {85, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {86, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0}, {87, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0}, {88, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {89, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0}, {90, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0}, {91, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {92, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {93, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0}, {95, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public AsciiDisplay() {
        this.name = "AsciiDisplay";
        this.ports = new Port[8];
        this.ports[0] = new Port(this, "D7", 0, null);
        this.ports[1] = new Port(this, "D6", 0, null);
        this.ports[2] = new Port(this, "D5", 0, null);
        this.ports[3] = new Port(this, "D4", 0, null);
        this.ports[4] = new Port(this, "D3", 0, null);
        this.ports[5] = new Port(this, "D2", 0, null);
        this.ports[6] = new Port(this, "D1", 0, null);
        this.ports[7] = new Port(this, "D0", 0, null);
        this.undefined = new StdLogic1164();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.dark_gray = new Color(100, 100, 100);
        this.medium_gray = new Color(110, 110, 110);
        this.segments = new ColoredPolyline[17];
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new ColoredPolyline();
            ++i;
        }
        if (this.displayStyle == 14) {
            this.segments[0].initialize("2 700 750 1550 750");
            this.segments[1].initialize("2 1550 750 2400 750");
            this.segments[2].initialize("2 2400 750 2400 1950");
            this.segments[3].initialize("2 2400 1950 2400 3150");
            this.segments[4].initialize("2 1550 3150 2400 3150");
            this.segments[5].initialize("2 700 3150 1550 3150");
            this.segments[6].initialize("2 700 3150 700 1950");
            this.segments[7].initialize("2 700 1950 700 750");
            this.segments[8].initialize("2 750 800 1450 1850");
            this.segments[9].initialize("2 1550 800 1550 1850");
            this.segments[10].initialize("2 1650 1850 2350 800");
            this.segments[11].initialize("2 1550 1950 2350 1950");
            this.segments[12].initialize("2 1650 2050 2350 3050");
            this.segments[13].initialize("2 1550 2050 1550 3100");
            this.segments[14].initialize("2 1450 2050 750 3050");
            this.segments[15].initialize("2 1550 1950 750 1950");
            this.segments[16].initialize("2 1750 2900 1750 3100");
        } else if (this.displayStyle == 13) {
            this.segments[0].initialize("2 900 790 1600 790");
            this.segments[1].initialize("2 1720 790 2400 790");
            this.segments[2].initialize("2 2420 900 2280 1950");
            this.segments[3].initialize("2 2270 2060 2120 3100");
            this.segments[4].initialize("2 1400 3200 2100 3200");
            this.segments[5].initialize("2 600 3200 1300 3200");
            this.segments[6].initialize("2 580 3100 720 2050");
            this.segments[7].initialize("2 730 1940 880 900");
            this.segments[8].initialize("2 1000 910 1380 1880");
            this.segments[9].initialize("2 1660 890 1500 1890");
            this.segments[10].initialize("2 2300 910 1625 1880");
            this.segments[11].initialize("2 1550 2000 2165 2000");
            this.segments[12].initialize("2 1600 2120 2000 3080");
            this.segments[13].initialize("2 1480 2120 1350 3100");
            this.segments[14].initialize("2 1360 2120 705 3080");
            this.segments[15].initialize("2 835 2000 1435 2000");
            this.segments[16].initialize("2 2400 3000 2400 3200");
        } else {
            throw new UnsupportedOperationException("AsciiDisplay: unknown display style: " + this.displayStyle);
        }
        int i2 = 0;
        while (i2 < this.segments.length) {
            FigAttribs attr = this.segments[i2].getAttributes();
            attr.fillStyle = 1;
            attr.currentLayer = 5;
            attr.lineWidth = 150.0;
            attr.fig_cap_style = 1;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segments.length) {
            this.display.fastAddMember(this.segments[i3]);
            ++i3;
        }
        Rectangle r = new Rectangle();
        r.initialize("300 450 2700 3600");
        FigAttribs ra = r.getAttributes();
        ra.fillStyle = 2;
        ra.fillColor = this.dark_gray;
        ra.fig_fill_color = 0;
        ra.fig_area_fill = 20;
        ra.currentLayer = 50;
        r.setAttributes(ra);
        this.display.fastAddMember(r);
        this.display.update_bbox();
        Symbol symbol = this.getSymbol();
        this.display.setObjectPainter(symbol.painter);
        symbol.addMember(this.display);
    }

    private void show() {
        if (this.symbol == null) {
            return;
        }
        this.index = 0;
        int i = 0;
        while (i < this.ports.length) {
            this.index <<= 1;
            Signal signal = this.ports[i].getSignal();
            if (signal != null) {
                StdLogic1164 tmp = (StdLogic1164)((SignalStdLogic1164)signal).getValue();
                if (tmp.intValue() == 3) {
                    ++this.index;
                } else if (tmp.intValue() == 7) {
                    ++this.index;
                } else if (tmp.intValue() != 2 && tmp.intValue() != 6) {
                    this.index = 32;
                    break;
                }
            } else {
                this.index = 32;
                break;
            }
            ++i;
        }
        this.index -= 32;
        if (this.index < 0 || this.index > 63) {
            this.index = 0;
        }
        int i2 = 0;
        while (i2 < this.segments.length) {
            int cindex = CMATRIX[this.index][i2 + 1];
            Color color = cindex == 0 ? this.medium_gray : (cindex == 1 ? Color.red : Color.cyan);
            FigAttribs attr = this.segments[i2].getAttributes();
            attr.lineColor = color;
            attr.fillColor = color;
            if (cindex == 0) {
                attr.fig_line_color = 0;
                attr.fig_fill_color = 0;
                attr.fig_area_fill = 10;
            } else {
                attr.fig_line_color = 4;
                attr.fig_fill_color = 4;
                attr.fig_area_fill = 20;
            }
            this.segments[i2].setAttributes(attr);
            ++i2;
        }
        if (this.getSymbol().painter != null) {
            this.getSymbol().painter.paint(this.display, 100);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.show();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.show();
    }

    public String toString() {
        return "AsciiDisplay: " + this.getFullName() + " [value=" + this.index + "]";
    }
}

