/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.models.imaging.ImageSignal;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.PrintWriter;
import java.io.Serializable;

public class SimpleFilter
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_A;
    protected Port port_Y;
    protected Image inputImage;
    protected Image outputImage;
    protected double t_delay = 0.001;
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public SimpleFilter() {
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = SimpleFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.ports[1] = new Port(this, "Y", 1, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = SimpleFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.port_A = this.ports[0];
        this.port_Y = this.ports[1];
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println("-W- SimpleFilter.elaborate: ignored");
        }
    }

    public void evaluate(Object arg) {
        this.message("-I- " + this.toString() + ".evaluate: " + arg);
        SimKernel simulator = this.parent.getSimulator();
        if (simulator == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_A == null) {
            return;
        }
        if (signal_Y == null) {
            return;
        }
        if (!(signal_A instanceof ImageSignal)) {
            this.message("-E- " + this.toString() + ".evaluate: input not an ImageSignal!");
            return;
        }
        try {
            this.inputImage = (Image)signal_A.getValue();
            if (this.inputImage == null) {
                return;
            }
            this.outputImage = this.filter(this.inputImage);
            simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
        }
        catch (Throwable t) {
            System.out.println("-E- evaluate: " + this.toString());
            t.printStackTrace();
        }
    }

    public Image filter(Image inputImage) {
        this.message("-E- SimpleFilter.filter: ignored!");
        return null;
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w < 0 || h < 0) {
            System.err.println("-E- getBufferedImage: invalid: " + image);
            return null;
        }
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        BufferedImage tmp = new BufferedImage(w, h, 1);
        int j = 0;
        while (j < h) {
            int row = j * w;
            int i = 0;
            while (i < w) {
                tmp.setRGB(i, j, pixels[row + i]);
                ++i;
            }
            ++j;
        }
        return tmp;
    }

    public static BufferedImage getClone(Image image) {
        if (image == null) {
            return null;
        }
        try {
            BufferedImage BI = SimpleFilter.getBufferedImage(image);
            int w = BI.getWidth(null);
            int h = BI.getHeight(null);
            long t1 = System.currentTimeMillis();
            BufferedImage BO = new BufferedImage(w, h, 1);
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    BO.setRGB(x, y, BI.getRGB(x, y));
                    ++x;
                }
                ++y;
            }
            long t2 = System.currentTimeMillis();
            SimpleFilter.msg("-#- SimpleFilter.getClone() ok. (" + (t2 - t1) + " msec.)");
            return BO;
        }
        catch (Throwable t) {
            SimpleFilter.msg("-E- internal: " + t);
            t.printStackTrace();
            return null;
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify filter name:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

