/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ShearFilter
extends ParametrizedFilter {
    public ShearFilter() {
        this.setD0(0.1);
        this.setD1(0.0);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        if (inputImage == null) {
            return null;
        }
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        double shx = this.getD0();
        double shy = this.getD1();
        AffineTransform trafo = new AffineTransform(1.0, shy, shx, 1.0, 0.0, 0.0);
        double[] src = new double[]{0.0, 0.0, 0.0, w, h, 0.0, h, w};
        double[] dst = new double[]{0.0, 0.0, 0.0, w, h, 0.0, h, w};
        trafo.transform(src, 0, dst, 0, 4);
        double dx = Math.min(Math.min(dst[0], dst[2]), Math.min(dst[4], dst[6]));
        double dy = Math.min(Math.min(dst[1], dst[3]), Math.min(dst[5], dst[7]));
        trafo.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        AffineTransformOp atop = new AffineTransformOp(trafo, 2);
        BufferedImage BO = atop.filter(BI, null);
        long t2 = System.currentTimeMillis();
        this.msg("-#- ShearFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "shear x:", "d0", "shear y:", "d1"};
    }
}

