/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ImageSignal;
import hades.models.imaging.ParametrizedFilter;
import hades.signals.Signal;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Random;

public class RandomFilter
extends ParametrizedFilter {
    private Random generator = new Random();

    public RandomFilter() {
        this.setP0(0);
        this.setP1(255);
        this.setP2(0);
        this.setP3(255);
        this.setP4(0);
        this.setP5(255);
        this.setP6(0);
        this.setP7(0);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        int w = this.getP6();
        int h = this.getP7();
        if (w <= 0 || h <= 0) {
            if (inputImage == null) {
                return null;
            }
            BufferedImage BI = this.getBufferedImage(inputImage);
            w = BI.getWidth(null);
            h = BI.getHeight(null);
        }
        BufferedImage BO = new BufferedImage(w, h, 2);
        int r_lower = this._clip(0, 255, this.getP0());
        int r_upper = this._clip(0, 255, this.getP1());
        int g_lower = this._clip(0, 255, this.getP2());
        int g_upper = this._clip(0, 255, this.getP3());
        int b_lower = this._clip(0, 255, this.getP4());
        int b_upper = this._clip(0, 255, this.getP5());
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int r = this._random(r_lower, r_upper);
                int g = this._random(g_lower, g_upper);
                int b = this._random(b_lower, b_upper);
                int rgb = 0xFF000000 | r << 16 | g << 8 | b;
                BO.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- RandomFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    private final int _random(int lower, int upper) {
        int size = upper - lower + 1;
        int val = this.generator.nextInt(size);
        if (val > 255) {
            System.err.println("-E- _random: " + val);
        }
        return lower + val;
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        if (signal_A != null && signal_A instanceof ImageSignal) {
            this.inputImage = (Image)signal_A.getValue();
        }
        try {
            this.outputImage = this.filter(this.inputImage);
            simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
        }
        catch (Throwable t) {
            System.out.println("-E- evaluate: " + this.toString());
            t.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        if (this.port_A.getSignal() == null) {
            if (SimObject.debug) {
                this.msg("-#- RandomFilter.elaborate: no input, scheduling myself.");
            }
            this.evaluate(null);
        }
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "red lower   [0..255]: ", "p0", "red upper   [0..255]: ", "p1", "green lower [0..255]: ", "p2", "green upper [0..255]: ", "p3", "blue lower [0..255]: ", "p4", "blue upper [0..255]: ", "p5", "width  (or 0):", "p6", "height (or 0):", "p7"};
    }
}

