/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class PurpleDetectionFilter
extends ParametrizedFilter {
    public PurpleDetectionFilter() {
        this.setP0(50);
    }

    public Image filter(Image inputImage) {
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 2);
        long t1 = System.currentTimeMillis();
        int diff = this._clip(0, 255, this.getP0());
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                int red = rgb >> 16 & 0xFF;
                int blue = rgb & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int result = blue - green > diff && blue - red > diff ? -1 : -16777216;
                BO.setRGB(x, y, result);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- PurpleDetectionFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "level difference: ", "p0"};
    }
}

