/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.models.imaging.ImageSignal;
import hades.models.imaging.SimpleFilter;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class ParametrizedFilter
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_A;
    protected Port port_Y;
    protected Image inputImage;
    protected Image outputImage;
    protected double t_delay = 0.001;
    protected int p0;
    protected int p1;
    protected int p2;
    protected int p3;
    protected int p4;
    protected int p5;
    protected int p6;
    protected int p7;
    protected double d0;
    protected double d1;
    protected double d2;
    protected double d3;
    protected double d4;
    protected double d5;
    protected double d6;
    protected double d7;
    protected double d8;
    protected double d9;
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public ParametrizedFilter() {
        this.buildPorts();
    }

    public void buildPorts() {
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = ParametrizedFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.ports[1] = new Port(this, "Y", 1, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = ParametrizedFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.port_A = this.ports[0];
        this.port_Y = this.ports[1];
    }

    public void elaborate(Object arg) {
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_A == null) {
            return;
        }
        if (signal_Y == null) {
            return;
        }
        if (signal_A instanceof ImageSignal) {
            this.inputImage = (Image)signal_A.getValue();
        }
        try {
            if (this.inputImage == null) {
                return;
            }
            this.outputImage = this.filter(this.inputImage);
            simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
        }
        catch (Throwable t) {
            System.out.println("-E- evaluate: " + this.toString());
            t.printStackTrace();
        }
    }

    public Image filter(Image inputImage) {
        this.message("-E- internal: don't call filter on a ParametrizedFilter!");
        return null;
    }

    public BufferedImage getBufferedImage(Image image) {
        return SimpleFilter.getBufferedImage(image);
    }

    public BufferedImage getClone(Image image) {
        return SimpleFilter.getClone(image);
    }

    public void checkApplyCallsEvaluate() {
        block3: {
            if (!SetupManager.getBoolean("hades.models.imaging.ParametrizedFilter.applyCallsEvaluate", false)) break block3;
            try {
                if (this.simulator != null) {
                    this.evaluate(null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void applyValuesHook() {
        System.out.println("-#- applyValuesHook...");
        this.checkApplyCallsEvaluate();
    }

    public int getP0() {
        return this.p0;
    }

    public int getP1() {
        return this.p1;
    }

    public int getP2() {
        return this.p2;
    }

    public int getP3() {
        return this.p3;
    }

    public int getP4() {
        return this.p4;
    }

    public int getP5() {
        return this.p5;
    }

    public int getP6() {
        return this.p6;
    }

    public int getP7() {
        return this.p7;
    }

    public void setP0(int v) {
        this.p0 = v;
    }

    public void setP1(int v) {
        this.p1 = v;
    }

    public void setP2(int v) {
        this.p2 = v;
    }

    public void setP3(int v) {
        this.p3 = v;
    }

    public void setP4(int v) {
        this.p4 = v;
    }

    public void setP5(int v) {
        this.p5 = v;
    }

    public void setP6(int v) {
        this.p6 = v;
    }

    public void setP7(int v) {
        this.p7 = v;
    }

    public void setP0(String s) {
        this.setP0(this._toInt(s));
    }

    public void setP1(String s) {
        this.setP1(this._toInt(s));
    }

    public void setP2(String s) {
        this.setP2(this._toInt(s));
    }

    public void setP3(String s) {
        this.setP3(this._toInt(s));
    }

    public void setP4(String s) {
        this.setP4(this._toInt(s));
    }

    public void setP5(String s) {
        this.setP5(this._toInt(s));
    }

    public void setP6(String s) {
        this.setP6(this._toInt(s));
    }

    public void setP7(String s) {
        this.setP7(this._toInt(s));
    }

    public double getD0() {
        return this.d0;
    }

    public double getD1() {
        return this.d1;
    }

    public double getD2() {
        return this.d2;
    }

    public double getD3() {
        return this.d3;
    }

    public double getD4() {
        return this.d4;
    }

    public double getD5() {
        return this.d5;
    }

    public double getD6() {
        return this.d6;
    }

    public double getD7() {
        return this.d7;
    }

    public double getD8() {
        return this.d8;
    }

    public double getD9() {
        return this.d9;
    }

    public void setD0(double v) {
        this.d0 = v;
    }

    public void setD1(double v) {
        this.d1 = v;
    }

    public void setD2(double v) {
        this.d2 = v;
    }

    public void setD3(double v) {
        this.d3 = v;
    }

    public void setD4(double v) {
        this.d4 = v;
    }

    public void setD5(double v) {
        this.d5 = v;
    }

    public void setD6(double v) {
        this.d6 = v;
    }

    public void setD7(double v) {
        this.d7 = v;
    }

    public void setD8(double v) {
        this.d8 = v;
    }

    public void setD9(double v) {
        this.d9 = v;
    }

    public void setD0(String s) {
        this.setD0(this._toDouble(s));
    }

    public void setD1(String s) {
        this.setD1(this._toDouble(s));
    }

    public void setD2(String s) {
        this.setD2(this._toDouble(s));
    }

    public void setD3(String s) {
        this.setD3(this._toDouble(s));
    }

    public void setD4(String s) {
        this.setD4(this._toDouble(s));
    }

    public void setD5(String s) {
        this.setD5(this._toDouble(s));
    }

    public void setD6(String s) {
        this.setD6(this._toDouble(s));
    }

    public void setD7(String s) {
        this.setD7(this._toDouble(s));
    }

    public void setD8(String s) {
        this.setD8(this._toDouble(s));
    }

    public void setD9(String s) {
        this.setD9(this._toDouble(s));
    }

    public int _toInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable t) {
            this.message("-W- ParametrizedFilter._toInt: invalid string '" + s + "'");
            return 0;
        }
    }

    public double _toDouble(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (Throwable t) {
            this.message("-W- ParametrizedFilter._toDouble: invalid string '" + s + "'");
            return 0.0;
        }
    }

    public int _clip(int min, int max, int value) {
        if (value >= max) {
            return max;
        }
        if (value <= min) {
            return min;
        }
        return value;
    }

    public double _dclip(double min, double max, double value) {
        if (value >= max) {
            return max;
        }
        if (value <= min) {
            return min;
        }
        return value;
    }

    public double _interpolate(double min, double max, double value) {
        if (value <= 0.0) {
            return min;
        }
        if (value >= 1.0) {
            return max;
        }
        return min + value * (max - min);
    }

    public String[] getPropertySheetFieldNamesAll() {
        return new String[]{"instance name:", "name"};
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "parameter 0:", "p0", "parameter 1:", "p1", "parameter 2:", "p2", "parameter 3:", "p3", "parameter 4:", "p4", "parameter 5:", "p5", "parameter 6:", "p6", "parameter 7:", "p7", "double 0:", "d0", "double 1:", "d1", "double 2:", "d2", "double 3:", "d3", "double 4:", "d4", "double 5:", "d5", "double 6:", "d6", "double 7:", "d7", "double 8:", "d8", "double 9:", "d9"};
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = this.getPropertySheetFieldNames();
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify filter parameters:");
        this.propertySheet.setVisible(true);
    }

    public SimObject copy() {
        try {
            ParametrizedFilter tmp = (ParametrizedFilter)this.clone();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setVersionId(this.getVersionId());
            tmp.setP0(this.getP0());
            tmp.setP1(this.getP1());
            tmp.setP2(this.getP2());
            tmp.setP3(this.getP3());
            tmp.setP4(this.getP4());
            tmp.setP5(this.getP5());
            tmp.setP6(this.getP6());
            tmp.setP7(this.getP7());
            tmp.setD0(this.getD0());
            tmp.setD1(this.getD1());
            tmp.setD2(this.getD2());
            tmp.setD3(this.getD3());
            tmp.setD4(this.getD4());
            tmp.setD5(this.getD5());
            tmp.setD6(this.getD6());
            tmp.setD7(this.getD7());
            tmp.setD8(this.getD8());
            tmp.setD9(this.getD9());
            return tmp;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = this._toInt(st.nextToken());
            this.setP0(st.nextToken());
            this.setP1(st.nextToken());
            this.setP2(st.nextToken());
            this.setP3(st.nextToken());
            this.setP4(st.nextToken());
            this.setP5(st.nextToken());
            this.setP6(st.nextToken());
            this.setP7(st.nextToken());
            this.setD0(st.nextToken());
            this.setD1(st.nextToken());
            this.setD2(st.nextToken());
            this.setD3(st.nextToken());
            this.setD4(st.nextToken());
            this.setD5(st.nextToken());
            this.setD6(st.nextToken());
            this.setD7(st.nextToken());
            this.setD8(st.nextToken());
            this.setD9(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- in ParametrizedFilter.initialize: " + e);
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.p0 + " " + this.p1 + " " + this.p2 + " " + this.p3 + " " + this.p4 + " " + this.p5 + " " + this.p6 + " " + this.p7 + " " + " " + this.d0 + " " + this.d1 + " " + this.d2 + " " + this.d3 + " " + this.d4 + " " + this.d5 + " " + this.d6 + " " + this.d7 + " " + this.d8 + " " + this.d9);
    }

    public void msg(String s) {
        System.out.println(s);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

