/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.SimpleFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class InvertFilter
extends SimpleFilter {
    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = SimpleFilter.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                int alpha = rgb & 0xFF000000;
                int red = 0xFF0000 - (rgb & 0xFF0000);
                int green = 65280 - (rgb & 0xFF00);
                int blue = 255 - (rgb & 0xFF);
                int result = alpha | red | green | blue;
                BO.setRGB(x, y, result);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        SimpleFilter.msg("-#- InvertFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }
}

