/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class InsideRangeFilter
extends ParametrizedFilter {
    public Image filter(Image image) {
        if (image == null) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(image);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        int r_lower = (this.getP0() & 0xFF) << 16;
        int r_upper = (this.getP1() & 0xFF) << 16;
        int g_lower = (this.getP2() & 0xFF) << 8;
        int g_upper = (this.getP3() & 0xFF) << 8;
        int b_lower = this.getP4() & 0xFF;
        int b_upper = this.getP5() & 0xFF;
        BufferedImage BO = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int tmp = BI.getRGB(i, j);
                boolean b = (tmp & 0xFF0000) >= r_lower && (tmp & 0xFF0000) <= r_upper && (tmp & 0xFF00) >= g_lower && (tmp & 0xFF00) <= g_upper && (tmp & 0xFF) >= b_lower && (tmp & 0xFF) <= b_upper;
                BO.setRGB(i, j, b ? -1 : -16777216);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- InsideRangeFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "r lower:", "p0", "r upper:", "p1", "g lower:", "p2", "g upper:", "p3", "b lower:", "p4", "b upper:", "p5"};
    }
}

