/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.models.imaging.ImageSignal;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;
import jfig.utils.PPMWriter;

public class ImageWriter
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_A = new Port(this, "A", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = ImageWriter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
    protected Image image;
    protected String filename;
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public ImageWriter() {
        this.ports = new Port[1];
        this.ports[0] = this.port_A;
        this.image = null;
    }

    public void elaborate(Object arg) {
    }

    public void evaluate(Object arg) {
        Signal signal;
        if (SimObject.debug) {
            this.message("-I- ImageWriter.evaluate: " + arg);
        }
        if ((signal = this.port_A.getSignal()) == null) {
            return;
        }
        if (signal instanceof ImageSignal) {
            this.image = (Image)signal.getValue();
        }
        if (this.image != null) {
            this.writeImage();
        }
    }

    public void writeImage() {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.filename)));
            PPMWriter writer = new PPMWriter();
            writer.writePPM(this.image, dos);
            dos.flush();
            dos.close();
        }
        catch (Throwable t) {
            System.err.println("-E- " + t);
            t.printStackTrace();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String s) {
        this.filename = s;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "filename:", "filename"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.filename = NameMangler.decodeUnicodeEscapes(st.nextToken());
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.filename));
    }

    public String toString() {
        return "ImageWriter: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

