/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.SimpleFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class GrayFilter
extends SimpleFilter {
    public Image filter(Image inputImage) {
        BufferedImage BI = SimpleFilter.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 1);
        long t1 = System.currentTimeMillis();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                int alpha = -16777216;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                int gray = 307 * red + 604 * green + 113 * blue >> 10 & 0xFF;
                int result = alpha | gray << 16 | gray << 8 | gray;
                BO.setRGB(x, y, result);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        SimpleFilter.msg("-#- GrayFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }
}

