/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.models.imaging.SimpleFilter;
import hades.simulator.SimObject;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jfig.gui.ImageHelper;

public class GaussFilter
extends SimpleFilter {
    private int radius = 3;
    int x;
    int y;
    int w;
    int h;
    int[] pixels;
    int[] r_pixels;
    int[] g_pixels;
    int[] b_pixels;
    int[] r_result;
    int[] g_result;
    int[] b_result;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void setRadius(String s) {
        try {
            this.radius = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.message("-E- Error in setRadius: " + e);
            this.radius = 3;
        }
    }

    public Image filter(Image inputImage) {
        int w = inputImage.getWidth(null);
        int h = inputImage.getHeight(null);
        SimpleFilter.msg("-#- GaussFilter: " + w + " x " + h);
        long t1 = System.currentTimeMillis();
        this.getPixels(inputImage);
        this.extractRGBPlanes();
        this.createResultPlanes();
        this.filterPlane(this.r_result, this.r_pixels, w, h);
        this.filterPlane(this.g_result, this.g_pixels, w, h);
        this.filterPlane(this.b_result, this.b_pixels, w, h);
        this.mergeRGB();
        long t2 = System.currentTimeMillis();
        SimpleFilter.msg("-#- GaussFilter: ok. (" + (t2 - t1) + " msec.)");
        return this.createImageFromPixels();
    }

    public void getPixels(Image image) {
        this.dbg("-#- getPixels...");
        this.x = 0;
        this.y = 0;
        this.w = image.getWidth(null);
        this.h = image.getHeight(null);
        this.pixels = new int[this.w * this.h];
        PixelGrabber pg = new PixelGrabber(image, this.x, this.y, this.w, this.h, this.pixels, 0, this.w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
    }

    public void extractRGBPlanes() {
        this.dbg("-#- extractRGBPlanes...");
        int n_pixels = this.w * this.h;
        this.r_pixels = new int[n_pixels];
        this.g_pixels = new int[n_pixels];
        this.b_pixels = new int[n_pixels];
        int i = 0;
        while (i < n_pixels) {
            int rgb = this.pixels[i];
            this.r_pixels[i] = rgb >> 16 & 0xFF;
            this.g_pixels[i] = rgb >> 8 & 0xFF;
            this.b_pixels[i] = rgb & 0xFF;
            ++i;
        }
    }

    public void createResultPlanes() {
        int n_pixels = this.w * this.h;
        this.r_result = new int[n_pixels];
        this.g_result = new int[n_pixels];
        this.b_result = new int[n_pixels];
    }

    public void mergeRGB() {
        this.dbg("-#- mergeRGB...");
        int n_pixels = this.w * this.h;
        int i = 0;
        while (i < n_pixels) {
            this.pixels[i] = 0xFF000000 | this.r_result[i] << 16 | this.g_result[i] << 8 | this.b_result[i];
            ++i;
        }
    }

    public void filterPlane(int[] result, int[] source, int w, int h) {
        this.dbg("-#- filterPlane... [" + w + "x" + h + "]");
        int j = 2;
        while (j < h - 2) {
            int row = j * w;
            int i = 2;
            while (i < w - 2) {
                int index = row + i;
                int sum = source[index] + source[index - 1] + source[index + 1] + source[index - w] + source[index - w - 1] + source[index - w + 1] + source[index + w - 1] + source[index + w - 1] + source[index + w + 1];
                result[index] = sum / 9;
                ++i;
            }
            ++j;
        }
        this.dbg("-#- filterPixels ok.");
    }

    public Image createImageFromPixels() {
        this.dbg("-#- createImageFromPixels1...");
        Image img = ImageHelper.createImage(new MemoryImageSource(this.w, this.h, this.pixels, 0, this.w));
        this.dbg("-#- createImageFromPixels2...");
        return img;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "filter radius [3,5,...]:", "radius"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify filter name and radius:");
        this.propertySheet.setVisible(true);
    }

    public void dbg(String msg) {
        this.message(msg);
    }

    public String toString() {
        return "GaussFilter: " + this.getFullName();
    }
}

