/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class CropFilter
extends ParametrizedFilter {
    public CropFilter() {
        this.setP0(0);
        this.setP1(0);
        this.setP2(100);
        this.setP3(100);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        int xx = this._clip(0, w, this.getP0());
        int yy = this._clip(0, h, this.getP1());
        int ww = this._clip(0, w - xx, this.getP2());
        int hh = this._clip(0, h - yy, this.getP3());
        BufferedImage BO = new BufferedImage(ww, hh, 1);
        int j = 0;
        while (j < hh) {
            int i = 0;
            while (i < ww) {
                int pixel = BI.getRGB(i + xx, j + yy);
                BO.setRGB(i, j, pixel);
                ++i;
            }
            ++j;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- CropFilter: " + ww + "x" + hh + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "left offset x0:", "p0", "top offset y0:", "p1", "crop width:", "p2", "crop height:", "p3"};
    }
}

