/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class CatVFilter
extends TwoInputFilter {
    public CatVFilter() {
        this.setP0(0);
        this.setP1(0);
    }

    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage A = this.getBufferedImage(image_A);
        BufferedImage B = this.getBufferedImage(image_B);
        if (A == null || B == null) {
            return null;
        }
        int wa = A.getWidth(null);
        int ha = A.getHeight(null);
        int wb = B.getWidth(null);
        int hb = B.getHeight(null);
        int w = Math.min(wa, wb);
        int h = ha + hb;
        BufferedImage R = new BufferedImage(w, h, 2);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < ha) {
                int pixa = A.getRGB(i, j);
                R.setRGB(i, j, pixa);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < w) {
            int j = 0;
            while (j < hb) {
                int pixb = B.getRGB(i2, j);
                R.setRGB(i2, ha + j, pixb);
                ++j;
            }
            ++i2;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- CatVFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name"};
    }
}

