/*
 * Decompiled with CFR 0.152.
 */
package hades.models.hagen;

import hades.models.StdLogic1164;
import hades.models.register.Register;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ClassLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class SimpleShiftRegister
extends Register {
    protected Port port_NR;
    protected Port port_Sin;
    protected Port port_Sout;
    protected String rawInitData;

    protected int getDefaultBitWidth() {
        return 8;
    }

    protected boolean showDInputPorts() {
        return false;
    }

    protected void initPortsAndData() {
        if (this.n_bits < 0 || this.n_bits > 32) {
            this.message("-W- invalid number of bits: " + this.n_bits);
            this.message("-W- using 1 bit instead");
            this.n_bits = 1;
        }
        this.ports = new Port[this.n_bits + this.n_bits + 3];
        int i = 0;
        int j = 0;
        while (j < this.n_bits) {
            this.ports[i++] = new Port(this, "D" + j, 3, null);
            ++j;
        }
        int j2 = 0;
        while (j2 < this.n_bits) {
            this.ports[i++] = new Port(this, "Q" + j2, 1, null);
            ++j2;
        }
        this.ports[i] = new Port(this, "C", 0, null);
        this.port_C = this.ports[i];
        this.ports[++i] = new Port(this, "NR", 0, null);
        this.port_NR = this.ports[i];
        this.ports[++i] = new Port(this, "Sin", 0, null);
        this.port_Sin = this.ports[i];
        ++i;
        this.data = new StdLogic1164[this.n_bits];
        int j3 = 0;
        while (j3 < this.n_bits) {
            this.data[j3] = this.value_U;
            ++j3;
        }
    }

    protected void createGlobalPortSymbols() {
        int xmax = (this.n_bits + 1) * 1200;
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 450 " + "ShiftReg" + this.n_bits);
        PortSymbol clockSymbol = new PortSymbol();
        clockSymbol.initialize("600 0 C");
        PortSymbol resetSymbol = new PortSymbol();
        resetSymbol.initialize("0 600 NR");
        PortLabel resetLabel = new PortLabel();
        resetLabel.initialize("150 800 NR");
        PortSymbol shiftInSymbol = new PortSymbol();
        shiftInSymbol.initialize("" + xmax + " 600 Sin");
        PortLabel shiftInLabel = new PortLabel();
        shiftInLabel.initialize("" + (xmax - 150) + " 400 3 Sin");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(clockSymbol);
        this.symbol.fastAddMember(resetSymbol);
        this.symbol.fastAddMember(resetLabel);
        this.symbol.fastAddMember(shiftInSymbol);
        this.symbol.fastAddMember(shiftInLabel);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        try {
            int i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X.copy();
                this.data[i].setValue(this.rawInitData.charAt(i));
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-W- SimpleShiftRegister: initialization failed." + e);
        }
        this.schedule(0.0 + this.t_pass);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate...");
        }
        StdLogic1164 value_NR = null;
        StdLogic1164 value_C = null;
        double time = this.simulator.getSimTime() + this.t_pass;
        Signal signal_NR = this.port_NR.getSignal();
        value_NR = signal_NR != null ? (StdLogic1164)signal_NR.getValue() : this.value_U;
        Signal signal_C = this.port_C.getSignal();
        value_C = signal_C != null ? (StdLogic1164)signal_C.getValue() : this.value_U;
        if (value_NR.is_0()) {
            int i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_0;
                ++i;
            }
        } else if (!value_NR.is_1()) {
            int i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C == null) {
            int i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C.hasEvent() && value_C.is_1()) {
            int i = this.n_bits - 1;
            while (i > 0) {
                this.data[i] = this.data[i - 1];
                --i;
            }
            Signal signal_tmp = this.port_Sin.getSignal();
            this.data[0] = signal_tmp == null ? this.value_X : ((StdLogic1164)signal_tmp.getValue()).copy();
        } else {
            return;
        }
        this.schedule(time);
    }

    public void schedule(double time) {
        this.show();
        int i = 0;
        while (i < this.n_bits) {
            Port port_Q = this.ports[this.n_bits + i];
            SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
            if (signal_Q != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[i], (Object)port_Q));
            }
            ++i;
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.t_pass);
        ps.print(" ");
        int i = 0;
        while (i < this.n_bits) {
            ps.print(this.data[i].getChar());
            ++i;
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            int n_new = Integer.parseInt(st.nextToken());
            this.t_pass = Double.valueOf(st.nextToken());
            this.setBitWidth(n_new);
            if (SimObject.debug) {
                this.message("-I- Register.initialize: " + this.toString());
            }
            this.rawInitData = st.nextToken();
        }
        catch (Exception e) {
            this.message("-E- Register.initialize(): " + e + " " + s);
        }
        return true;
    }

    public SimObject copy() {
        SimpleShiftRegister tmp = null;
        try {
            tmp = (SimpleShiftRegister)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setBitWidth(this.getBitWidth());
            tmp.setPassTime(this.getPassTime());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimpleShiftRegister.copy: " + e);
            return null;
        }
    }

    public String toString() {
        return "SimpleShiftRegister<" + this.n_bits + ">: " + this.getFullName();
    }
}

