/*
 * Decompiled with CFR 0.152.
 */
package hades.models.gates;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.ContextToolTip;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;

public class GenericGate
extends SimObject
implements Simulatable,
ContextToolTip,
Serializable {
    private static final long serialVersionUID = -4251973973608991062L;
    protected double t_delay = 5.0E-9;

    public double getDelay() {
        return this.t_delay;
    }

    public void setDelay(double t) {
        this.t_delay = t;
    }

    public void setDelay(String s) {
        try {
            this.t_delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- GenericGate.setDelay(): " + e);
            this.t_delay = 5.0E-9;
            this.message("-I- resetting to default value, delay = " + this.t_delay);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (n_tokens == 2) {
                this.t_delay = Double.valueOf(st.nextToken());
            }
            if (SimObject.debug) {
                this.message("GenericGate.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- GenericGate.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_delay);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void scheduleEvent(Signal signal, double time, StdLogic1164 value, Port port) {
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleEventAfter(Signal signal, double delay, StdLogic1164 value, Port port) {
        double time = this.simulator.getSimTime() + delay;
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleOutputValue(Port port, StdLogic1164 value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleOutputValueAfter(Port port, StdLogic1164 value, double delay) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public SimObject copy() {
        GenericGate clone = (GenericGate)super.copy();
        clone.setDelay(this.getDelay());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay=" + this.t_delay;
    }
}

