/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.FSM;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;

public class FsmRenderer
extends FigRectangle
implements Serializable {
    protected Point position;
    protected FSM fsm;

    public FsmRenderer() {
        super(0, 0, 0, 0, 60);
        this.build_attribs();
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            Point[] pp = new Point[2];
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[0] = new Point(x, y);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[1] = new Point(x, y);
            super.setPoints(pp);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public void setFSM(FSM fsm) {
        this.fsm = fsm;
    }

    private void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.fillColor = attribs.lineColor = ColorCache.getColorCache().get(7);
        attribs.fillStyle = 2;
        attribs.currentLayer = 60;
        attribs.lineWidth = 0.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.cornerRadius = 0;
        attribs.fontSize = 10;
        attribs.fig_font = 16;
        attribs.fig_line_color = 11;
        attribs.fig_fill_color = 7;
        super.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " ";
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public void paint(Graphics g, FigTrafo2D trafo) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.debug) {
            this.message("-I- FsmRenderer.paint()...");
        }
        if (!this.visible) {
            return;
        }
        super.build_sc_bbox();
        FigBbox bbox = super.get_sc_bbox();
        int x1 = bbox.getXl();
        int y1 = bbox.getYt();
        int x2 = bbox.getXr();
        int y2 = bbox.getYb();
        g.setColor(Color.black);
        if (this.fsm != null) {
            this.fsm.drawFSM(x1 + 10, y1 + 10, x2 - x1 - 10, y2 - y1 - 10, g, this.fsm.currentState, this.fsm.getAktivierteTransitionen());
        } else {
            g.drawString("No FSM!", x1 + 10, (y1 + y2) / 2);
        }
    }

    public FigObject copy() {
        FsmRenderer carbon = new FsmRenderer();
        carbon.setAttributes(this.getAttributes());
        carbon.setPoints(this.getPoints());
        carbon.setFSM(this.getFSM());
        return carbon;
    }

    public String toString() {
        return "FsmRenderer[" + super.toString() + "]";
    }
}

