/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.BadExpressionException;
import hades.models.fsm.FSM;
import hades.models.fsm.Parser;
import hades.models.fsm.Signal;
import hades.models.fsm.Transition;
import hades.models.fsm.Zustand;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class FSMtester
extends Dialog
implements Runnable,
ActionListener {
    private Button cancel;
    private Thread tester;
    private TextArea text;
    private Parser parser;
    private FSM fsm;
    private int OK = 0;

    public FSMtester(Frame p, FSM Fsm) {
        super(p, "FSM testen", true);
        this.fsm = Fsm;
        this.addWindowListener(new EditWindowListener());
        this.parser = new Parser();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        Insets ins = new Insets(0, 0, 0, 0);
        this.text = new TextArea();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ins.top = 5;
        ins.bottom = 5;
        ins.left = 5;
        ins.right = 5;
        gbc.insets = ins;
        gbl.setConstraints(this.text, gbc);
        this.add(this.text);
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        ins.top = 5;
        ins.bottom = 5;
        ins.left = 5;
        ins.right = 5;
        gbc.insets = ins;
        gbl.setConstraints(this.cancel, gbc);
        this.add(this.cancel);
        this.tester = new Thread(this);
        this.tester.start();
    }

    public void run() {
        Zustand zu;
        int i;
        this.OK = 0;
        this.text.setText("Teste Zustaende ...\n");
        boolean error = false;
        boolean start = false;
        if (this.fsm.zustaende.size() == 0) {
            this.text.append("keine Zustaende vorhanden\n");
            ++this.OK;
        } else {
            i = 0;
            while (i < this.fsm.zustaende.size()) {
                zu = (Zustand)this.fsm.zustaende.elementAt(i);
                if (zu.isStart) {
                    start = true;
                }
                Thread.yield();
                int j = 0;
                while (j < this.fsm.outputs.size()) {
                    try {
                        this.parser.parse((String)zu.outputHash.get((Signal)this.fsm.outputs.elementAt(j)), this.fsm.inputs);
                    }
                    catch (BadExpressionException e) {
                        this.text.append("Fehler bei " + zu.name + " in Output-Fkt fuer " + ((Signal)this.fsm.outputs.elementAt((int)j)).name + "\n");
                        error = true;
                        ++this.OK;
                    }
                    ++j;
                }
                ++i;
            }
            if (!start) {
                this.text.append("kein Startzustand definiert\n");
                ++this.OK;
            } else if (!error) {
                this.text.append("OK\n");
            }
        }
        this.text.append("\nTeste Transitionen ...\n");
        error = false;
        if (this.fsm.transitionen.size() == 0) {
            this.text.append("keine Transitionen vorhanden\n");
            ++this.OK;
        } else {
            i = 0;
            while (i < this.fsm.transitionen.size()) {
                Transition tr = (Transition)this.fsm.transitionen.elementAt(i);
                Thread.yield();
                if (!tr.function.equals("*")) {
                    try {
                        this.parser.parse(tr.function, this.fsm.inputs);
                    }
                    catch (BadExpressionException e) {
                        this.text.append("Fehler in der Uebergangsfunktion der Transition von " + tr.von.name + " nach " + tr.nach.name + "\n");
                        error = true;
                        ++this.OK;
                    }
                }
                ++i;
            }
            if (!error) {
                this.text.append("OK\n");
            }
        }
        this.text.append("\nTeste Belegungen ...\n");
        Vector relevant = new Vector(10, 10);
        int i2 = 0;
        while (i2 < this.fsm.zustaende.size()) {
            relevant = this.fsm.inputs;
            int index = 0;
            error = false;
            zu = (Zustand)this.fsm.zustaende.elementAt(i2);
            if (!this.durchgehen(relevant, index, zu, error)) {
                this.text.append(zu.name + " OK\n");
            }
            Thread.yield();
            ++i2;
        }
        this.text.append("Fertig!\n");
        if (this.OK == 0) {
            this.text.append("Der Automat ist fehlerfrei.");
        } else {
            this.text.append("Der Automat enthaelt " + this.OK + " Fehler.");
        }
        this.cancel.setLabel("OK");
    }

    private boolean durchgehen(Vector relevant, int index, Zustand zu, boolean error) {
        if (index == relevant.size()) {
            int aktiviert = 0;
            int stern = 0;
            int i = 0;
            while (i < this.fsm.transitionen.size()) {
                Transition t = (Transition)this.fsm.transitionen.elementAt(i);
                if (t.von == zu) {
                    if (t.function.equals("*")) {
                        ++stern;
                    } else {
                        try {
                            if (this.parser.parse(t.function, this.fsm.inputs)) {
                                ++aktiviert;
                            }
                        }
                        catch (BadExpressionException e) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            if (stern > 1) {
                this.text.append("in " + zu + " haben mehr als eine Transition einen * in der Uebergangsfunktion\n");
                error = true;
                ++this.OK;
            } else if (aktiviert == 0) {
                if (stern != 1) {
                    this.text.append("in " + zu.name + " ist unter der Belegung ");
                    int i2 = 0;
                    while (i2 < relevant.size()) {
                        this.text.append(((Signal)relevant.elementAt((int)i2)).name + "=" + ((Signal)relevant.elementAt((int)i2)).value + ",  ");
                        ++i2;
                    }
                    this.text.append("keine Transition aktiviert\n");
                    error = true;
                    ++this.OK;
                }
            } else if (aktiviert > 1) {
                this.text.append("im " + zu.name + " sind unter der Belegung ");
                int i3 = 0;
                while (i3 < relevant.size()) {
                    this.text.append(((Signal)relevant.elementAt((int)i3)).name + "=" + ((Signal)relevant.elementAt((int)i3)).value + ",  ");
                    ++i3;
                }
                this.text.append(aktiviert + " Transitionen aktiviert\n");
                error = true;
                ++this.OK;
            }
            return error;
        }
        Signal input = (Signal)relevant.elementAt(index);
        input.value = 0;
        error = this.durchgehen(relevant, index + 1, zu, error);
        input.value = 1;
        error = this.durchgehen(relevant, index + 1, zu, error);
        return error;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cancel) {
            this.dispose();
        }
    }

    class EditWindowListener
    extends WindowAdapter {
        EditWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            FSMtester.this.dispose();
        }
    }
}

