/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.BadExpressionException;
import hades.models.fsm.FSM;
import hades.models.fsm.Parser;
import hades.models.fsm.Signal;
import hades.models.fsm.Transition;
import hades.models.fsm.Zustand;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public class ExportFSM
extends Dialog
implements Runnable,
ActionListener {
    private Button ok;
    private TextArea text;
    private FSM fsm;
    private Parser parser = new Parser();
    private Thread export;
    private String s;

    public ExportFSM(Frame p, FSM Fsm, String str) {
        super(p, "JavaFSM nach " + str, true);
        this.fsm = Fsm;
        this.s = str;
        this.addWindowListener(new EditWindowListener());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        Insets ins = new Insets(0, 0, 0, 0);
        this.text = new TextArea();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ins.top = 5;
        ins.bottom = 5;
        ins.left = 5;
        ins.right = 5;
        gbc.insets = ins;
        gbl.setConstraints(this.text, gbc);
        this.add(this.text);
        this.ok = new Button("Cancel");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        ins.top = 5;
        ins.bottom = 5;
        ins.left = 5;
        ins.right = 5;
        gbc.insets = ins;
        gbl.setConstraints(this.ok, gbc);
        this.add(this.ok);
        this.export = new Thread(this);
        this.export.start();
    }

    public void run() {
        if (this.s.toUpperCase().equals("VHDL")) {
            this.generateVHDL();
        } else if (this.s.toUpperCase().equals("KISS")) {
            this.generateKISS();
        } else {
            this.text.setText("interner Fehler !");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.ok) {
            this.dispose();
        }
    }

    private void generateVHDL() {
        String typ = "MEALY";
        if (this.fsm.getMachineType() == 0) {
            typ = "MOORE";
        }
        this.text.setText("Library IEEE;\n");
        this.text.append("use IEEE.std_logic_1164.all;\n\n");
        this.text.append("--" + this.fsm.getName() + "\n\n");
        this.text.append("entity " + typ + " is                    -- " + typ + " machine\n");
        this.text.append("  port(");
        int i = 0;
        while (i < this.fsm.inputs.size()) {
            this.text.append(((Signal)this.fsm.inputs.elementAt((int)i)).name + ", ");
            ++i;
        }
        this.text.append("CLOCK: in STD_LOGIC;\n");
        this.text.append("       ");
        int i2 = 0;
        while (i2 < this.fsm.outputs.size()) {
            this.text.append(((Signal)this.fsm.outputs.elementAt((int)i2)).name + ", ");
            ++i2;
        }
        this.text.setText(this.text.getText().substring(0, this.text.getText().length() - 2));
        this.text.append(": out STD_LOGIC);\n");
        this.text.append("end;\n\n");
        this.text.append("architecture BEHAVIOR of " + typ + " is\n");
        this.text.append("  type STATE_TYPE is (");
        int i3 = 0;
        while (i3 < this.fsm.zustaende.size()) {
            this.text.append(this.StrConv(((Zustand)this.fsm.zustaende.elementAt((int)i3)).name) + ", ");
            ++i3;
        }
        this.text.setText(this.text.getText().substring(0, this.text.getText().length() - 2));
        this.text.append(");\n  signal CURRENT_STATE, NEXT_STATE: STATE_TYPE;\n)");
        this.text.append("begin\n\n");
        this.text.append("  -- Process to hold combinational logic\n");
        this.text.append("  COMBIN: process(CURRENT_STATE");
        int i4 = 0;
        while (i4 < this.fsm.inputs.size()) {
            this.text.append(", " + ((Signal)this.fsm.inputs.elementAt((int)i4)).name);
            ++i4;
        }
        this.text.append(")\n  begin\n");
        this.text.append("    case CURRENT_STATE is\n");
        int i5 = 0;
        while (i5 < this.fsm.zustaende.size()) {
            Zustand zu = (Zustand)this.fsm.zustaende.elementAt(i5);
            this.text.append("      when " + this.StrConv(zu.name) + " =>\n");
            int j = 0;
            while (j < this.fsm.outputs.size()) {
                Signal sig = (Signal)this.fsm.outputs.elementAt(j);
                String tmp = ((String)((Zustand)this.fsm.zustaende.elementAt((int)i5)).outputHash.get(sig)).trim();
                if (tmp.equals("0") || tmp.equals("1")) {
                    this.text.append("          " + sig.name + " <= '" + tmp + "';\n");
                } else {
                    this.text.append("          if (" + this.FuncConv(tmp) + ") then \n");
                    this.text.append("            " + sig.name + " <= '1';\n");
                    this.text.append("          else\n");
                    this.text.append("            " + sig.name + " <= '0';\n");
                    this.text.append("          end if;\n");
                }
                ++j;
            }
            Transition stern = null;
            boolean added = false;
            this.text.append("          ");
            int k = 0;
            while (k < this.fsm.transitionen.size()) {
                Transition tr = (Transition)this.fsm.transitionen.elementAt(k);
                if (zu == tr.von) {
                    if (tr.function.trim().equals("*")) {
                        stern = tr;
                    } else {
                        added = true;
                        this.text.append("if (" + this.FuncConv(tr.function) + ") then\n");
                        this.text.append("            NEXT_STATE <= " + this.StrConv(tr.nach.name) + ";\n");
                        this.text.append("          els");
                    }
                }
                ++k;
            }
            if (stern != null) {
                if (added) {
                    this.text.append("e\n            ");
                }
                this.text.append("NEXT_STATE <= " + this.StrConv(stern.nach.name) + ";\n");
                if (added) {
                    this.text.append("          end if;\n");
                }
            } else {
                this.text.setText(this.text.getText().substring(0, this.text.getText().length() - 3));
                this.text.append("end if;\n");
            }
            ++i5;
        }
        this.text.append("    end case;\n");
        this.text.append("  end process;\n\n");
        this.text.append("  -- Process to hold synchronous elements (flip-flops)\n");
        this.text.append("  SYNCH: process\n");
        this.text.append("  begin\n");
        this.text.append("    wait until CLOCK'event and CLOCK = '1';\n");
        this.text.append("    CURRENT_STATE <= NEXT_STATE;\n");
        this.text.append("  end process;\n");
        this.text.append("end BEHAVIOR;\n");
        this.ok.setLabel("OK");
    }

    private void generateKISS() {
        Zustand zu;
        boolean[] contains = new boolean[this.fsm.inputs.size()];
        this.text.setText("# Finite State Machine\n");
        this.text.append("# Automatically created by JavaFSM\n\n");
        this.text.append("# Design name\n");
        this.text.append(".design " + this.fsm.getName() + "\n");
        this.text.append("# Input port names\n");
        this.text.append(".inputnames clk reset");
        int i = 0;
        while (i < this.fsm.inputs.size()) {
            this.text.append(" " + this.StrConv(((Signal)this.fsm.inputs.elementAt((int)i)).name));
            ++i;
        }
        this.text.append("\n# Output port names\n");
        this.text.append(".outputnames");
        int i2 = 0;
        while (i2 < this.fsm.outputs.size()) {
            this.text.append(" " + this.StrConv(((Signal)this.fsm.outputs.elementAt((int)i2)).name));
            ++i2;
        }
        this.text.append("\n# Clock signal's name and type\n");
        this.text.append(".clock clk rising_edge\n");
        this.text.append("# Reset signal's name, type and resulting state\n");
        this.text.append(".asynchronous_reset reset rising ");
        String tmp = "";
        int i3 = 0;
        while (i3 < this.fsm.zustaende.size()) {
            zu = (Zustand)this.fsm.zustaende.elementAt(i3);
            if (zu.isStart) {
                tmp = this.StrConv(zu.name);
            }
            ++i3;
        }
        this.text.append(tmp + "\n\n");
        this.text.append("# State table body\n");
        int i4 = 0;
        while (i4 < this.fsm.zustaende.size()) {
            zu = (Zustand)this.fsm.zustaende.elementAt(i4);
            int j = 0;
            while (j < contains.length) {
                contains[j] = false;
                ++j;
            }
            int j2 = 0;
            while (j2 < this.fsm.transitionen.size()) {
                Transition tr = (Transition)this.fsm.transitionen.elementAt(j2);
                if (tr.von == zu) {
                    int k = 0;
                    while (k < this.fsm.inputs.size()) {
                        if (tr.function.indexOf(((Signal)this.fsm.inputs.elementAt((int)k)).name) >= 0) {
                            contains[k] = true;
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < this.fsm.outputs.size()) {
                tmp = (String)zu.outputHash.get(this.fsm.outputs.elementAt(j3));
                int k = 0;
                while (k < this.fsm.inputs.size()) {
                    if (tmp.indexOf(((Signal)this.fsm.inputs.elementAt((int)k)).name) >= 0) {
                        contains[k] = true;
                    }
                    ++k;
                }
                ++j3;
            }
            this.durchgehen(contains, 0, zu);
            this.text.append("\n");
            ++i4;
        }
        this.ok.setLabel("OK");
    }

    private void durchgehen(boolean[] contains, int index, Zustand zu) {
        if (index >= contains.length) {
            String tmp = "";
            int j = 0;
            while (j < contains.length) {
                tmp = contains[j] ? (((Signal)this.fsm.inputs.elementAt((int)j)).value == 0 ? tmp + "0" : tmp + "1") : tmp + "-";
                ++j;
            }
            tmp = tmp + "\t" + this.StrConv(zu.name) + "\t";
            Transition stern = null;
            Transition aktiv = null;
            int i = 0;
            while (i < this.fsm.transitionen.size()) {
                Transition t = (Transition)this.fsm.transitionen.elementAt(i);
                if (t.von == zu) {
                    if (t.function.equals("*")) {
                        stern = t;
                    } else {
                        try {
                            if (this.parser.parse(t.function, this.fsm.inputs)) {
                                aktiv = t;
                                break;
                            }
                        }
                        catch (BadExpressionException e) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            tmp = aktiv != null ? tmp + this.StrConv(aktiv.nach.name) + "\t" : (stern != null ? tmp + this.StrConv(stern.nach.name) + "\t" : tmp + "FEHLER\t");
            int i2 = 0;
            while (i2 < this.fsm.outputs.size()) {
                String fkt = (String)zu.outputHash.get(this.fsm.outputs.elementAt(i2));
                if (fkt.trim().equals("1")) {
                    tmp = tmp + "1";
                } else if (fkt.trim().equals("0")) {
                    tmp = tmp + "0";
                } else {
                    try {
                        tmp = this.parser.parse(fkt, this.fsm.inputs) ? tmp + "1" : tmp + "0";
                    }
                    catch (BadExpressionException e) {
                        tmp = tmp + "?";
                    }
                }
                ++i2;
            }
            tmp = tmp + "\n";
            this.text.append(tmp);
        } else if (contains[index]) {
            Signal input = (Signal)this.fsm.inputs.elementAt(index);
            input.value = 0;
            this.durchgehen(contains, index + 1, zu);
            input.value = 1;
            this.durchgehen(contains, index + 1, zu);
        } else {
            this.durchgehen(contains, index + 1, zu);
        }
    }

    private String StrConv(String str) {
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == ' ' || chars[i] == ',' || chars[i] == '.') {
                chars[i] = 95;
            }
            ++i;
        }
        return new String(chars);
    }

    private String FuncConv(String str) {
        String function = "";
        PushbackReader cin = new PushbackReader(new StringReader(str + '\n'));
        try {
            char ch;
            block11: while (true) {
                if ((ch = (char)cin.read()) == '\n') {
                    return function;
                }
                if (ch == ' ') continue;
                switch (ch) {
                    case '|': {
                        function = function + " OR ";
                        continue block11;
                    }
                    case '&': {
                        function = function + " AND ";
                        continue block11;
                    }
                    case '!': {
                        function = function + " NOT ";
                        continue block11;
                    }
                    case '(': {
                        function = function + "(";
                        continue block11;
                    }
                    case ')': {
                        function = function + ")";
                        continue block11;
                    }
                    case '0': {
                        function = function + "'0'";
                        continue block11;
                    }
                    case '1': {
                        function = function + "'1'";
                        continue block11;
                    }
                }
                if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_') && ch != '_') break;
                String name_value = "" + ch;
                while ((ch = (char)cin.read()) != '\n' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '/')) {
                    name_value = name_value + ch;
                }
                function = function + name_value + "='1'";
                cin.unread(ch);
            }
            return "FEHLER - in Switch: '" + ch + "' -> " + function;
        }
        catch (IOException e) {
            return "FEHLER -  Exception";
        }
    }

    class EditWindowListener
    extends WindowAdapter {
        EditWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            ExportFSM.this.dispose();
        }
    }
}

