/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.EditFrame;
import hades.models.fsm.FSM;
import hades.models.fsm.Kommentar;
import hades.models.fsm.Statuszeile;
import hades.models.fsm.Transition;
import hades.models.fsm.Zustand;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class EditCanvas
extends Canvas {
    public int xOffset = 0;
    public int yOffset = 0;
    private static final int MOVE = 0;
    private static final int STATE = 2;
    private static final int TRANSITION = 3;
    private static final int KOMMENTAR = 4;
    private static final int DELETE = 5;
    private static final int START = 6;
    private int modus = 0;
    private static int r = 16;
    private static int d = 6;
    private FSM fsm;
    private EditFrame parentFrame;
    private Zustand zustand;
    private Transition transition;
    private Kommentar kommentar;
    private Object selected;
    private int dx;
    private int dy;
    private Statuszeile status;
    private Font zu_font;
    private Font tr_font;
    private FontMetrics zu_fm;
    private FontMetrics tr_fm;
    private int zu_font_height;
    private int tr_font_height;

    public EditCanvas(FSM Fsm, EditFrame editFrame, Statuszeile statuszeile) {
        this.addMouseListener(new EditMouseListener());
        this.addMouseMotionListener(new EditMouseListener());
        this.fsm = Fsm;
        this.parentFrame = editFrame;
        this.selected = null;
        this.status = statuszeile;
        this.zu_font = new Font("SansSerif", 1, 11);
        this.tr_font = new Font("SansSerif", 0, 9);
        this.zu_fm = this.getFontMetrics(this.zu_font);
        this.tr_fm = this.getFontMetrics(this.tr_font);
        this.zu_font_height = this.zu_fm.getAscent();
        this.tr_font_height = this.tr_fm.getAscent();
    }

    public void paint(Graphics g) {
        g.setFont(this.zu_font);
        int i = 0;
        while (i < this.fsm.zustaende.size()) {
            this.zustand = (Zustand)this.fsm.zustaende.elementAt(i);
            if (this.zustand == this.selected) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawOval(this.zustand.x - r - this.xOffset, this.zustand.y - r - this.yOffset, r + r, r + r);
            g.drawOval(this.zustand.x - r - this.xOffset + 1, this.zustand.y - r - this.yOffset + 1, r + r - 2, r + r - 2);
            if (this.zustand.isStart) {
                g.drawOval(this.zustand.x - r - this.xOffset + 4, this.zustand.y - r - this.yOffset + 4, r + r - 8, r + r - 8);
                g.drawOval(this.zustand.x - r - this.xOffset + 5, this.zustand.y - r - this.yOffset + 5, r + r - 10, r + r - 10);
            }
            g.setColor(Color.black);
            g.drawString(this.zustand.name, this.zustand.x - this.xOffset + r + 5, this.zustand.y - this.yOffset + this.zu_font_height / 2);
            ++i;
        }
        g.setFont(this.tr_font);
        i = 0;
        while (i < this.fsm.transitionen.size()) {
            this.transition = (Transition)this.fsm.transitionen.elementAt(i);
            if (this.transition == this.selected) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            Point p1 = new Point(this.transition.von.x - this.xOffset, this.transition.von.y - this.yOffset);
            Point p2 = new Point(this.transition.nach.x - this.xOffset, this.transition.nach.y - this.yOffset);
            if (this.transition.von == this.transition.nach) {
                p1.x -= r / 2;
                p2.x = p1.x;
                p1.y -= r - 1;
                p2.y -= r + r;
                g.drawLine(p1.x + r, p1.y, p1.x + r, p2.y);
                g.drawArc(p1.x, p2.y - r / 2, r, r, 0, 180);
                p2.y -= r + 1;
                p1.y += r + 1;
                this.drawArrow(p2, p1, g);
                g.drawString(this.transition.function, p2.x + r + 5, p2.y + r);
            } else {
                int dx = p2.x - p1.x;
                int dy = p2.y - p1.y;
                int h = (int)Math.sqrt(dx * dx + dy * dy);
                if (this.fsm.findTransition(this.transition.nach, this.transition.von) >= 0) {
                    p1.x += dy * d / h;
                    p2.x += dy * d / h;
                    p1.y -= dx * d / h;
                    p2.y -= dx * d / h;
                    if (dy >= 0) {
                        g.drawString(this.transition.function, p1.x + (p2.x - p1.x) / 2 + dy * 8 / h, p1.y + (p2.y - p1.y) / 2 + this.tr_font_height / 2);
                    } else {
                        g.drawString(this.transition.function, p1.x + (p2.x - p1.x) / 2 + dy * 8 / h - this.tr_fm.stringWidth(this.transition.function), p1.y + (p2.y - p1.y) / 2 + this.tr_font_height / 2);
                    }
                } else {
                    g.drawString(this.transition.function, p1.x + (p2.x - p1.x) / 2 + Math.abs(dy * 8 / h), p1.y + (p2.y - p1.y) / 2 + this.tr_font_height / 2);
                }
                this.drawArrow(p1, p2, g);
            }
            ++i;
        }
        g.setFont(this.zu_font);
        i = 0;
        while (i < this.fsm.kommentare.size()) {
            this.kommentar = (Kommentar)this.fsm.kommentare.elementAt(i);
            if (this.kommentar == this.selected) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.lightGray);
            }
            g.draw3DRect(this.kommentar.x - this.xOffset, this.kommentar.y - this.yOffset, this.kommentar.getWidth(this.zu_fm) + 10, this.kommentar.getHeight(this.zu_fm) + 10, false);
            if (this.kommentar == this.selected) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            String[] lines = this.kommentar.getLines();
            int yp = this.kommentar.y - this.yOffset + this.zu_fm.getAscent() + 5;
            if (lines[0] != null) {
                int j = 0;
                while (j < lines.length) {
                    g.drawString(lines[j], this.kommentar.x - this.xOffset + 5, yp);
                    yp += this.zu_fm.getHeight();
                    ++j;
                }
            }
            ++i;
        }
    }

    private Object findObject(int x, int y) {
        Object sel = null;
        int i = 0;
        while (i < this.fsm.zustaende.size()) {
            this.zustand = (Zustand)this.fsm.zustaende.elementAt(i);
            this.dx = x - this.zustand.x;
            this.dy = y - this.zustand.y;
            if (Math.sqrt(this.dx * this.dx + this.dy * this.dy) < (double)r) {
                sel = this.zustand;
                break;
            }
            ++i;
        }
        if (sel == null) {
            i = 0;
            while (i < this.fsm.transitionen.size()) {
                int y1;
                int x1;
                this.transition = (Transition)this.fsm.transitionen.elementAt(i);
                if (this.transition.von == this.transition.nach) {
                    x1 = this.transition.von.x;
                    y1 = this.transition.nach.y;
                    if (x >= x1 - r / 2 - 2 && x <= x1 + r / 2 + 2 && y <= y1 && y >= y1 - (int)(3.5 * (double)r)) {
                        sel = this.transition;
                        break;
                    }
                } else {
                    x1 = this.transition.von.x;
                    y1 = this.transition.von.y;
                    int x2 = this.transition.nach.x;
                    int y2 = this.transition.nach.y;
                    if (this.fsm.findTransition(this.transition.nach, this.transition.von) >= 0) {
                        int sx = x2 - x1;
                        int sy = y2 - y1;
                        int h = (int)Math.sqrt(sx * sx + sy * sy);
                        x1 += sy * d / h;
                        x2 += sy * d / h;
                        y1 -= sx * d / h;
                        y2 -= sx * d / h;
                    }
                    double j = Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1));
                    if ((j += Math.sqrt((x - x2) * (x - x2) + (y - y2) * (y - y2))) <= Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 0.5) {
                        sel = this.transition;
                        break;
                    }
                }
                ++i;
            }
        }
        if (sel == null) {
            i = 0;
            while (i < this.fsm.kommentare.size()) {
                this.kommentar = (Kommentar)this.fsm.kommentare.elementAt(i);
                if (this.kommentar.x < x && this.kommentar.x + this.kommentar.getWidth(this.zu_fm) + 10 > x && this.kommentar.y < y && this.kommentar.y + this.kommentar.getHeight(this.zu_fm) + 10 > y) {
                    sel = this.kommentar;
                    this.dx = x - this.kommentar.x;
                    this.dy = y - this.kommentar.y;
                    break;
                }
                ++i;
            }
        }
        return sel;
    }

    public Object getSelected() {
        return this.selected;
    }

    public void moveMode() {
        this.modus = 0;
        this.status.set("move objects with mouse");
    }

    public void zustandMode() {
        this.modus = 2;
        this.status.set("new state: click at desired position");
    }

    public void transitionMode() {
        this.modus = 3;
        if (this.selected instanceof Zustand) {
            this.status.set("new transition: select second state");
        } else {
            this.status.set("new transition: select first state");
        }
    }

    public void commentMode() {
        this.modus = 4;
        this.status.set("new comment: click at desired position");
    }

    public void deleteMode() {
        this.modus = 5;
        this.status.set("delete: click at object");
    }

    public void startMode() {
        this.modus = 6;
        this.status.set("select starting state");
    }

    private String freeName() {
        String str = "";
        int i = 1;
        while (i <= this.fsm.zustaende.size() + 1) {
            str = "state " + i;
            boolean isFree = true;
            int j = 0;
            while (j < this.fsm.zustaende.size()) {
                Zustand zustand = (Zustand)this.fsm.zustaende.elementAt(j);
                if (zustand.name.toUpperCase().equals(str.toUpperCase())) {
                    isFree = false;
                }
                ++j;
            }
            if (isFree) break;
            ++i;
        }
        return str;
    }

    private void drawArrow(Point p1, Point p2, Graphics g) {
        this.drawScaledArrow(p1, p2, 1.0, g);
    }

    private void drawScaledArrow(Point p1, Point p2, double q, Graphics g) {
        double dy;
        double dx;
        double sqnorm;
        double length = 10.0 * q;
        double width = 2.5 * q;
        if (q < 0.25) {
            length = 2.5;
            width = 0.625;
        }
        if ((sqnorm = Math.sqrt((dx = (double)(p2.x - p1.x)) * dx + (dy = (double)(p2.y - p1.y)) * dy)) == 0.0) {
            sqnorm = 1.0;
        }
        double nx = dx / sqnorm;
        double ny = dy / sqnorm;
        double ox = -dy / sqnorm;
        double oy = dx / sqnorm;
        Point a1 = new Point(p2.x, p2.y);
        Point a2 = new Point((int)((double)p2.x - length * nx + width * ox + 0.5), (int)((double)p2.y - length * ny + width * oy + 0.5));
        Point a4 = new Point((int)((double)p2.x - length * nx - width * ox + 0.5), (int)((double)p2.y - length * ny - width * oy + 0.5));
        Point o = new Point((int)(dx * ((double)r * q + 1.0) / sqnorm), (int)(dy * ((double)r * q + 1.0) / sqnorm));
        g.drawLine(p1.x + o.x, p1.y + o.y, a1.x - o.x, a1.y - o.y);
        g.drawLine(a2.x - o.x, a2.y - o.y, a1.x - o.x, a1.y - o.y);
        g.drawLine(a4.x - o.x, a4.y - o.y, a1.x - o.x, a1.y - o.y);
    }

    public void drawFSM(int xPos, int yPos, int width, int height, Graphics g, Object active) {
        this.drawFSM(xPos, yPos, width, height, g, active, null);
    }

    public void drawFSM(int xPos, int yPos, int width, int height, Graphics g, Object active, Vector active_trans) {
        Zustand zustand;
        int xMin = 1000;
        int xMax = 0;
        int yMin = 1000;
        int yMax = 0;
        int i = 0;
        while (i < this.fsm.zustaende.size()) {
            zustand = (Zustand)this.fsm.zustaende.elementAt(i);
            if (zustand.x < xMin) {
                xMin = zustand.x;
            }
            if (zustand.x > xMax) {
                xMax = zustand.x;
            }
            if (zustand.y < yMin) {
                yMin = zustand.y;
            }
            if (zustand.y > yMax) {
                yMax = zustand.y;
            }
            ++i;
        }
        double qx = (double)width / (double)((xMax += r) - (xMin -= r));
        double qy = (double)height / (double)((yMax += r) - (yMin -= r));
        double q = qx < qy ? qx : qy;
        if (q > 0.7) {
            q = 0.7;
        }
        i = 0;
        while (i < this.fsm.zustaende.size()) {
            zustand = (Zustand)this.fsm.zustaende.elementAt(i);
            if (zustand == active) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawOval((int)((double)(zustand.x - r - xMin) * q) + xPos, (int)((double)(zustand.y - r - yMin) * q) + yPos, (int)((double)(r + r) * q), (int)((double)(r + r) * q));
            if (zustand.isStart) {
                g.drawOval((int)((double)(zustand.x - r - xMin) * q) + xPos + 2, (int)((double)(zustand.y - r - yMin) * q) + yPos + 2, (int)((double)(r + r) * q) - 4, (int)((double)(r + r) * q) - 4);
            }
            ++i;
        }
        i = 0;
        while (i < this.fsm.transitionen.size()) {
            Transition transition = (Transition)this.fsm.transitionen.elementAt(i);
            if (active_trans != null && active_trans.contains(transition)) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            Point p1 = new Point((int)((double)(transition.von.x - xMin) * q) + xPos, (int)((double)(transition.von.y - yMin) * q) + yPos);
            Point p2 = new Point((int)((double)(transition.nach.x - xMin) * q) + xPos, (int)((double)(transition.nach.y - yMin) * q) + yPos);
            if (transition.von == transition.nach) {
                p1.x -= new Double((double)(r / 2) * q).intValue();
                p2.x = p1.x;
                p1.y -= new Double((double)(r - 1) * q).intValue();
                p2.y -= new Double((double)(r + r) * q).intValue();
                g.drawLine((int)((double)p1.x + (double)r * q), p1.y, (int)((double)p1.x + (double)r * q), p2.y);
                g.drawArc(p1.x, (int)((double)p2.y - (double)(r / 2) * q), (int)((double)r * q), (int)((double)r * q), 0, 200);
                p2.y -= new Double((double)(r + 1) * q).intValue();
                p1.y += new Double((double)(r + 1) * q).intValue();
                this.drawScaledArrow(p2, p1, q, g);
            } else {
                if (this.fsm.findTransition(transition.nach, transition.von) >= 0) {
                    int dx = p2.x - p1.x;
                    int dy = p2.y - p1.y;
                    int h = (int)Math.sqrt(dx * dx + dy * dy);
                    p1.x += new Double((double)(dy * d / h) * q).intValue();
                    p2.x += new Double((double)(dy * d / h) * q).intValue();
                    p1.y -= new Double((double)(dx * d / h) * q).intValue();
                    p2.y -= new Double((double)(dx * d / h) * q).intValue();
                }
                this.drawScaledArrow(p1, p2, q, g);
            }
            ++i;
        }
    }

    class EditMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        EditMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (EditCanvas.this.modus == 0) {
                EditCanvas.this.selected = EditCanvas.this.findObject(x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
            } else if (EditCanvas.this.modus == 2) {
                EditCanvas.this.zustand = EditCanvas.this.fsm.newZustand(EditCanvas.this.freeName(), x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                if (((EditCanvas)EditCanvas.this).zustand.x < r) {
                    ((EditCanvas)EditCanvas.this).zustand.x = r;
                }
                if (((EditCanvas)EditCanvas.this).zustand.y < r) {
                    ((EditCanvas)EditCanvas.this).zustand.y = r;
                }
                if (((EditCanvas)EditCanvas.this).zustand.x > 1000 - r) {
                    ((EditCanvas)EditCanvas.this).zustand.x = 1000 - r;
                }
                if (((EditCanvas)EditCanvas.this).zustand.y > 1000 - r) {
                    ((EditCanvas)EditCanvas.this).zustand.y = 1000 - r;
                }
                EditCanvas.this.selected = EditCanvas.this.zustand;
                EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
            } else if (EditCanvas.this.modus == 3) {
                if (EditCanvas.this.selected instanceof Zustand) {
                    Object selected2 = EditCanvas.this.findObject(x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                    if (selected2 instanceof Zustand) {
                        EditCanvas.this.fsm.newTransition((Zustand)EditCanvas.this.selected, (Zustand)selected2);
                    }
                    EditCanvas.this.selected = selected2;
                    EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
                    EditCanvas.this.transitionMode();
                } else {
                    EditCanvas.this.selected = EditCanvas.this.findObject(x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                    EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
                    EditCanvas.this.transitionMode();
                }
            } else if (EditCanvas.this.modus == 4) {
                EditCanvas.this.kommentar = EditCanvas.this.fsm.newKommentar("", x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                int w = EditCanvas.this.kommentar.getWidth(EditCanvas.this.zu_fm);
                int h = EditCanvas.this.kommentar.getHeight(EditCanvas.this.zu_fm);
                if (((EditCanvas)EditCanvas.this).kommentar.x < 5) {
                    ((EditCanvas)EditCanvas.this).kommentar.x = 5;
                }
                if (((EditCanvas)EditCanvas.this).kommentar.y < 5) {
                    ((EditCanvas)EditCanvas.this).kommentar.y = 5;
                }
                if (((EditCanvas)EditCanvas.this).kommentar.x > 1000 - w - 5) {
                    ((EditCanvas)EditCanvas.this).kommentar.x = 1000 - w - 5;
                }
                if (((EditCanvas)EditCanvas.this).kommentar.y > 1000 - h - 5) {
                    ((EditCanvas)EditCanvas.this).kommentar.y = 1000 - h - 5;
                }
                EditCanvas.this.selected = EditCanvas.this.kommentar;
                EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
            } else if (EditCanvas.this.modus == 5) {
                EditCanvas.this.selected = EditCanvas.this.findObject(x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                if (EditCanvas.this.selected instanceof Zustand) {
                    EditCanvas.this.fsm.deleteZustand((Zustand)EditCanvas.this.selected);
                } else if (EditCanvas.this.selected instanceof Transition) {
                    EditCanvas.this.fsm.deleteTransition((Transition)EditCanvas.this.selected);
                } else if (EditCanvas.this.selected instanceof Kommentar) {
                    EditCanvas.this.fsm.deleteKommentar((Kommentar)EditCanvas.this.selected);
                }
                EditCanvas.this.selected = null;
                EditCanvas.this.parentFrame.setPanel(null);
            } else if (EditCanvas.this.modus == 6) {
                EditCanvas.this.selected = EditCanvas.this.findObject(x + EditCanvas.this.xOffset, y + EditCanvas.this.yOffset);
                if (EditCanvas.this.selected instanceof Zustand) {
                    EditCanvas.this.fsm.setStart((Zustand)EditCanvas.this.selected);
                }
                EditCanvas.this.parentFrame.setPanel(EditCanvas.this.selected);
            }
            EditCanvas.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (EditCanvas.this.modus == 0 && EditCanvas.this.selected instanceof Zustand) {
                int a = x + EditCanvas.this.xOffset - EditCanvas.this.dx;
                int b = y + EditCanvas.this.yOffset - EditCanvas.this.dy;
                if (a < r) {
                    a = r;
                } else if (a >= 1000 - r) {
                    a = 1000 - r - 1;
                }
                if (b < r) {
                    b = r;
                } else if (b >= 1000 - r) {
                    b = 1000 - r - 1;
                }
                boolean tooClose = false;
                if (EditCanvas.this.selected != null && EditCanvas.this.selected instanceof Zustand) {
                    int i = 0;
                    while (i < ((EditCanvas)EditCanvas.this).fsm.zustaende.size()) {
                        EditCanvas.this.zustand = (Zustand)((EditCanvas)EditCanvas.this).fsm.zustaende.elementAt(i);
                        int d1 = a - ((EditCanvas)EditCanvas.this).zustand.x;
                        int d2 = b - ((EditCanvas)EditCanvas.this).zustand.y;
                        if (EditCanvas.this.zustand != EditCanvas.this.selected && Math.sqrt(d1 * d1 + d2 * d2) < (double)(2 * r)) {
                            tooClose = true;
                        }
                        ++i;
                    }
                    if (!tooClose) {
                        ((Zustand)((EditCanvas)EditCanvas.this).selected).x = a;
                        ((Zustand)((EditCanvas)EditCanvas.this).selected).y = b;
                    }
                    EditCanvas.this.repaint();
                }
            } else if (EditCanvas.this.modus == 0 && EditCanvas.this.selected instanceof Kommentar) {
                Kommentar komm = (Kommentar)EditCanvas.this.selected;
                int w = komm.getWidth(EditCanvas.this.zu_fm);
                int h = komm.getHeight(EditCanvas.this.zu_fm);
                int a = x + EditCanvas.this.xOffset - EditCanvas.this.dx;
                int b = y + EditCanvas.this.yOffset - EditCanvas.this.dy;
                if (a < 5) {
                    a = 5;
                }
                if (b < 5) {
                    b = 5;
                }
                if (a > 995 - w) {
                    a = 995 - w;
                }
                if (b > 995 - h) {
                    b = 995 - h;
                }
                komm.x = a;
                komm.y = b;
                EditCanvas.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

