/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.dsp.GenericDspOperator;
import hades.signals.PortDouble;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import jfig.gui.JTextViewer;

public class Oscilloscope
extends GenericDspOperator {
    private static final long serialVersionUID = 1251434902085098435L;
    private int n_samples = 256;
    private int ptr = 0;
    private boolean busy = false;
    private boolean debug = false;
    private double t0 = 0.0;
    private double t_sample = 0.001;
    private double t_repaint = 0.1;
    private double[] a_data;
    private double a_offset;
    private double a_scale;
    private double[] b_data;
    private double b_offset;
    private double b_scale;
    private boolean guiShowing = false;
    private GUI scopeGUI;
    protected PortDouble port_A;
    protected PortDouble port_B;
    protected PortStdLogic1164 port_T;

    public Oscilloscope() {
        this.createDataArrays();
        this.clearDataArrays();
        this.setComment("oscilloscope");
    }

    public void constructPorts() {
        this.port_T = new PortStdLogic1164(this, "T", 0, null);
        this.port_A = new PortDouble(this, "A", 3, null);
        this.port_B = new PortDouble(this, "B", 3, null);
        this.ports = new Port[]{this.port_T, this.port_A, this.port_B};
    }

    public void createDataArrays() {
        this.ptr = 0;
        this.a_data = new double[this.n_samples];
        this.b_data = new double[this.n_samples];
    }

    public void clearDataArrays() {
        this.ptr = 0;
        int i = 0;
        while (i < this.n_samples) {
            this.a_data[i] = 0.0;
            this.b_data[i] = 0.0;
            ++i;
        }
    }

    public void sample() {
        if (this.ptr >= this.n_samples) {
            System.err.println("-E- internal error: index out of range: " + this.ptr);
            return;
        }
        this.a_data[this.ptr] = this.port_A.getValueOrNaN();
        this.b_data[this.ptr] = this.port_B.getValueOrNaN();
        if (this.debug) {
            System.out.println("-#- sample: " + this.ptr + " " + this.a_data[this.ptr] + " " + this.b_data[this.ptr]);
        }
        ++this.ptr;
    }

    public void trigger() {
        this.busy = true;
        this.clearDataArrays();
        this.sample();
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.t_sample, this);
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        this.clearDataArrays();
        this.ptr = 0;
        this.busy = false;
    }

    public void evaluate(Object arg) {
        Signal signal_T = this.port_T.getSignal();
        StdLogic1164 value_T = this.port_T.getValueOrU();
        if (value_T.is_1() && signal_T.hasEvent()) {
            if (this.busy) {
                System.out.println("-W- " + this.getName() + ": re-triggering at t=" + this.simulator.getSimTime());
                this.ptr = 0;
            } else {
                this.trigger();
            }
        }
    }

    public void wakeup(Object evt) {
        if (this.debug) {
            System.out.println("-#- wakeup: at " + this.simulator.getSimTime());
        }
        this.sample();
        if (this.ptr < this.n_samples) {
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.t_sample, this);
        } else {
            this.busy = false;
            if (this.scopeGUI != null) {
                this.scopeGUI.repaint();
            }
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_samples = Integer.parseInt(st.nextToken());
            this.t_sample = Double.parseDouble(st.nextToken());
            this.t_repaint = Double.parseDouble(st.nextToken());
            this.a_offset = Double.parseDouble(st.nextToken());
            this.a_scale = Double.parseDouble(st.nextToken());
            this.b_offset = Double.parseDouble(st.nextToken());
            this.b_scale = Double.parseDouble(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
            e.printStackTrace();
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
        ps.print(" " + this.n_samples);
        ps.print(" " + this.t_sample);
        ps.print(" " + this.t_repaint);
        ps.print(" " + this.a_offset);
        ps.print(" " + this.a_scale);
        ps.print(" " + this.b_offset);
        ps.print(" " + this.b_scale);
    }

    public SimObject copy() {
        Oscilloscope tmp = null;
        try {
            tmp = (Oscilloscope)this.getClass().newInstance();
            tmp.setVersionId(this.getVersionId());
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tmp;
    }

    public void configure() {
        JFrame frame = (JFrame)this.getPropertySheet();
        frame.show();
    }

    public Component getPropertySheet() {
        if (this.scopeGUI == null) {
            this.scopeGUI = new GUI();
            this.scopeGUI.pack();
        }
        return this.scopeGUI;
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n";
    }

    public void dumpDataAsText() {
        try {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.n_samples) {
                sb.append("" + i);
                sb.append("  " + this.a_data[i]);
                sb.append("  " + this.b_data[i]);
                sb.append("\n");
                ++i;
            }
            String title = "raw oscilloscope data";
            int rows = 30;
            int cols = 50;
            StringBufferInputStream inputStream = new StringBufferInputStream(sb.toString());
            JTextViewer viewer = new JTextViewer(title, rows, cols);
            viewer.parse(inputStream);
            viewer.setCaretPosition(0);
            viewer.setVisible(true);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Oscilloscope scope = new Oscilloscope();
        JFrame gui = (JFrame)scope.getPropertySheet();
        gui.pack();
        gui.show();
    }

    class ScopeCanvas
    extends JPanel {
        private int width;
        private int height;
        private int n_divs;
        private Color bgColor;
        private Color gridColor;
        private Color[] channelColors;

        public ScopeCanvas() {
            this.width = Oscilloscope.this.n_samples;
            this.height = 300;
            this.n_divs = 10;
            this.bgColor = new Color(240, 240, 240);
            this.gridColor = new Color(100, 100, 100);
            this.channelColors = new Color[]{Color.red, Color.blue, Color.green, Color.cyan};
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        public void paintComponent(Graphics g) {
            this.paintBackgroundAndGrid(g);
            this.paintChannelData(g);
        }

        public void paintBackgroundAndGrid(Graphics g) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.width, this.height);
            int NX = 10;
            int NY = 10;
            g.setColor(this.gridColor);
            g.drawRect(0, 0, this.width, this.height);
            int i = 0;
            while (i < NX) {
                int x = (int)Math.round(1.0 * (double)i * (double)this.width / (double)NX);
                g.drawLine(x, 0, x, this.height);
                ++i;
            }
            int i2 = 0;
            while (i2 < NY) {
                int y = (int)Math.round(1.0 * (double)i2 * (double)this.height / (double)NY);
                g.drawLine(0, y, this.width, y);
                ++i2;
            }
        }

        public void paintChannelData(Graphics g) {
            g.setColor(this.channelColors[0]);
            this.paintOneChannel(g, Oscilloscope.this.a_data, Oscilloscope.this.a_scale, Oscilloscope.this.a_offset);
            g.setColor(this.channelColors[1]);
            this.paintOneChannel(g, Oscilloscope.this.b_data, Oscilloscope.this.b_scale, Oscilloscope.this.b_offset);
            g.setColor(Color.black);
        }

        private int getClippedY(double y) {
            int iy = (int)Math.round(y);
            if (iy <= 0) {
                return this.height - 1;
            }
            if (iy >= this.height) {
                return 0;
            }
            return this.height - 1 - iy;
        }

        public void paintOneChannel(Graphics g, double[] data, double scale, double offset) {
            double nds = 1.0 * (double)this.height / ((double)this.n_divs * scale);
            int t1 = 0;
            int y1 = this.getClippedY(nds * (data[0] - offset));
            int i = 1;
            while (i < data.length) {
                int t2 = i;
                int y2 = this.getClippedY(nds * (data[i] - offset));
                g.drawLine(t1, y1, t2, y2);
                t1 = t2;
                y1 = y2;
                ++i;
            }
        }
    }

    class GUI
    extends JFrame
    implements ActionListener {
        private JPanel displayArea;
        private JPanel controlsPanel;
        private JTextField a_offset_tf;
        private JTextField a_scale_tf;
        private JTextField b_offset_tf;
        private JTextField b_scale_tf;
        private JTextField t_sample_tf;
        private JTextField t_repaint_tf;
        private JMenuBar menuBar;
        private JMenu fileMenu;
        private JMenuItem closeMI;
        private JMenuItem dumpDataAsTextMI;

        public GUI() {
            super("Oscilloscope");
            this.buildGUI();
        }

        private JTextField _ctf(double value) {
            JTextField tmp = new JTextField("" + value, 10);
            tmp.addActionListener(this);
            return tmp;
        }

        private JLabel _lbl(String s) {
            return new JLabel(s, 2);
        }

        private JMenuItem _cmi(String s) {
            JMenuItem tmp = new JMenuItem(s);
            tmp.addActionListener(this);
            return tmp;
        }

        private double parse(JTextField tf, double defaultValue) {
            try {
                return Double.parseDouble(tf.getText());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        private void buildGUI() {
            this.displayArea = new JPanel(new BorderLayout());
            this.displayArea.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
            this.displayArea.add("North", new ScopeCanvas());
            this.a_scale_tf = this._ctf(Oscilloscope.this.a_scale);
            this.a_offset_tf = this._ctf(Oscilloscope.this.a_offset);
            this.b_scale_tf = this._ctf(Oscilloscope.this.b_scale);
            this.b_offset_tf = this._ctf(Oscilloscope.this.b_offset);
            this.t_sample_tf = this._ctf(Oscilloscope.this.t_sample);
            this.t_repaint_tf = this._ctf(Oscilloscope.this.t_repaint);
            this.controlsPanel = new JPanel(new GridLayout(0, 1));
            this.controlsPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
            this.controlsPanel.add(this._lbl("Channel A (red):"));
            this.controlsPanel.add(this._lbl("offset [volts]"));
            this.controlsPanel.add(this.a_offset_tf);
            this.controlsPanel.add(this._lbl("scale [volts/div]"));
            this.controlsPanel.add(this.a_scale_tf);
            this.controlsPanel.add(this._lbl(""));
            this.controlsPanel.add(this._lbl("Channel B (blue):"));
            this.controlsPanel.add(this._lbl("offset [volts]"));
            this.controlsPanel.add(this.b_offset_tf);
            this.controlsPanel.add(this._lbl("scale [volts/div]"));
            this.controlsPanel.add(this.b_scale_tf);
            this.controlsPanel.add(this._lbl(""));
            this.controlsPanel.add(this._lbl("Timebase:"));
            this.controlsPanel.add(this._lbl("sample interval [sec]"));
            this.controlsPanel.add(this.t_sample_tf);
            this.controlsPanel.add(this._lbl("repaint interval [sec]"));
            this.controlsPanel.add(this.t_repaint_tf);
            this.fileMenu = new JMenu("File");
            this.dumpDataAsTextMI = this._cmi("Dump data as text");
            this.fileMenu.add(this.dumpDataAsTextMI);
            this.fileMenu.addSeparator();
            this.closeMI = this._cmi("Close");
            this.fileMenu.add(this.closeMI);
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.fileMenu);
            this.getContentPane().add("Center", this.displayArea);
            this.getContentPane().add("West", this.controlsPanel);
            this.setDefaultCloseOperation(1);
            this.setJMenuBar(this.menuBar);
            this.pack();
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.a_offset_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.a_scale_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.b_offset_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.b_scale_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.t_sample_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.t_repaint_tf) {
                this.updateParameters();
                this.repaint();
            } else if (source == this.dumpDataAsTextMI) {
                Oscilloscope.this.dumpDataAsText();
            } else if (source == this.closeMI) {
                this.setVisible(false);
            } else {
                Thread.dumpStack();
            }
        }

        private void updateParameters() {
            Oscilloscope.this.a_offset = this.parse(this.a_offset_tf, Oscilloscope.this.a_offset);
            Oscilloscope.this.a_scale = this.parse(this.a_scale_tf, Oscilloscope.this.a_scale);
            Oscilloscope.this.b_offset = this.parse(this.b_offset_tf, Oscilloscope.this.b_offset);
            Oscilloscope.this.b_scale = this.parse(this.b_scale_tf, Oscilloscope.this.b_scale);
            Oscilloscope.this.t_sample = this.parse(this.t_sample_tf, Oscilloscope.this.t_sample);
            Oscilloscope.this.t_repaint = this.parse(this.t_repaint_tf, Oscilloscope.this.t_repaint);
        }
    }
}

