/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.dsp.GenericDspOperator;
import hades.signals.PortDouble;
import hades.signals.PortInteger;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Point;

public class DoubleToInteger
extends GenericDspOperator {
    protected PortInteger port_Y;
    protected PortDouble port_A;
    protected Integer value_Y;

    public void constructPorts() {
        this.port_A = new PortDouble(this, "A", 0, null);
        this.port_Y = new PortInteger(this, "Y", 1, null);
        this.ports = new Port[]{this.port_A, this.port_Y};
        this.inputPorts = new PortDouble[]{this.port_A};
        this.inputValues = new double[]{Double.NaN};
        this.outputPorts = new PortDouble[0];
        this.outputValues = new double[]{Double.NaN};
        this.value_Y = new Integer(0);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.retrieveInputValues();
        double v = Math.round(this.inputValues[0]);
        this.value_Y = Double.isNaN(v) ? new Integer(0) : (v >= 2.147483647E9 ? new Integer(Integer.MAX_VALUE) : (v <= -2.147483648E9 ? new Integer(Integer.MIN_VALUE) : new Integer((int)Math.round(v))));
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (this.port_Y.getSignal() != null) {
            simulator.scheduleEvent(SimEvent.createNewSimEvent(this.port_Y.getSignal(), time, this.value_Y, this.port_Y));
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "input value= " + this.inputValues[0] + "\n" + "output value= " + this.value_Y;
    }
}

