/*
 * Decompiled with CFR 0.152.
 */
package hades.manager.tree;

import hades.gui.Editor;
import hades.manager.Browser;
import hades.manager.DesignManager;
import hades.manager.InfoPanel;
import hades.manager.TreeManager;
import hades.manager.tree.SortedTreeNode;
import hades.models.Design;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jfig.utils.SetupManager;

public class DesignFileTreeNode
extends SortedTreeNode {
    static final long serialVersionUID = -4344990634364729035L;
    static ImageIcon _icon = DesignFileTreeNode.loadIcon("/hades/manager/icons/design.gif");

    public ImageIcon getIcon() {
        return _icon;
    }

    public void handleTreeSelection(Browser browser) {
        String pathname = TreeManager.getFullPathname(this);
        String thumbname = DesignManager.changeExtension(pathname, ".gif");
        browser.setComponentThumbnail(DesignManager.getDesignManager().getThumbnail(thumbname));
        InfoPanel ip = browser.getInfoPanel();
        ip.setName(this.toString());
        ip.setAuthor("-");
        ip.setVersion("-");
        ip.setInfoText("");
    }

    public void handleDoubleClick(Browser browser) {
        DesignFileTreeNode.msg("-#- DesignFileTN.handleDoubleClick: " + this.toString());
        this.openDesign(false, false);
    }

    public void openDesign(boolean newEditor, boolean viewMode) {
        String fullPathname = TreeManager.getFullPathname(this);
        Editor editor = Editor.getActiveEditor();
        if (newEditor || viewMode || editor == null) {
            if (viewMode) {
                boolean b = SetupManager.getBoolean("Hades.Editor.ViewMode", false);
                SetupManager.setProperty("Hades.Editor.ViewMode", "true");
                editor = new Editor();
                SetupManager.setProperty("Hades.Editor.ViewMode", "" + b);
            } else {
                editor = new Editor();
            }
        }
        if (fullPathname.startsWith("file://")) {
            String filename = fullPathname.substring(7);
            editor.doOpenDesign(filename, true);
        } else {
            DesignFileTreeNode.msg("-#- cannot handle: " + fullPathname);
            Design design = null;
            try {
                design = DesignManager.getDesignManager().getDesign(editor, fullPathname, true);
                if (design != null) {
                    editor.doOpenDesign(design, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createAsSubdesign() {
        String fullPathname = TreeManager.getFullPathname(this);
        Editor editor = Editor.getActiveEditor();
        if (editor == null) {
            editor = new Editor();
        }
        if (editor.isViewMode()) {
            JOptionPane.showMessageDialog(editor.getFrame(), "Cannot add subdesign because editor is in view-mode!", "Error", 0);
            return;
        }
        String designname = fullPathname;
        if (fullPathname.startsWith("file://")) {
            designname = fullPathname.substring(7);
        }
        DesignFileTreeNode.msg("-X- createAsSubdesign: '" + designname + '\'');
        editor.createSubDesign(designname);
    }
}

