/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.manager.DesignManager;
import hades.manager.HadesTreeCellRenderer;
import hades.manager.tree.AssemblerFileTreeNode;
import hades.manager.tree.DesignFileTreeNode;
import hades.manager.tree.DirectoryTreeNode;
import hades.manager.tree.FileRootTreeNode;
import hades.manager.tree.PythonFileTreeNode;
import hades.manager.tree.ReadmeFileTreeNode;
import hades.manager.tree.RootTreeNode;
import hades.manager.tree.SimObjectTreeNode;
import hades.manager.tree.SortedTreeNode;
import hades.manager.tree.TextFileTreeNode;
import hades.manager.tree.ZipRootTreeNode;
import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreeManager {
    private static boolean debug = false;
    private SortedTreeNode rootNode;
    private Hashtable pathToNodeTable;

    public void setRootNode(SortedTreeNode root) {
        this.rootNode = root;
    }

    public SortedTreeNode getRootNode() {
        return this.rootNode;
    }

    public boolean traverseFileTree(File path, SortedTreeNode node) {
        if (path == null) {
            return false;
        }
        if (!path.isDirectory()) {
            return false;
        }
        boolean show = false;
        String[] list = path.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            File file = new File(path, list[i]);
            String filename = file.getPath().replace('\\', '/');
            if (!file.canRead()) {
                TreeManager.msg("-W- TreeManager: no read access: " + file.getAbsolutePath());
            } else if (file.isDirectory()) {
                DirectoryTreeNode directoryNode = new DirectoryTreeNode();
                directoryNode.setUserObject(this.stripDirectoryNames(filename));
                if (this.traverseFileTree(file, directoryNode)) {
                    show = true;
                    node.add(directoryNode);
                }
            } else if (this.isDesignFile(filename)) {
                SortedTreeNode fileNode = this.createLeafNode(this.stripDirectoryNames(filename));
                show = true;
                node.add(fileNode);
            }
            ++i;
        }
        return show;
    }

    public boolean isDesignFile(String name) {
        boolean bl = false;
        if (name.endsWith("README") || name.endsWith(".hds") || name.endsWith(".clb") || name.endsWith(".asm") || name.endsWith(".py") || name.endsWith(".pyc") || name.endsWith(".rom")) {
            bl = true;
        }
        return bl;
    }

    public String stripDirectoryNames(String pathname) {
        int pos;
        if (pathname == null) {
            return null;
        }
        if (pathname.charAt(pathname.length() - 1) == '/') {
            pathname = pathname.substring(0, pathname.length() - 1);
        }
        if ((pos = pathname.lastIndexOf(47)) <= 0) {
            return pathname;
        }
        return pathname.substring(pos + 1, pathname.length());
    }

    public SortedTreeNode createLeafNode(String name) {
        SortedTreeNode node = null;
        node = name.endsWith("README") ? new ReadmeFileTreeNode() : (name.endsWith(".hds") ? new DesignFileTreeNode() : (name.endsWith(".clb") ? new SimObjectTreeNode() : (name.endsWith(".py") ? new PythonFileTreeNode() : (name.endsWith(".asm") ? new AssemblerFileTreeNode() : (name.endsWith(".rom") ? new TextFileTreeNode() : new SortedTreeNode())))));
        node.setUserObject(name);
        return node;
    }

    public ZipRootTreeNode traverseZip(ZipFile zipfile) {
        ZipRootTreeNode ziproot = new ZipRootTreeNode();
        ziproot.setZipFile(zipfile);
        this.pathToNodeTable = new Hashtable();
        this.pathToNodeTable.put("", ziproot);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String[] names = this.splitZipEntryName(entry.getName());
            this.checkCreateZipDirectoryNode(names[0]);
            this.checkCreateZipFileNode(names[0], names[1], ziproot);
        }
        return ziproot;
    }

    public SortedTreeNode checkCreateZipDirectoryNode(String pathname) {
        SortedTreeNode node;
        if (pathname == null) {
            TreeManager.msg("-E- internal in checkCreateZipDirectoryNodes: pathname null...");
            pathname = "";
        }
        if ((node = (SortedTreeNode)this.pathToNodeTable.get(pathname)) != null) {
            return node;
        }
        String[] names = this.splitZipEntryName(pathname);
        SortedTreeNode parent = this.checkCreateZipDirectoryNode(names[0]);
        DirectoryTreeNode newnode = new DirectoryTreeNode();
        newnode.setUserObject(this.stripDirectoryNames(pathname));
        this.pathToNodeTable.put(pathname, newnode);
        return parent;
    }

    public void checkCreateZipFileNode(String pathname, String name, SortedTreeNode zipRoot) {
        if (this.isDesignFile(name)) {
            SortedTreeNode fileNode = this.createLeafNode(this.stripDirectoryNames(name));
            SortedTreeNode pathNode = (SortedTreeNode)this.pathToNodeTable.get(pathname);
            pathNode.add(fileNode);
            this.checkLinkParentNodes(pathname, zipRoot);
        }
    }

    public void checkLinkParentNodes(String pathname, SortedTreeNode zipRoot) {
        SortedTreeNode node = (SortedTreeNode)this.pathToNodeTable.get(pathname);
        if (node.getParent() != null) {
            return;
        }
        if (node == zipRoot) {
            return;
        }
        String[] names = this.splitZipEntryName(pathname);
        this.checkLinkParentNodes(names[0], zipRoot);
        SortedTreeNode parent = (SortedTreeNode)this.pathToNodeTable.get(names[0]);
        parent.add(node);
    }

    public String[] splitZipEntryName(String name) {
        String[] result = new String[2];
        int pos = name.lastIndexOf(47);
        if (pos <= 0) {
            result[0] = "";
            result[1] = name;
        } else {
            result[0] = name.charAt(0) == '/' ? name.substring(1, pos) : name.substring(0, pos);
            result[1] = name.substring(pos + 1, name.length());
        }
        return result;
    }

    public static String getFullPathname(SortedTreeNode node) {
        if (node == null) {
            return null;
        }
        Object[] userObjectPath = node.getUserObjectPath();
        StringBuffer sb = new StringBuffer("");
        int i = 1;
        while (i < userObjectPath.length) {
            sb.append(userObjectPath[i]);
            if (i < userObjectPath.length - 1) {
                sb.append("/");
            }
            ++i;
        }
        return sb.toString();
    }

    public static SortedTreeNode getFirstLevelNode(SortedTreeNode node) {
        TreeNode[] path = node.getPath();
        return (SortedTreeNode)path[1];
    }

    public String getGifPathame(String pathname) {
        try {
            int pos = pathname.lastIndexOf(46);
            return pathname.substring(0, pos) + ".gif";
        }
        catch (Exception e) {
            return "/hades/manager/icons/null.gif";
        }
    }

    public void registerZipFile(String filename) {
        try {
            ZipFile zipfile = new ZipFile(filename);
            DesignManager.getDesignManager().registerZipFile(zipfile);
            ZipRootTreeNode ziproot = this.traverseZip(zipfile);
            this.getRootNode().add(ziproot);
        }
        catch (Exception e) {
            TreeManager.msg("-E- BrowserFrame.registerZipFile failed: " + filename);
            TreeManager.msg("-E- exception is: " + e);
        }
    }

    public void registerDirectory(String dirname) {
        TreeManager.msg("-#- registerDirectory: '" + dirname + '\'');
        try {
            if (dirname == null) {
                return;
            }
            FileRootTreeNode dirNode = new FileRootTreeNode();
            dirNode.setUserObject("file://" + dirname);
            this.getRootNode().add(dirNode);
            File dir = new File(dirname);
            if (dir.exists() && dir.isDirectory()) {
                boolean foundFiles = this.traverseFileTree(dir, dirNode);
                if (!foundFiles) {
                    TreeManager.msg("-#- no Hades files found in : '" + dirname + '\'');
                    dirNode.setEmpty(true);
                }
            } else {
                TreeManager.msg("-#- directory doesn't exist: '" + dirname + '\'');
                dirNode.setInvalid(true);
            }
        }
        catch (Exception e) {
            TreeManager.msg("-E- BrowserFrame.registerDirectory failed: " + dirname);
            TreeManager.msg("-E- exception is: " + e);
        }
    }

    public void testFileSystem(String filename, SortedTreeNode root) {
        TreeManager.msg("testing: file system " + filename + "...");
        TreeManager.msg("scanning ...");
        this.traverseFileTree(new File("."), root);
        TreeManager.msg("ok...");
    }

    public void dumpTree(SortedTreeNode root) {
        TreeManager.msg("\nprinting: full tree...");
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            SortedTreeNode tmp = (SortedTreeNode)e.nextElement();
            TreeManager.msg(tmp.toString() + ' ' + tmp.isLeaf());
        }
    }

    public void dumpHdsFiles(SortedTreeNode root) {
        TreeManager.msg("\nprinting: all .hds files from full tree...");
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            SortedTreeNode tmp = (SortedTreeNode)e.nextElement();
            String name = tmp.toString();
            if (!name.endsWith(".hds") || !tmp.isLeaf()) continue;
            TreeManager.msg(tmp.toString() + ' ' + TreeManager.getFullPathname(tmp));
        }
    }

    public void displayTree(SortedTreeNode root) {
        JTree tree = new JTree();
        tree.setModel(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.setCellRenderer(new HadesTreeCellRenderer());
        tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        tree.setSelectionModel(dtsm);
        JScrollPane scroller = new JScrollPane(tree);
        Frame frame = new Frame("TreeManager selftest");
        frame.add("Center", scroller);
        frame.setSize(300, 700);
        frame.setVisible(true);
    }

    public static void msg(String s) {
        if (!debug && s.startsWith("-#-")) {
            return;
        }
        System.out.println(s);
    }

    public static void main(String[] argv) throws Exception {
        TreeManager tb = new TreeManager();
        tb.setRootNode(new RootTreeNode());
        ZipFile zipfile = new ZipFile(argv[0]);
        DesignManager.getDesignManager().registerZipFile(zipfile);
        ZipRootTreeNode ziproot = tb.traverseZip(zipfile);
        tb.getRootNode().add(ziproot);
        FileRootTreeNode pwd = new FileRootTreeNode();
        pwd.setUserObject(".");
        tb.getRootNode().add(pwd);
        tb.testFileSystem(".", pwd);
        tb.dumpTree(tb.getRootNode());
        tb.dumpHdsFiles(tb.getRootNode());
        tb.displayTree(tb.getRootNode());
    }

    private final /* synthetic */ void this() {
        this.pathToNodeTable = null;
    }

    public TreeManager() {
        this.this();
    }
}

