/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.manager.ComponentInfo;
import hades.manager.DesignManager;
import hades.simulator.SimObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CreateComponentInfo {
    private String author;
    private String version;
    private String description;

    public void createComponentInfo(String filename) throws Exception {
        String classname = filename.substring(0, filename.lastIndexOf(46)).replace('/', '.');
        String imagepath = filename.substring(0, filename.lastIndexOf(46)) + ".gif";
        String sourcepath = filename.substring(0, filename.lastIndexOf(46)) + ".java";
        String symbolpath = filename.substring(0, filename.lastIndexOf(46)) + ".sym";
        String clbname = filename.substring(0, filename.lastIndexOf(46)) + ".clb";
        try {
            Object o = Class.forName(classname).newInstance();
            if (!(o instanceof SimObject)) {
                return;
            }
        }
        catch (Exception e) {
            CreateComponentInfo.msg("-E- could not instantiate class: " + classname);
            return;
        }
        ComponentInfo clb = new ComponentInfo();
        clb.addFile(filename);
        clb.addFile(sourcepath);
        clb.addFile(symbolpath);
        clb.addFile(imagepath);
        clb.setStart(classname);
        clb.setPathname(clbname);
        clb.setAuthor(this.author);
        clb.setVersion(this.version);
        clb.setName(classname);
        clb.setImagepath(imagepath);
        clb.setIconpath("simobj.gif");
        clb.setType("simobject");
        clb.setDescription(this.description);
        clb.saveComponentInfo();
    }

    public static void usage() {
        CreateComponentInfo.msg("Usage: java hades.manager.CreateComponentInfo [options] [files]\nwhere options include:\n-author name        default: -\n-version name       default: 1.001\n-description filename  default: none\nfiles is a list of .class files\nand the resulting files will be written to <classname>.clb\nExample(s):\njava hades.manager.CreateComponentInfo models/gates/Inv.class \njava hades.manager.CreateComponentInfo -author FNH -version 42 -description /tmp/foo.txt hades/models/gates/And2.class \n");
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        try {
            CreateComponentInfo cci = new CreateComponentInfo();
            cci.description = "XXX\n";
            int i = 0;
            if ("-author".equals(argv[i])) {
                cci.author = argv[i + 1];
                i += 2;
            }
            if ("-version".equals(argv[i])) {
                cci.version = argv[i + 1];
                i += 2;
            }
            if ("-description".equals(argv[i])) {
                cci.description = DesignManager.getDesignManager().readStreamIntoBuffer(argv[i + 1]).toString();
                i += 2;
            }
            if ("-rtlib".equals(argv[i])) {
                cci.description = "XXX\n\nInputs and outputs are of types StdLogicVector and StdLogic1164.\nUse the configuration dialog to specify the delay of the component\nand the bit-width of the data buses.(The default bus width is n=16\nand the maximum width is n=63. The bus width can only be changed\nwhile no signals are connected to the RTLIB component.)\n\nNote that simulation performance may be limited by GUI updates due\nto glow-mode and RTLIB-animation (e.g. labels on flipflops or Opins).\nIf necessary, switch off glow-mode and RTLIB-animation via the 'view'\nmenu. With RTLIB-animation off, however, component symbols won't be\nupdated and may not match the actual value on the component/signal.\nSelect a manual redraw after pausing the simulation to update the GUI.\n";
                ++i;
            }
            while (i < argv.length) {
                try {
                    cci.createComponentInfo(argv[i]);
                }
                catch (Exception e) {
                    CreateComponentInfo.msg("-W- failed for " + argv[i]);
                    CreateComponentInfo.msg("-W- exception is: " + e);
                }
                ++i;
            }
            System.exit(0);
        }
        catch (Exception e) {
            CreateComponentInfo.usage();
        }
    }

    private final /* synthetic */ void this() {
        this.author = "-";
        this.version = "1.001";
        this.description = "";
    }

    public CreateComponentInfo() {
        this.this();
    }
}

