/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.manager.DesignManager;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.ImageIcon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ComponentInfo {
    public static boolean debug = false;
    private String name;
    private String author;
    private String version;
    private String type;
    private String html;
    private String description;
    private String pathname;
    private String iconpath;
    private String imagepath;
    private String start;
    private String archive;
    private String init;
    private Vector files;
    private Vector refs;

    public String getSubtype() {
        String ret = null;
        if (!this.type.equals("beans")) {
            return ret;
        }
        if (this.init == null) {
            ret = "simobject";
        } else if (this.init.endsWith(".hds")) {
            ret = "design";
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public Vector getFiles() {
        return this.files;
    }

    public void addFile(String file) {
        if (file != null) {
            this.files.addElement(file);
        }
    }

    public boolean removeFile(String file) {
        return this.files.removeElement(file);
    }

    public Vector getReferences() {
        return this.refs;
    }

    public void addReference(String ref) {
        if (ref != null) {
            this.refs.addElement(ref);
        }
    }

    public boolean removeReference(String ref) {
        return this.refs.removeElement(ref);
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getInit() {
        return this.init;
    }

    public void setInit(String init) {
        this.init = init;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAuthor() {
        if (this.author != null) {
            return this.author;
        }
        return "unknown";
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    public String getArchive() {
        return this.archive;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public String getImagepath() {
        return this.imagepath;
    }

    public void setImagepath(String imagepath) {
        this.imagepath = imagepath;
    }

    public String getIconpath() {
        return this.iconpath;
    }

    public void setIconpath(String iconpath) {
        this.iconpath = iconpath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHTML() {
        return this.html;
    }

    public void setHTML(String file) {
        this.html = file;
    }

    public boolean showOpen() {
        boolean bl = false;
        if (this.init != null && this.init.endsWith(".hds")) {
            bl = true;
        }
        return bl;
    }

    public boolean search(Vector keys) {
        int i = 0;
        while (i < keys.size()) {
            String key = ((String)keys.elementAt(i)).toLowerCase();
            if (this.name.toLowerCase().indexOf(key) >= 0) {
                return true;
            }
            if (this.author.toLowerCase().indexOf(key) >= 0) {
                return true;
            }
            if (this.description != null && this.description.toLowerCase().indexOf(key) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ImageIcon getIconObject() {
        Image tmp = DesignManager.getDesignManager().getThumbnail(this.iconpath);
        if (tmp != null) {
            return new ImageIcon(tmp);
        }
        return null;
    }

    public Image getImageObject() {
        return DesignManager.getDesignManager().getThumbnail(this.imagepath);
    }

    public void saveComponentInfo() throws IOException {
        this.saveComponentInfo(null);
    }

    public void saveComponentInfo(String pathname) throws IOException {
        String newPathname = pathname != null ? pathname : this.pathname;
        OutputStream OS = null;
        OS = DesignManager.getDesignManager().getOutputStream(this, newPathname);
        String data = "";
        data = data + "[files ";
        data = data + this.files.size() + "]\n";
        int i = 0;
        while (i < this.files.size()) {
            data = data + (String)this.files.elementAt(i) + '\n';
            ++i;
        }
        data = data + '\n';
        data = data + "[versions 1]\n";
        data = data + this.version + "\n\n";
        data = data + "[references ";
        data = data + this.refs.size() + "]\n";
        i = 0;
        while (i < this.refs.size()) {
            data = data + (String)this.refs.elementAt(i) + '\n';
            ++i;
        }
        data = data + '\n';
        data = data + "[type]\n" + this.type + "\n\n";
        if (this.start != null) {
            data = data + "[start]\n";
            data = data + this.start + "\n\n";
        }
        if (this.init != null) {
            data = data + "[init]\n";
            data = data + this.init + "\n\n";
        }
        if (this.iconpath != null) {
            data = data + "[icon]\n";
            data = data + this.iconpath + "\n\n";
        }
        if (this.imagepath != null) {
            data = data + "[image]\n";
            data = data + this.imagepath + "\n\n";
        }
        if (this.archive != null) {
            data = data + "[archive]\n";
            data = data + this.archive + "\n\n";
        }
        if (this.author != null) {
            data = data + "[author]\n";
            data = data + this.author + "\n\n";
        }
        if (this.description != null) {
            data = data + "[description]\n";
            data = data + this.description + "\n[end description]\n";
        }
        if (this.html != null) {
            data = data + "[html]\n";
            data = data + this.html + "\n\n";
        }
        try {
            DataOutputStream dos = new DataOutputStream(OS);
            dos.write(data.getBytes());
            dos.close();
        }
        catch (IOException ex) {
            ComponentInfo.msg("-E- ComponentInfo: saveComponent failed for: " + pathname);
            throw new IOException("Failed to save 'clb': " + pathname);
        }
    }

    public String toString() {
        return "CLB:" + this.pathname + ' ' + this.imagepath + ' ' + this.iconpath;
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) throws Exception {
        ComponentInfo.msg("-I- ComponentInfo selftest...");
        ComponentInfo[] clb = new ComponentInfo[argv.length];
        int i = 0;
        while (i < argv.length) {
            ComponentInfo.msg("");
            ComponentInfo.msg("...checking: " + argv[i]);
            clb[i] = new ComponentInfo(argv[i]);
            ComponentInfo.msg("...loaded: " + clb[i].toString());
            ComponentInfo.msg("...description: \n" + clb[i].getDescription());
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.name = "unnamed";
        this.author = "--";
        this.version = "1.001";
        this.type = null;
        this.html = null;
        this.description = null;
        this.pathname = "no pathname";
        this.iconpath = "";
        this.imagepath = "";
        this.start = null;
        this.archive = null;
        this.init = null;
        this.files = new Vector();
        this.refs = new Vector();
    }

    public ComponentInfo() {
        this.this();
    }

    public ComponentInfo(String pathname) throws FileNotFoundException, IOException {
        String line;
        this.this();
        if (debug) {
            ComponentInfo.msg("-I- ComponentInfo.<init>: " + pathname);
        }
        this.pathname = pathname;
        ByteArrayOutputStream baos = DesignManager.getDesignManager().readStreamIntoBuffer(pathname);
        BufferedReader br = new BufferedReader(new StringReader(baos.toString()));
        while ((line = br.readLine()) != null) {
            int i;
            if ((line = line.trim().toLowerCase()).startsWith("[files ")) {
                int num = 0;
                try {
                    num = Integer.parseInt(line.substring(7, line.indexOf(93)));
                }
                catch (Exception ex) {
                    ComponentInfo.msg("-E- ComponentInfo: invalid number of [files x]: " + line);
                    throw new IOException("invalid 'clb'-file");
                }
                i = 0;
                while (i < num) {
                    this.files.addElement(br.readLine().trim());
                    ++i;
                }
                continue;
            }
            if (line.startsWith("[references ")) {
                int num = 0;
                try {
                    num = Integer.parseInt(line.substring(12, line.indexOf(93)));
                }
                catch (Exception ex) {
                    ComponentInfo.msg("-E- ComponentInfo: invalid number of [references x]: " + line);
                    throw new IOException("invalid 'clb'-file");
                }
                i = 0;
                while (i < num) {
                    this.refs.addElement(br.readLine().trim());
                    ++i;
                }
                continue;
            }
            if (line.equals("[type]")) {
                this.type = br.readLine().trim();
                continue;
            }
            if (line.equals("[start]")) {
                this.start = br.readLine().trim();
                continue;
            }
            if (line.equals("[init]")) {
                this.init = br.readLine().trim();
                continue;
            }
            if (line.equals("[archive]")) {
                this.archive = br.readLine().trim();
                continue;
            }
            if (line.equals("[icon]")) {
                this.iconpath = br.readLine().trim();
                continue;
            }
            if (line.equals("[image]")) {
                this.imagepath = br.readLine().trim();
                continue;
            }
            if (line.equals("[author]")) {
                this.author = br.readLine().trim();
                continue;
            }
            if (line.equals("[version]")) {
                this.version = br.readLine().trim();
                continue;
            }
            if (line.equals("[description]")) {
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    if (line.equals("[end description]")) continue;
                    sb.append(line);
                    sb.append("\n");
                }
                this.description = sb.toString();
                continue;
            }
            if (!line.equals("[html]")) continue;
            this.html = br.readLine().trim();
        }
        if (this.files.size() == 0) {
            ComponentInfo.msg("-W- ComponentInfo -> Component without any files!");
        }
    }
}

