/*
 * Decompiled with CFR 0.152.
 */
package hades.jpshell;

import hades.gui.PropertySheet;
import hades.jpshell.JPShell;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.ContextToolTip;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.python.util.PythonInterpreter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPWrapper
extends SimObject
implements Simulatable,
ContextToolTip,
Serializable {
    private static PythonInterpreter interp = null;
    private JPWrapper pyObj;
    public String pyModul;
    public String pyClass;
    public String pyWriteArgs;
    private boolean debug;
    public Port[] ports;
    public double t_delay;

    public double getDelay() {
        return this.t_delay;
    }

    public void setDelay(double t) {
        if (this.pyObj != null) {
            this.pyObj.setDelay(t);
        }
        this.t_delay = t;
    }

    public void setDelay(String s) {
        try {
            this.t_delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- JPWrapper.setDelay(): " + e);
            this.t_delay = 5.0E-9;
            this.message("-I- resetting to default value, delay = " + this.t_delay);
        }
        this.pyObj.setDelay(this.t_delay);
    }

    public void configure() {
        if (this.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public String getSymbolResourceName() {
        return this.pyObj.getSymbolResourceName();
    }

    public boolean initialize(String s) {
        block8: {
            if (this.debug) {
                System.out.println("JPWrapper initialize.." + s);
            }
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                this.versionId = Integer.parseInt(st.nextToken());
                if (n_tokens >= 2) {
                    this.t_delay = Double.valueOf(st.nextToken());
                }
                if (n_tokens >= 3) {
                    this.pyModul = st.nextToken();
                    this.pyClass = st.nextToken();
                    if (n_tokens >= 4) {
                        this.pyWriteArgs = st.nextToken();
                        if (this.debug) {
                            System.out.println("JPWrapper pyWriteArgs:" + this.pyWriteArgs);
                        }
                    }
                    this.pyObj = this.createJPObject(this.pyModul, this.pyClass, this.pyWriteArgs);
                    this.pyObj.setName(this.name);
                    this.pyObj.setDelay(this.t_delay);
                    this.ports = this.pyObj.ports;
                    this.setPorts(this.ports);
                    int i = 0;
                    while (i < this.ports.length) {
                        Port tmpPort = this.ports[i];
                        tmpPort.setParent(this);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                if (!this.debug) break block8;
                System.out.println("JPWrapper error " + e);
            }
        }
        return true;
    }

    public JPWrapper createJPObject(String pyModul, String pyClass, String args) {
        if (this.debug) {
            System.out.println("createJPObject: " + pyModul + ',' + pyClass + ',' + args);
        }
        if (interp == null) {
            if (this.debug) {
                System.out.println("erzeuge interp");
            }
            if ((interp = JPShell.getInterpreter()) == null) {
                interp = new PythonInterpreter();
                this.updatePythonPath();
                interp.set("editor", (Object)this.editor);
                this.execResource("/hades/jpshell/module/init_jpshell.py");
            }
        }
        interp.exec("from " + pyModul + " import " + pyClass);
        interp.exec("pyObj = " + pyClass + "()");
        if (args == null || args.equals("null")) {
            if (this.debug) {
                System.out.println("null args");
            }
        } else if (args.length() > 0) {
            if (this.debug) {
                System.out.println("JPWrapper args:" + args);
            }
            interp.exec("pyObj.setArgs('" + args + "')");
        }
        Class<?> javaClass = new JPWrapper().getClass();
        this.pyObj = (JPWrapper)interp.get("pyObj", javaClass);
        return this.pyObj;
    }

    public void write(PrintWriter ps) {
        if (this.debug) {
            System.out.println(" " + this.versionId + ' ' + this.t_delay + ' ' + this.pyModul + ' ' + this.pyClass + ' ' + this.pyWriteArgs);
        }
        ps.print(" " + this.versionId + ' ' + this.t_delay + ' ' + this.pyModul + ' ' + this.pyClass + ' ' + this.pyWriteArgs);
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
        this.pyObj.elaborate(arg);
    }

    public void evaluate(Object arg) {
        if (this.debug) {
            System.out.println("JPWrapper.elaborate(arg)...ignored." + arg);
        }
        this.pyObj.evaluate(arg);
    }

    public void scheduleEvent(Signal signal, double time, StdLogic1164 value, Port port) {
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleEventAfter(Signal signal, double delay, StdLogic1164 value, Port port) {
        double time = this.simulator.getSimTime() + delay;
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public SimObject copy() {
        System.out.println("copy: " + this.pyModul + ", " + this.pyClass + ", " + this.pyWriteArgs);
        JPWrapper tmpPyObj = this.createJPObject(this.pyModul, this.pyClass, this.pyWriteArgs);
        JPWrapper clone = (JPWrapper)super.copy();
        System.out.println("copy: huhu ");
        clone.pyObj = tmpPyObj;
        clone.setPyModul(this.pyModul);
        clone.setPyClass(this.pyClass);
        clone.setPyWriteArgs(this.pyWriteArgs);
        Port[] tmp_p = tmpPyObj.ports;
        if (this.debug) {
            System.out.println("tmp_p: " + tmp_p + "tmp_p: " + tmp_p.length);
        }
        clone.ports = tmp_p;
        int i = 0;
        while (i < clone.ports.length) {
            Port tmpPort = clone.ports[i];
            tmpPort.setParent(clone);
            ++i;
        }
        clone.setPorts(clone.ports);
        clone.setDelay(this.getDelay());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + '\n' + this.getClass().getName() + "\ndelay=" + this.t_delay;
    }

    public String toString() {
        return "JPWrapper: " + this.getFullName();
    }

    public void setPyObj(JPWrapper pyObj) {
        this.pyObj = pyObj;
        Port[] ports = pyObj.ports;
        int i = 0;
        while (i < ports.length) {
            Port tmpPort = ports[i];
            tmpPort.setParent(this);
            ++i;
        }
        this.t_delay = pyObj.t_delay;
        this.pyWriteArgs = pyObj.pyWriteArgs;
    }

    public JPWrapper getPyObj() {
        return this.pyObj;
    }

    public void updatePythonPath() {
        String hades_home = System.getProperty("HADES_HOME");
        if (hades_home != null) {
            interp.exec("import sys");
            interp.exec("sys.path.insert(0, '" + hades_home + "/jpshell/module')");
            interp.exec("sys.path.insert(1, '" + hades_home + "/jpshell/examples')");
            interp.exec("sys.path.insert(2, '" + hades_home + "/jpshell/module/objects')");
        } else {
            interp.exec("import sys");
            interp.exec("sys.path.insert(0, './jpshell/module')");
            interp.exec("sys.path.insert(1, './jpshell/examples')");
            interp.exec("sys.path.insert(2, './jpshell/module/objects')");
            if (this.debug) {
                System.out.println("JPWrapper-Init-ERROR, HADES_HOME not found in system properties,\n we try to use current dir (.)!\n(please start with: java -DHADES_HOME=<your_hades_dir> hades.gui.Editor)");
            }
        }
    }

    public void execResource(String resourcefilename) {
        InputStream IS = this.getClass().getResourceAsStream(resourcefilename);
        interp.execfile(IS);
    }

    public void setPyModul(String s) {
        this.pyModul = s;
    }

    public void setPyClass(String s) {
        this.pyClass = s;
    }

    public void setPyWriteArgs(String s) {
        if (this.debug) {
            System.out.println("JPWrapper pyargs " + s);
        }
        this.pyWriteArgs = s;
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.t_delay = 5.0E-9;
    }

    public JPWrapper() {
        this.this();
        if (this.debug) {
            System.out.println("JPWrapper construktor ends");
        }
    }
}

