/*
 * Decompiled with CFR 0.152.
 */
package hades.jpshell;

import hades.gui.Editor;
import hades.jpshell.History;
import hades.jpshell.MyPythonInterpreter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPShell
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    protected static MyPythonInterpreter interp;
    protected History history;
    private boolean debug;
    private String version;
    protected TextArea textArea;
    protected TextField prompt;
    protected ByteArrayOutputStream printStream;

    public void execResource(String resourcefilename) {
        InputStream IS = this.getClass().getResourceAsStream(resourcefilename);
        interp.execfile(IS);
    }

    public void updatePythonPath() {
        String hades_home = System.getProperty("HADES_HOME");
        if (hades_home != null) {
            interp.exec("import sys");
            interp.exec("sys.path.insert(0, '" + hades_home + "/jpshell/module')");
            interp.exec("sys.path.insert(1, '" + hades_home + "/jpshell/examples')");
            interp.exec("sys.path.insert(2, '" + hades_home + "/jpshell/module/objects')");
        } else {
            interp.exec("import sys");
            interp.exec("sys.path.insert(0, './jpshell/module')");
            interp.exec("sys.path.insert(1, './jpshell/examples')");
            interp.exec("sys.path.insert(2, './jpshell/module/objects')");
            System.out.println("jpshell warning: HADES_HOME not found in system properties,\n we try to use current dir (.)!\n(please start with: java -DHADES_HOME=<your_hades_dir> hades.gui.Editor)");
        }
    }

    protected void createGui() {
        this.textArea = new TextArea(20, 80);
        this.prompt = new TextField("", 80);
        this.setTitle("HADES JPShell " + this.version);
        this.setBackground(Color.lightGray);
        this.textArea.setBackground(Color.lightGray);
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.textArea.setEditable(false);
        this.prompt.setBackground(Color.lightGray);
        this.prompt.addKeyListener(this);
        this.add("Center", this.textArea);
        this.add("South", this.prompt);
        this.addWindowListener(this);
    }

    protected void initInterp() {
        interp = new MyPythonInterpreter(this.printStream);
    }

    protected void enter() {
        String s = this.prompt.getText();
        this.prompt.setText("");
        if (this.debug) {
            System.out.println("->: " + s);
        }
        this.textArea.append(">>>" + s + '\n');
        try {
            interp.exec(s);
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println("Exception: " + e);
            }
            this.textArea.append("Exception: " + e);
        }
        this.textArea.append("" + this.printStream + '\n');
        this.printStream.reset();
        if (s.length() > 0) {
            this.history.addCommand(s);
        }
    }

    public void setEditor(Editor editor) {
        if (this.debug) {
            System.out.println("-> setEditor: " + editor);
        }
        interp.set("editor", editor);
    }

    public void updateDesign() {
        interp.exec("updateDesign()");
    }

    public void keyPressed(KeyEvent e) {
        if (this.debug) {
            System.out.println("keyPressed: " + e);
        }
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 38: {
                if (this.debug) {
                    System.out.println("UP " + this.history.getIndex());
                }
                this.prompt.setText(this.history.prev());
                break;
            }
            case 40: {
                if (this.debug) {
                    System.out.println("DOWN " + this.history.getIndex());
                }
                this.prompt.setText(this.history.next());
                break;
            }
            case 10: {
                if (this.debug) {
                    System.out.println("ENTER");
                }
                this.enter();
                break;
            }
            case 68: {
                if (this.debug) {
                    System.out.println("CTRL+d");
                }
                if (!e.isControlDown()) break;
                this.stop();
                break;
            }
        }
    }

    public void windowDeiconified(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowDeiconified: " + e);
        }
    }

    public void windowIconified(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowIconified: " + e);
        }
    }

    public void windowActivated(WindowEvent e) {
        this.prompt.requestFocus();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowOpened: " + e);
        }
    }

    public void windowClosed(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowClosed: " + e);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowClosing: " + e);
        }
        this.stop();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (this.debug) {
            System.out.println("action cmd: " + cmd);
        }
    }

    public void stop() {
        this.dispose();
    }

    public static MyPythonInterpreter getInterpreter() {
        return interp;
    }

    public String toString() {
        return "Java-Python-Shell (" + this.version + ')';
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.version = new String("v0.63 03.04.2001");
        this.printStream = new ByteArrayOutputStream();
    }

    public JPShell() {
        this.this();
        if (this.debug) {
            System.out.println("Java-Python-Shell (" + this.version + ')');
        }
        this.history = new History();
        this.createGui();
        this.pack();
        this.setVisible(true);
    }

    public JPShell(Editor editor) {
        this();
        try {
            this.initInterp();
            this.setEditor(editor);
            this.updatePythonPath();
            this.execResource("/hades/jpshell/module/init_jpshell.py");
            interp.exec("jp_tools._welcome()");
            this.enter();
        }
        catch (Exception e) {
            System.out.println("JPShell raise an Error : " + e);
            System.out.println("JPShell-Init-ERROR, HADES_HOME not found in system properties,\n we try to use current dir (.)!\n(please start with: java -DHADES_HOME=<your_hades_dir> hades.gui.Editor)");
        }
    }

    public JPShell(Editor editor, InputStream jpshell_init) {
        this();
        try {
            this.initInterp();
            this.setEditor(editor);
            this.updatePythonPath();
            this.execResource("/hades/jpshell/module/init_jpshell.py");
            this.enter();
        }
        catch (Exception e) {
            System.out.println("JPShell raise an Error: " + e);
            System.out.println("JPShell-Init-ERROR, HADES_HOME not found in system properties,\n we try to use current dir (.)!\n(please start with: java -DHADES_HOME=<your_hades_dir> hades.gui.Editor)");
        }
    }
}

