/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.ExportOptionsDialog;
import hades.gui.GUIFactory;
import hades.gui.JAboutDialog;
import hades.gui.JCanvasScroller;
import hades.gui.JEditFrame;
import hades.gui.JExportOptionsAdapter;
import hades.gui.JObjectCanvas;
import hades.gui.JPropertiesViewer;
import hades.gui.JPropertySheet;
import hades.gui.JSelectURLDialog;
import hades.gui.JSimControlPanel;
import hades.gui.JStatusPanel;
import hades.gui.JStringDialog;
import hades.gui.ObjectCanvas;
import hades.gui.PropertySheet;
import hades.gui.SelectURLDialog;
import hades.gui.SimControlPanel;
import hades.gui.StatusPanel;
import hades.gui.StringDialog;
import hades.manager.DesignManager;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.gui.JTextViewer;
import jfig.utils.SetupManager;

class SwingFactory
extends GUIFactory {
    SwingFactory() {
    }

    public Frame createEditFrame(Editor editor, String versionString) {
        return new JEditFrame(editor, versionString);
    }

    public ObjectCanvas createObjectCanvas(Editor editor) {
        JObjectCanvas objectCanvas = new JObjectCanvas(editor);
        objectCanvas.setContextToolTipProvider(editor);
        return objectCanvas;
    }

    public StatusPanel createStatusPanel() {
        return new JStatusPanel();
    }

    public SimControlPanel createSimControlPanel(SimKernel s, Frame f) {
        return new JSimControlPanel(s, f);
    }

    public Container createEditFrameLayout(Frame editFrame, Component statusPanel, ObjectCanvas objectCanvas) {
        Container container = null;
        container = editFrame != null && editFrame instanceof JFrame ? ((JFrame)editFrame).getContentPane() : new JPanel(new BorderLayout());
        container.add("North", statusPanel);
        container.add("Center", new JCanvasScroller(objectCanvas));
        return container;
    }

    public void doShowProperties() {
        JPropertiesViewer pv = new JPropertiesViewer(SetupManager.getProperties());
        pv.setTitle("Hades properties");
        pv.showProperties();
        pv.setVisible(true);
    }

    public Component createAndShowTextViewer(String title, int rows, int cols, String resource) {
        try {
            InputStream inputStream = DesignManager.getDesignManager().getInputStream(this, resource);
            JTextViewer viewer = new JTextViewer(title, rows, cols);
            viewer.parse(inputStream);
            viewer.setCaretPosition(0);
            viewer.setVisible(true);
            inputStream.close();
            return viewer;
        }
        catch (Throwable t) {
            System.err.println("-E- SwingFactory.createAndShowTextViewer: " + t);
            System.err.println("-E- for resource '" + resource + "'");
            return null;
        }
    }

    public StringDialog createStringDialog(Frame frame, String title, String prompt) {
        return new JStringDialog(frame, title, prompt);
    }

    public SelectURLDialog createSelectURLDialog(Frame frame, String title, String prompt) {
        return new JSelectURLDialog(frame, title, prompt);
    }

    public PropertySheet getPropertySheet(SimObject simObj, Frame frame, String[] fields) {
        return new JPropertySheet(simObj, frame, fields);
    }

    public void doShowAbout(Frame frame, String versionString) {
        JFrame parent = frame instanceof JFrame ? (JFrame)frame : null;
        JAboutDialog jad = new JAboutDialog(parent, versionString);
        jad.pack();
        jad.setVisible(true);
    }

    public ExportOptionsDialog createExportOptionsDialog(Editor editor) {
        return new JExportOptionsAdapter(editor);
    }
}

