/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.models.StdLogic1164;
import hades.models.io.Stimulus;
import hades.utils.HexFormat;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.gui.FontCache;
import jfig.gui.ImageHelper;
import jfig.utils.SetupManager;

public class StimuliEditorCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    public static final boolean debug = false;
    protected Stimulus stimulus;
    protected int n_cycles;
    protected int n_outputs;
    protected String[] addrCache;
    protected String[] dataCache;
    protected Hashtable actionListenerTable;
    protected Font textFont;
    protected Color backgroundColor;
    protected Color dataColor;
    protected Color signalNameColor;
    protected Color timeColor;
    protected Color readHighlightColor;
    protected Color writeHighlightColor;
    protected Color cursorColor;
    protected Image offscreenBuffer;
    protected Graphics offscreenGraphics;
    protected Scrollbar scroller;
    protected int n_columns;
    protected int n_rows;
    protected int n_cycles_per_row;
    protected int n_chars_per_cycle;
    protected int n_chars_per_addr;
    protected int char_width;
    protected int char_height;
    protected int baseline;
    protected int x0_addr;
    protected int x0_data;
    protected int y0_addr;
    protected int y0_data;
    protected int dx_data;
    protected int x0_time;
    protected int y0_time;
    protected int border_width;
    protected int border_height;
    protected int width;
    protected int height;
    protected int start_cycle;
    protected int end_address;
    protected int cursor_x;
    protected int cursor_y;
    protected int n_cursor;
    protected int n_chars;
    protected int value;
    protected Point dragStartPosition;
    protected Point currentMousePosition;
    protected int lastDragCycle;
    protected Point regionStartPoint;
    protected Point regionEndPoint;
    protected int readHighlightAddress = -1;
    protected int writeHighlightAddress = -1;
    static Color[] _colorTable = new Color[9];
    static Color _darkBlue = new Color(0, 0, 180);
    private static final int[] digit_masks;
    private static final long[] bit_masks;

    public StimuliEditorCanvas(Stimulus stimulus, int n) {
        StimuliEditorCanvas.msg("-I- StimuliEditorCanvas.<init>... ");
        this.stimulus = stimulus;
        this.n_cycles_per_row = n;
        this.updateLimits();
        this.prepareGUI();
        this.actionListenerTable = new Hashtable();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void updateLimits() {
        this.n_cycles = this.stimulus.getNumberOfCycles();
        this.n_outputs = this.stimulus.getNumberOfOutputs();
        this.n_rows = this.stimulus.getNumberOfOutputs() + 1;
        this.start_cycle = 0;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public void setDataColor(Color color) {
        this.dataColor = color;
        this.repaint();
    }

    public void setTimeColor(Color color) {
        this.timeColor = color;
        this.repaint();
    }

    public void setAddrColor(Color color) {
        this.signalNameColor = color;
        this.repaint();
    }

    public void setReadHighlightColor(Color color) {
        this.readHighlightColor = color;
        this.repaint();
    }

    public void setWriteHighlightColor(Color color) {
        this.writeHighlightColor = color;
        this.repaint();
    }

    public void setCursorColor(Color color) {
        this.cursorColor = color;
        this.repaint();
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getTimeColor() {
        return this.timeColor;
    }

    public Color getDataColor() {
        return this.dataColor;
    }

    public Color getDataColor1164(int n) {
        return _colorTable[n];
    }

    public Color getAddrColor() {
        return this.signalNameColor;
    }

    public Color getReadHightlightColor() {
        return this.readHighlightColor;
    }

    public Color getWriteHightlightColor() {
        return this.writeHighlightColor;
    }

    protected void notifyListeners(int n, long l) {
        if (this.actionListenerTable == null) {
            return;
        }
        if (this.actionListenerTable.size() == 0) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, "" + n + " " + l);
        Enumeration enumeration = this.actionListenerTable.keys();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListenerTable.put(actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListenerTable.remove(actionListener);
    }

    protected void prepareGUI() {
        this.n_chars_per_addr = 4;
        this.n_chars_per_cycle = 2;
        this.n_columns = this.n_chars_per_addr + 2 + this.n_chars_per_cycle * this.n_cycles_per_row;
        this.backgroundColor = SetupManager.getColor("Hades.StimuliEditorCanvas.BackgroundColor", Color.white);
        this.dataColor = SetupManager.getColor("Hades.StimuliEditorCanvas.DataColor", Color.blue);
        this.timeColor = SetupManager.getColor("Hades.StimuliEditorCanvas.TimeColor", Color.black);
        this.cursorColor = SetupManager.getColor("Hades.StimuliEditorCanvas.CursorColor", Color.red);
        this.signalNameColor = SetupManager.getColor("Hades.StimuliEditorCanvas.AddrColor", Color.black);
        this.readHighlightColor = SetupManager.getColor("Hades.StimuliEditorCanvas.ReadHighlightColor", Color.green);
        this.writeHighlightColor = SetupManager.getColor("Hades.StimuliEditorCanvas.WriteHighlightColor", Color.red);
        this.setBackground(this.backgroundColor);
        String string = SetupManager.getProperty("Hades.StimuliEditorCanvas.FontName", "Monospaced");
        int n = SetupManager.getInteger("Hades.StimuliEditorCanvas.FontSize", 15);
        int n2 = SetupManager.getInteger("Hades.StimuliEditorCanvas.FontStyle", 0);
        this.setTextFont(new Font(string, n2, n));
        this.setCursor(0, 0);
        this.dragStartPosition = new Point(-1, -1);
        this.regionStartPoint = new Point(-1, -1);
        this.regionEndPoint = new Point(-1, -1);
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        FontMetrics fontMetrics = FontCache.getFontCache().getFontMetrics(this.textFont);
        this.char_width = fontMetrics.charWidth('M');
        this.char_height = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.baseline = fontMetrics.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.x0_addr = this.border_width;
        this.x0_time = this.x0_data = this.x0_addr + (this.n_chars_per_addr + 2) * this.char_width;
        this.y0_time = this.border_height + this.baseline;
        this.y0_data = this.y0_time + 1 * this.char_height;
        this.y0_addr = this.y0_time + 1 * this.char_height;
        this.dx_data = this.n_chars_per_cycle * this.char_width;
        this.repaint();
    }

    protected void createOffscreenBuffer() {
        this.offscreenBuffer = ImageHelper.createImage(this.width, this.height);
        if (this.offscreenBuffer != null) {
            this.offscreenGraphics = this.offscreenBuffer.getGraphics();
        }
    }

    public void blitOffscreenBuffer(Graphics graphics) {
        ImageObserver imageObserver = null;
        graphics.drawImage(this.offscreenBuffer, 0, 0, imageObserver);
    }

    public void paintBackgroundAndBorder(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
        graphics.draw3DRect(1, 1, this.width - 3, this.height - 3, false);
    }

    public void paintSignalNames(Graphics graphics) {
        int n = this.x0_addr;
        int n2 = this.y0_addr;
        graphics.setColor(this.signalNameColor);
        graphics.setFont(this.textFont);
        for (int i = 0; i < this.n_outputs; ++i) {
            String string = this.padToWidth(this.stimulus.getSignalName(i), this.n_chars_per_addr);
            graphics.drawString(string, n, n2);
            n2 += this.char_height;
        }
    }

    public void paintTimeScale(Graphics graphics) {
        int n = this.start_cycle;
        int n2 = this.x0_time;
        int n3 = this.y0_time;
        graphics.setColor(this.timeColor);
        graphics.setFont(this.textFont);
        for (int i = 0; i < this.n_cycles_per_row; ++i) {
            int n4 = n + i;
            if (n4 % 5 == 0) {
                graphics.drawString("" + n4, n2, n3);
            }
            n2 += this.dx_data;
        }
    }

    public void paintAllData(Graphics graphics) {
        int n = this.start_cycle;
        int n2 = this.x0_data;
        int n3 = this.y0_data;
        graphics.setColor(this.dataColor);
        graphics.setFont(this.textFont);
        for (int i = 0; i < this.n_outputs; ++i) {
            n2 = this.x0_data;
            n = this.start_cycle;
            for (int j = 0; j < this.n_cycles_per_row && n < this.n_cycles; ++j) {
                int n4 = this.stimulus.getDataAt(i, n);
                String string = "" + StdLogic1164.chars[n4];
                if (n4 == 2) {
                    graphics.setColor(this.getDataColor1164(n4));
                    graphics.drawLine(n2 - 1, n3, n2 + this.dx_data - 2, n3);
                } else if (n4 == 3) {
                    graphics.setColor(this.getDataColor1164(n4));
                    graphics.fillRect(n2 - 1, n3 - 10, this.dx_data - 1, 11);
                } else {
                    graphics.setColor(this.getDataColor1164(n4));
                    graphics.fillRect(n2 - 1, n3 - 10, this.dx_data - 1, 11);
                    graphics.setColor(Color.white);
                    graphics.drawString(string, n2, n3);
                }
                ++n;
                n2 += this.dx_data;
            }
            n3 += this.char_height;
        }
    }

    public void paintStringAtAddr(Graphics graphics, int n, String string) {
        int n2 = (n - this.start_cycle) / this.n_cycles_per_row;
        int n3 = n - this.start_cycle - n2 * this.n_cycles_per_row;
        int n4 = n3 * (this.n_chars_per_cycle + 1);
        graphics.drawString(string, this.x0_data + n4 * this.char_width, this.y0_data + n2 * this.char_height);
    }

    public void paintHighlighting(Graphics graphics) {
    }

    public void paintCursor(Graphics graphics) {
        int n = this.x0_data;
        int n2 = this.y0_data;
        graphics.setColor(this.cursorColor);
        graphics.setFont(this.textFont);
        graphics.drawString("_", n + this.cursor_x * (this.char_width * this.n_chars_per_cycle), n2 + this.cursor_y * this.char_height);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.textFont == null) {
            this.prepareGUI();
        }
        if (this.offscreenGraphics == null) {
            this.createOffscreenBuffer();
        }
        Graphics graphics2 = this.offscreenGraphics != null ? this.offscreenGraphics : graphics;
        this.paintBackgroundAndBorder(graphics2);
        this.paintSignalNames(graphics2);
        this.paintTimeScale(graphics2);
        this.paintAllData(graphics2);
        this.paintHighlighting(graphics2);
        this.paintCursor(graphics2);
        if (this.offscreenGraphics != null) {
            this.blitOffscreenBuffer(graphics);
        }
    }

    public String padToWidth(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 >= n) {
            return string.substring(0, n2);
        }
        int n3 = n - n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setCursor(int n, int n2) {
        this.cursor_x = this.clip(n, 0, this.n_cycles - 1);
        this.cursor_y = this.clip(n2, 0, this.n_outputs - 1);
    }

    public int getCursorRow() {
        return this.cursor_y;
    }

    public int getCursorCycle() {
        return this.start_cycle + this.cursor_x;
    }

    protected int getCursorX(int n) {
        int n2 = (int)(1.0 * (double)(n - this.x0_data) / (double)(this.char_width * this.n_chars_per_cycle) + 0.5);
        return this.clip(n2, 0, this.n_cycles_per_row - 1);
    }

    protected int getCursorY(int n) {
        int n2 = (int)(1.0 * (double)(n - this.y0_time) / (double)this.char_height - 0.5);
        return this.clip(n2, 0, this.n_outputs - 1);
    }

    public void setCursorFromMousePosition(MouseEvent mouseEvent) {
        this.cursor_x = this.getCursorX(mouseEvent.getX());
        this.cursor_y = this.getCursorY(mouseEvent.getY());
    }

    public int getCycleFromCursorPosition() {
        return this.start_cycle + this.cursor_y;
    }

    public void setRegionStartPoint(int n, int n2) {
        this.regionStartPoint = new Point(n, n2);
    }

    public void setRegionEndPoint(int n, int n2) {
        this.regionEndPoint = new Point(n, n2);
    }

    public boolean isCursorInDataArea() {
        return true;
    }

    public boolean isCursorInAddrArea() {
        return this.cursor_x < this.n_chars_per_addr;
    }

    public boolean isDataVisibleAtAddress(int n) {
        return n >= this.start_cycle && n < this.start_cycle;
    }

    public void makeDataVisibleAtAddress(int n) {
        this.start_cycle = 0;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - 1);
        this.notifyScroller();
        StimuliEditorCanvas.msg("makeDataVisibleAtAddress: " + n + " new start: " + this.start_cycle);
    }

    public int getRelativeDataCursor() {
        if (!this.isCursorInDataArea()) {
            StimuliEditorCanvas.msg("-E- Internal in getRelativeDataCursor: cursor is in addr!");
            return 0;
        }
        int n = (this.cursor_x - this.n_chars_per_addr - 2) % (this.n_chars_per_cycle + 1);
        return this.clip(n, 0, this.n_chars_per_cycle - 1);
    }

    public int getCursorAddrIndex() {
        if (!this.isCursorInAddrArea()) {
            StimuliEditorCanvas.msg("-E- Internal in getCursorAddrIndex: cursor isn't in addr!");
            return 0;
        }
        return this.start_cycle + this.cursor_y * this.n_cycles_per_row;
    }

    public int clip(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new Error("clip: max < min!");
        }
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void insertDataAtCursor() {
        this.stimulus.insertValueIntoRow(this.cursor_y, this.start_cycle + this.cursor_x, 2);
    }

    public void deleteDataAtCursor() {
        this.stimulus.deleteValueFromRow(this.cursor_y, this.start_cycle + this.cursor_x);
    }

    public void backSpace() {
        this.stimulus.deleteValueFromRow(this.cursor_y, this.start_cycle + this.cursor_x - 1);
        this.moveCursorLeft();
    }

    public void moveCursorTo(int n, int n2) {
        this.cursor_x = n;
        this.cursor_y = n2;
    }

    public void moveCursorRight() {
        StimuliEditorCanvas.msg("moveCursorRight...");
        ++this.cursor_x;
        if (this.cursor_x >= this.n_cycles_per_row) {
            this.cursor_x = this.n_cycles_per_row - 1;
            if (this.start_cycle + this.n_cycles_per_row < this.n_cycles) {
                ++this.start_cycle;
                this.notifyScroller();
                this.repaint();
            }
        }
    }

    public void moveCursorLeft() {
        StimuliEditorCanvas.msg("moveCursorLeft...");
        --this.cursor_x;
        if (this.cursor_x < 0) {
            this.cursor_x = 0;
            if (this.start_cycle > 0) {
                --this.start_cycle;
                this.notifyScroller();
                this.repaint();
            }
        }
    }

    public void moveCursorUp() {
        this.cursor_y = this.clip(--this.cursor_y, 0, this.n_outputs - 1);
    }

    public void moveCursorDown() {
        this.cursor_y = this.clip(++this.cursor_y, 0, this.n_outputs - 1);
    }

    public void movePageUp() {
        this.start_cycle -= this.n_cycles_per_row;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void movePageDown() {
        this.start_cycle += this.n_cycles_per_row;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveLineUp() {
        this.start_cycle -= this.n_cycles_per_row;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveLineDown() {
        this.start_cycle += this.n_cycles_per_row;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveHome() {
        this.cursor_x = 0;
        this.start_cycle = 0;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveEnd() {
        this.start_cycle = this.n_cycles - this.n_cycles_per_row - 1;
        this.start_cycle = this.clip(this.start_cycle, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveToCycle(int n) {
        this.start_cycle = this.clip(n, 0, this.n_cycles - this.n_cycles_per_row - 1);
        this.notifyScroller();
    }

    public void moveToCycle(int n, boolean bl) {
        this.start_cycle = this.clip(n, 0, this.n_cycles - this.n_cycles_per_row - 1);
        if (bl) {
            this.notifyScroller();
        }
    }

    public void moveCursorToDataAtAddr(int n) {
        if (!this.isDataVisibleAtAddress(n)) {
            this.makeDataVisibleAtAddress(n);
        }
        this.cursor_y = (n - this.start_cycle) / this.n_cycles_per_row;
        int n2 = n - this.start_cycle - this.cursor_y * this.n_cycles_per_row;
        this.cursor_x = this.n_chars_per_addr + 2 + n2 * (this.n_chars_per_cycle + 1);
    }

    public void moveTabNext() {
        int n = this.getCycleFromCursorPosition();
        n = this.clip(n + 1, 0, this.n_cycles - 1);
        this.moveCursorToDataAtAddr(n);
    }

    public void moveTabPrev() {
        int n = this.getCycleFromCursorPosition();
        n = this.clip(n - 1, 0, this.n_cycles - 1);
        this.moveCursorToDataAtAddr(n);
    }

    public void notifyScroller() {
        if (this.scroller == null) {
            return;
        }
        int n = this.scroller.getMaximum();
        int n2 = this.scroller.getVisibleAmount();
        int n3 = (int)(1.0 * (double)(n - n2) * (double)this.start_cycle / (double)(this.n_cycles - this.n_cycles_per_row));
        this.scroller.setValue(n3);
    }

    public void setScroller(Scrollbar scrollbar) {
        this.scroller = scrollbar;
        this.notifyScroller();
    }

    public void incrementValue() {
        int n = this.stimulus.getDataAt(this.cursor_y, this.start_cycle + this.cursor_x);
        n = n == 2 ? 3 : (n == 3 ? 1 : 2);
        this.stimulus.setDataAt(this.cursor_y, this.start_cycle + this.cursor_x, n);
    }

    public void incrementValueAll1164() {
        int n = this.stimulus.getDataAt(this.cursor_y, this.start_cycle + this.cursor_x);
        switch (n) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 8: {
                n = 0;
            }
        }
        this.stimulus.setDataAt(this.cursor_y, this.start_cycle + this.cursor_x, n);
    }

    public void decrementValue() {
        int n = this.stimulus.getDataAt(this.cursor_y, this.start_cycle + this.cursor_x);
        n = n == 3 ? 2 : (n == 2 ? 1 : 3);
        this.stimulus.setDataAt(this.cursor_y, this.start_cycle + this.cursor_x, n);
    }

    public void editStartAddress(char c) {
        int n = this.start_cycle + this.cursor_y * this.n_cycles_per_row;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(HexFormat.getHexString(n, this.n_chars_per_addr));
        stringBuffer.setCharAt(this.cursor_x, c);
        try {
            n2 = (int)Long.parseLong(stringBuffer.toString(), 16);
            n2 = this.clip(n2, 0, this.n_cycles - 13);
        }
        catch (Exception exception) {
            return;
        }
        this.start_cycle = n2;
        int n3 = this.cursor_x >= this.n_chars_per_addr - 1 ? 0 : this.cursor_x + 1;
        this.moveCursorTo(n3, 0);
        this.notifyScroller();
    }

    public void changeDataAtMousePosition(char c) {
        switch (c) {
            case 'X': 
            case 'x': {
                this.changeData(1);
                break;
            }
            case 'U': 
            case 'u': {
                this.changeData(0);
                break;
            }
            case ' ': 
            case '0': {
                this.changeData(2);
                break;
            }
            case '1': {
                this.changeData(3);
                break;
            }
            case 'Z': 
            case 'z': {
                this.changeData(4);
                break;
            }
            case 'L': 
            case 'l': {
                this.changeData(6);
                break;
            }
            case 'H': 
            case 'h': {
                this.changeData(7);
                break;
            }
            case 'W': 
            case 'w': {
                this.changeData(5);
                break;
            }
            case 'D': 
            case 'd': {
                this.changeData(8);
                break;
            }
            case 'T': 
            case 't': {
                this.incrementValue();
                break;
            }
            case 'I': 
            case 'i': {
                this.insertDataAtCursor();
                break;
            }
            default: {
                StimuliEditorCanvas.msg("-I- changeDataAt: ignoring char: " + c);
            }
        }
    }

    private void changeData(int n) {
        this.stimulus.setDataAt(this.cursor_y, this.start_cycle + this.cursor_x, n);
        this.moveCursorRight();
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        StimuliEditorCanvas.msg("-I- mouse pressed: " + mouseEvent);
        this.requestFocus();
        this.setCursorFromMousePosition(mouseEvent);
        this.dragStartPosition = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.lastDragCycle = -1;
        this.repaint(100L);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (point.equals(this.currentMousePosition)) {
            if (mouseEvent.isShiftDown()) {
                this.incrementValueAll1164();
            } else {
                this.incrementValue();
            }
        }
        this.currentMousePosition = point;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        StimuliEditorCanvas.msg("-D- dragged: " + mouseEvent + " " + this.dragStartPosition);
        int n = this.getCursorX(this.dragStartPosition.x) + this.start_cycle;
        int n2 = this.getCursorY(this.dragStartPosition.y);
        int n3 = this.getCursorX(mouseEvent.getX()) + this.start_cycle;
        int n4 = this.getCursorY(mouseEvent.getY());
        if (n3 != this.lastDragCycle) {
            StimuliEditorCanvas.msg("-X- drag active: " + n4 + " " + n3 + " " + n);
            int n5 = this.stimulus.getDataAt(n2, n);
            for (int i = Math.min(n, n3); i <= Math.max(n, n3); ++i) {
                this.stimulus.setDataAt(n2, i, n5);
            }
            this.repaint(100L);
        }
        this.lastDragCycle = n3;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (n == 39) {
                this.moveCursorRight();
            } else if (n == 37) {
                this.moveCursorLeft();
            } else if (n == 38) {
                if (keyEvent.isShiftDown()) {
                    this.incrementValue();
                } else {
                    this.moveCursorUp();
                }
            } else if (n == 40) {
                if (keyEvent.isShiftDown()) {
                    this.decrementValue();
                } else {
                    this.moveCursorDown();
                }
            } else if (n == 33) {
                this.movePageUp();
            } else if (n == 34) {
                this.movePageDown();
            } else if (n == 36) {
                this.moveHome();
            } else if (n == 35) {
                this.moveEnd();
            } else if (n == 155) {
                this.insertDataAtCursor();
            } else if (n == 127) {
                this.deleteDataAtCursor();
            } else if (n == 8) {
                this.backSpace();
            } else if (n == 9) {
                if (keyEvent.isShiftDown()) {
                    this.moveTabPrev();
                } else {
                    this.moveTabNext();
                }
            }
        } else if (c == '\t') {
            if (keyEvent.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else if (n == 155) {
            this.insertDataAtCursor();
        } else if (n == 127) {
            this.deleteDataAtCursor();
        } else if (n == 8) {
            this.backSpace();
        } else {
            this.changeDataAtMousePosition(c);
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void msg(String string) {
    }

    public static void main(String[] stringArray) {
        StimuliEditorCanvas.msg("StimuliEditorCanvas selftest...");
        SetupManager.loadLocalProperties(".hadesrc");
        long[] lArray = new long[65536];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = i;
        }
        long[] lArray2 = new long[2048];
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = i & 0xFF;
        }
        Frame frame = new Frame("StimuliEditorCanvas Demo");
        frame.setSize(new Dimension(100, 100));
        frame.setVisible(true);
        ImageHelper.setVisibleParent(frame);
        StimuliEditorCanvas stimuliEditorCanvas = new StimuliEditorCanvas(new Stimulus(), 40);
        frame.setLayout(new FlowLayout());
        frame.add(new Label("DCache:"));
        frame.add(stimuliEditorCanvas);
        frame.pack();
        stimuliEditorCanvas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StimuliEditorCanvas.msg("-I- action event: " + actionEvent.getActionCommand());
            }
        });
    }

    static {
        StimuliEditorCanvas._colorTable[0] = Color.cyan;
        StimuliEditorCanvas._colorTable[1] = Color.cyan;
        StimuliEditorCanvas._colorTable[2] = Color.blue;
        StimuliEditorCanvas._colorTable[3] = Color.blue;
        StimuliEditorCanvas._colorTable[4] = Color.orange;
        StimuliEditorCanvas._colorTable[6] = _darkBlue;
        StimuliEditorCanvas._colorTable[7] = _darkBlue;
        StimuliEditorCanvas._colorTable[5] = Color.orange;
        StimuliEditorCanvas._colorTable[8] = Color.green;
        digit_masks = new int[]{0, 1, 16, 256, 4096, 65536, 0x100000, 0x1000000, 0x10000000};
        bit_masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, -1L};
    }
}

