/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.StimuliEditorCanvas;
import hades.manager.DesignManager;
import hades.models.io.Stimulus;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jfig.gui.SimpleTextViewer;
import jfig.utils.ExceptionTracer;

public class StimuliEditor
extends Frame
implements ActionListener {
    static boolean debug = false;
    static String versionString = "HADES StimuliEditor 0.3";
    static String helpResourceName = "/hades/doc/help/StimuliEditorKeys.txt";
    Stimulus stimulus;
    Point regionStartPoint;
    Point regionEndPoint;
    Button allUndefinedButton;
    Button allZeroButton;
    Button allOneButton;
    Button allTristateButton;
    Button expandButton;
    Button invertButton;
    Button pwrOnResetButton;
    Button counterButton;
    Button clockButton;
    Button clock2Button;
    Button clock4Button;
    Button clock8Button;
    Label cycleLengthLabel;
    Label nCyclesLabel;
    Panel buttonPanel;
    Panel editorPanel;
    Panel cyclePanel;
    Panel filenamePanel;
    TextField cycleLengthTF;
    TextField nCyclesTF;
    TextField filenameTF;
    StimuliEditorCanvas editorCanvas;
    Scrollbar editorScroller;
    MenuBar menuBar;
    Menu fileMenu;
    Menu editMenu;
    Menu helpMenu;
    MenuItem loadMI;
    MenuItem saveMI;
    MenuItem saveAsMI;
    MenuItem saveVHDLMI;
    MenuItem closeMI;
    MenuItem regionStartMI;
    MenuItem regionEndMI;
    MenuItem regionMoveMI;
    MenuItem regionCopyMI;
    MenuItem regionClearMI;
    MenuItem regionSetMI;
    MenuItem clearAllMI;
    MenuItem helpAboutMI;
    MenuItem helpKeysMI;
    DesignManager DM = DesignManager.getDesignManager();

    public StimuliEditor(Stimulus stimulus) {
        super("StimuliEditor");
        this.stimulus = stimulus;
        this.buildMenu();
        this.buildButtonPanel();
        this.buildCyclePanel();
        this.buildEditorPanel();
        this.buildFilenamePanel();
        this.setupCallbacks();
        Panel dummy = new Panel(new BorderLayout());
        dummy.add("North", this.cyclePanel);
        dummy.add("South", this.buttonPanel);
        this.add("West", dummy);
        this.add("East", this.editorPanel);
        this.add("North", this.filenamePanel);
        this.setMenuBar(this.menuBar);
        this.regionStartPoint = new Point(0, 0);
        this.regionEndPoint = new Point(0, 0);
    }

    void buildButtonPanel() {
        this.allUndefinedButton = new Button("Fill U");
        this.allZeroButton = new Button("Fill 0");
        this.allOneButton = new Button("Fill 1");
        this.allTristateButton = new Button("Fill Z");
        this.expandButton = new Button("Expand");
        this.invertButton = new Button("Invert");
        this.pwrOnResetButton = new Button("PwrOnReset");
        this.counterButton = new Button("Counter");
        this.clockButton = new Button("Clock ");
        this.clock2Button = new Button("Clock/2");
        this.clock4Button = new Button("Clock/4");
        this.clock8Button = new Button("Clock/8");
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new GridLayout(6, 2));
        this.buttonPanel.add(this.allUndefinedButton);
        this.buttonPanel.add(this.allZeroButton);
        this.buttonPanel.add(this.allOneButton);
        this.buttonPanel.add(this.allTristateButton);
        this.buttonPanel.add(this.expandButton);
        this.buttonPanel.add(this.invertButton);
        this.buttonPanel.add(this.counterButton);
        this.buttonPanel.add(this.pwrOnResetButton);
        this.buttonPanel.add(this.clockButton);
        this.buttonPanel.add(this.clock2Button);
        this.buttonPanel.add(this.clock4Button);
        this.buttonPanel.add(this.clock8Button);
    }

    void buildCyclePanel() {
        double period = this.stimulus.getPeriod();
        int n_cycles = this.stimulus.getNumberOfCycles();
        this.cycleLengthLabel = new Label("cycle length [sec]:", 2);
        this.cycleLengthTF = new TextField("" + period, 12);
        this.nCyclesLabel = new Label("# cycles:", 2);
        this.nCyclesTF = new TextField("" + n_cycles, 8);
        Panel textPanel = new Panel(new GridLayout(0, 1));
        textPanel.add(this.cycleLengthTF);
        textPanel.add(this.nCyclesTF);
        Panel labelPanel = new Panel(new GridLayout(0, 1));
        labelPanel.add(this.cycleLengthLabel);
        labelPanel.add(this.nCyclesLabel);
        this.cyclePanel = new Panel(new BorderLayout());
        this.cyclePanel.add("West", labelPanel);
        this.cyclePanel.add("Center", textPanel);
    }

    void buildEditorPanel() {
        int vis = 30;
        this.editorCanvas = new StimuliEditorCanvas(this.stimulus, vis);
        this.editorScroller = new Scrollbar(0, 0, vis, 0, 100 + vis);
        this.editorCanvas.setScroller(this.editorScroller);
        this.editorPanel = new Panel(new BorderLayout());
        this.editorPanel.add("Center", this.editorCanvas);
        this.editorPanel.add("South", this.editorScroller);
        this.editorScroller.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                StimuliEditor.dbg("-Scroller- " + e);
                double value = StimuliEditor.this.editorScroller.getValue();
                int cycle = (int)(value * 0.01 * (double)StimuliEditor.this.stimulus.getNumberOfCycles());
                StimuliEditor.this.editorCanvas.moveToCycle(cycle, false);
                StimuliEditor.this.editorCanvas.repaint(100L);
            }
        });
    }

    void buildFilenamePanel() {
        this.filenameTF = new TextField("", 40);
        this.filenameTF.setEditable(false);
        this.filenameTF.setText(this.stimulus.getDataResourceName());
        this.filenamePanel = new Panel(new BorderLayout());
        this.filenamePanel.add("Center", this.filenameTF);
    }

    void buildMenu() {
        this.fileMenu = new Menu("File");
        this.loadMI = new MenuItem("Load...");
        this.saveMI = new MenuItem("Save...");
        this.saveAsMI = new MenuItem("Save as...");
        this.saveVHDLMI = new MenuItem("Save VHDL...");
        this.closeMI = new MenuItem("Close");
        this.fileMenu.add(this.loadMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveMI);
        this.fileMenu.add(this.saveAsMI);
        this.fileMenu.add(this.saveVHDLMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMI);
        this.editMenu = new Menu("Edit");
        this.regionStartMI = new MenuItem("mark region start");
        this.regionEndMI = new MenuItem("mark region end");
        this.regionMoveMI = new MenuItem("move region");
        this.regionCopyMI = new MenuItem("copy region");
        this.regionClearMI = new MenuItem("clear region (0)");
        this.regionSetMI = new MenuItem("set region (1)");
        this.clearAllMI = new MenuItem("clear all");
        this.editMenu.add(this.regionStartMI);
        this.editMenu.add(this.regionEndMI);
        this.editMenu.add("-");
        this.editMenu.add(this.regionClearMI);
        this.editMenu.add(this.regionSetMI);
        this.editMenu.add(this.regionMoveMI);
        this.editMenu.add(this.regionCopyMI);
        this.editMenu.add("-");
        this.editMenu.add(this.clearAllMI);
        this.regionMoveMI.setEnabled(false);
        this.regionCopyMI.setEnabled(false);
        this.helpMenu = new Menu("Help");
        this.helpAboutMI = new MenuItem("About");
        this.helpKeysMI = new MenuItem("Keys+Mouse");
        this.helpMenu.add(this.helpAboutMI);
        this.helpMenu.add(this.helpKeysMI);
        this.menuBar = new MenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.helpMenu);
        this.menuBar.setHelpMenu(this.helpMenu);
    }

    void setupCallbacks() {
        this.loadMI.addActionListener(this);
        this.saveMI.addActionListener(this);
        this.saveAsMI.addActionListener(this);
        this.saveVHDLMI.addActionListener(this);
        this.closeMI.addActionListener(this);
        this.regionStartMI.addActionListener(this);
        this.regionEndMI.addActionListener(this);
        this.regionClearMI.addActionListener(this);
        this.regionSetMI.addActionListener(this);
        this.regionCopyMI.addActionListener(this);
        this.regionMoveMI.addActionListener(this);
        this.clearAllMI.addActionListener(this);
        this.helpAboutMI.addActionListener(this);
        this.helpKeysMI.addActionListener(this);
        this.allUndefinedButton.addActionListener(this);
        this.allTristateButton.addActionListener(this);
        this.allZeroButton.addActionListener(this);
        this.allOneButton.addActionListener(this);
        this.expandButton.addActionListener(this);
        this.invertButton.addActionListener(this);
        this.counterButton.addActionListener(this);
        this.pwrOnResetButton.addActionListener(this);
        this.clockButton.addActionListener(this);
        this.clock2Button.addActionListener(this);
        this.clock4Button.addActionListener(this);
        this.clock8Button.addActionListener(this);
        this.cycleLengthTF.addActionListener(this);
        this.nCyclesTF.addActionListener(this);
        this.setupWindowListener();
    }

    void setupWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                StimuliEditor.this.setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        StimuliEditor.dbg("-D- StimuliEditor.action: " + evt);
        Object src = evt.getSource();
        if (src == this.cycleLengthTF) {
            this.doChangeCyclePeriod();
        } else if (src == this.nCyclesTF) {
            this.doChangeNumberOfCycles();
        } else if (src == this.allZeroButton) {
            this.doInitRowWithZero();
        } else if (src == this.allOneButton) {
            this.doInitRowWithOne();
        } else if (src == this.allUndefinedButton) {
            this.doInitRowWithU();
        } else if (src == this.allTristateButton) {
            this.doInitRowWithZ();
        } else if (src == this.counterButton) {
            this.doInitCounter();
        } else if (src == this.expandButton) {
            this.doExpandRow();
        } else if (src == this.invertButton) {
            this.doInvertRow();
        } else if (src == this.pwrOnResetButton) {
            this.doInitWithPowerOnReset();
        } else if (src == this.clockButton) {
            this.doInitWithClock(1);
        } else if (src == this.clock2Button) {
            this.doInitWithClock(2);
        } else if (src == this.clock4Button) {
            this.doInitWithClock(4);
        } else if (src == this.clock8Button) {
            this.doInitWithClock(8);
        } else if (src == this.loadMI) {
            this.doLoadFile();
        } else if (src == this.saveMI) {
            this.doSaveFile();
        } else if (src == this.saveAsMI) {
            this.doSaveAsFile();
        } else if (src == this.saveVHDLMI) {
            this.doExportVHDLFile();
        } else if (src == this.closeMI) {
            this.doClose();
        } else if (src == this.regionStartMI) {
            this.doMarkRegionStart();
        } else if (src == this.regionEndMI) {
            this.doMarkRegionEnd();
        } else if (src == this.regionMoveMI) {
            this.doMoveRegion();
        } else if (src == this.regionCopyMI) {
            this.doCopyRegion();
        } else if (src == this.regionClearMI) {
            this.doClearRegion();
        } else if (src == this.regionSetMI) {
            this.doSetRegion();
        } else if (src == this.clearAllMI) {
            this.doClearAll();
        } else if (src == this.helpAboutMI) {
            this.doShowHelpAbout();
        } else if (src == this.helpKeysMI) {
            this.doShowHelpKeys();
        } else {
            StimuliEditor.dbg("-W- unknown event source: " + evt);
        }
    }

    void doChangeCyclePeriod() {
        StimuliEditor.dbg("-D- cycleLengthTF action");
        String s = this.cycleLengthTF.getText().trim();
        try {
            double t_cycle = Double.valueOf(s);
            if (t_cycle < 0.0) {
                throw new Exception("Value less than zero!");
            }
            this.stimulus.setPeriod(t_cycle);
        }
        catch (Exception e) {
            StimuliEditor.msg("-E- invalid cycle length: " + e);
        }
    }

    void doChangeNumberOfCycles() {
        StimuliEditor.dbg("-D- nCyclesTF action");
        String s = this.nCyclesTF.getText().trim();
        try {
            int N = Integer.parseInt(s);
            if (N <= 1) {
                throw new Exception("Require >= 1 cycle(s)!");
            }
            this.stimulus.changeLength(N);
            this.editorCanvas.updateLimits();
        }
        catch (Exception e) {
            StimuliEditor.msg("-E- invalid number of cycles: " + e);
        }
    }

    void doInitRowWithZero() {
        this.initRestOfRowWithValue(2);
    }

    void doInitRowWithOne() {
        this.initRestOfRowWithValue(3);
    }

    void doInitRowWithU() {
        this.initRestOfRowWithValue(0);
    }

    void doInitRowWithZ() {
        this.initRestOfRowWithValue(4);
    }

    void initRestOfRowWithValue(int value) {
        int row = this.editorCanvas.getCursorRow();
        int start = this.editorCanvas.getCursorCycle();
        this.stimulus.initRestOfRow(row, start, value);
        this.editorCanvas.repaint();
    }

    void doInitWithClock(int pulsewidth) {
        int row = this.editorCanvas.getCursorRow();
        int start = this.editorCanvas.getCursorCycle();
        int end = this.stimulus.getNumberOfCycles();
        int value0 = 2;
        int value1 = 3;
        int N = 0;
        int value = value0;
        int i = start;
        while (i < end) {
            value = N < pulsewidth ? value0 : value1;
            this.stimulus.setDataAt(row, i, value);
            if (++N >= 2 * pulsewidth) {
                N = 0;
            }
            ++i;
        }
        this.editorCanvas.repaint();
    }

    void doInitCounter() {
        int row = 0;
        while (row < this.stimulus.getNumberOfOutputs()) {
            this.editorCanvas.setCursor(0, row);
            this.doInitWithClock(1 << row);
            ++row;
        }
        this.editorCanvas.repaint();
    }

    void doExpandRow() {
        int row = this.editorCanvas.getCursorRow();
        int start = this.editorCanvas.getCursorCycle();
        int end = this.stimulus.getNumberOfCycles();
        int value = 0;
        int i = start;
        while (i < end) {
            value = this.stimulus.getDataAt(row, i - start);
            this.stimulus.setDataAt(row, i, value);
            ++i;
        }
        this.editorCanvas.repaint();
    }

    void doInvertRow() {
        int row = this.editorCanvas.getCursorRow();
        int start = this.editorCanvas.getCursorCycle();
        int end = this.stimulus.getNumberOfCycles();
        int value = 0;
        int i = start;
        while (i < end) {
            value = this.stimulus.getDataAt(row, i);
            if (value == 2) {
                value = 3;
            } else if (value == 3) {
                value = 2;
            }
            this.stimulus.setDataAt(row, i, value);
            ++i;
        }
        this.editorCanvas.repaint();
    }

    void doInitWithPowerOnReset() {
        int row = this.editorCanvas.getCursorRow();
        int end = this.stimulus.getNumberOfCycles();
        int value = 0;
        int i = 0;
        while (i < end) {
            value = i < 5 ? 1 : (i < 9 ? 2 : 3);
            this.stimulus.setDataAt(row, i, value);
            ++i;
        }
        this.editorCanvas.repaint();
    }

    public void doLoadFile() {
        String filename = this.DM.selectFileOrURLName("Load stimuli...", this.stimulus.getDataResourceName(), ".hst", 0);
        if (filename == null) {
            return;
        }
        try {
            this.stimulus.setDataResourceName(filename);
            this.stimulus.parseData();
            this.cycleLengthTF.setText("" + this.stimulus.getPeriod());
            this.nCyclesTF.setText("" + this.stimulus.getNumberOfCycles());
            this.filenameTF.setText(this.stimulus.getDataResourceName());
            this.editorCanvas.updateLimits();
            this.editorCanvas.repaint();
        }
        catch (Exception e) {
            StimuliEditor.msg("-E- Exception while writing stimulus data: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void doSaveFile() {
        try {
            this.stimulus.writeData();
        }
        catch (Exception e) {
            StimuliEditor.msg("-E- Exception while writing stimulus data: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void doSaveAsFile() {
        String filename = this.DM.selectFileOrURLName("Save stimuli...", this.stimulus.getDataResourceName(), ".hst", 1);
        if (filename == null) {
            return;
        }
        try {
            this.stimulus.setDataResourceName(filename);
            this.stimulus.writeData();
            this.filenameTF.setText(this.stimulus.getDataResourceName());
            StimuliEditor.msg("-I- Wrote Stimuli data to: " + filename);
        }
        catch (Exception e) {
            StimuliEditor.msg("-E- Exception while writing stimulus data: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void doExportVHDLFile() {
        System.err.println("-E- doExportVHDLFile: NOT YET IMPLEMENTED!");
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void doMarkRegionStart() {
        int x = this.editorCanvas.getCursorCycle();
        int y = this.editorCanvas.getCursorRow();
        this.regionStartPoint = new Point(x, y);
        StimuliEditor.msg("-I- doMarkRegionStart: " + this.regionStartPoint);
    }

    public void doMarkRegionEnd() {
        int x = this.editorCanvas.getCursorCycle();
        int y = this.editorCanvas.getCursorRow();
        this.regionEndPoint = new Point(x, y);
        StimuliEditor.msg("-I- doMarkRegionEnd: " + this.regionEndPoint);
    }

    public void doClearRegion() {
        int xmin = Math.min(this.regionStartPoint.x, this.regionEndPoint.x);
        int xmax = Math.max(this.regionStartPoint.x, this.regionEndPoint.x);
        int ymin = Math.min(this.regionStartPoint.y, this.regionEndPoint.y);
        int ymax = Math.max(this.regionStartPoint.y, this.regionEndPoint.y);
        StimuliEditor.msg("-I- doClearRegion: " + this.regionStartPoint + " " + this.regionEndPoint);
        int row = ymin;
        while (row <= ymax) {
            int cycle = xmin;
            while (cycle <= xmax) {
                this.stimulus.setDataAt(row, cycle, 2);
                ++cycle;
            }
            ++row;
        }
        this.editorCanvas.repaint();
    }

    public void doSetRegion() {
        int xmin = Math.min(this.regionStartPoint.x, this.regionEndPoint.x);
        int xmax = Math.max(this.regionStartPoint.x, this.regionEndPoint.x);
        int ymin = Math.min(this.regionStartPoint.y, this.regionEndPoint.y);
        int ymax = Math.max(this.regionStartPoint.y, this.regionEndPoint.y);
        int row = ymin;
        while (row <= ymax) {
            int cycle = xmin;
            while (cycle <= xmax) {
                this.stimulus.setDataAt(row, cycle, 3);
                ++cycle;
            }
            ++row;
        }
        this.editorCanvas.repaint();
    }

    public void doMoveRegion() {
        this.editorCanvas.repaint();
    }

    public void doCopyRegion() {
        this.editorCanvas.repaint();
    }

    public void doClearAll() {
        int rowmax = this.stimulus.getNumberOfOutputs();
        int cyclemax = this.stimulus.getNumberOfCycles();
        int row = 0;
        while (row < rowmax) {
            int cycle = 0;
            while (cycle < cyclemax) {
                this.stimulus.setDataAt(row, cycle, 2);
                ++cycle;
            }
            ++row;
        }
        this.editorCanvas.repaint();
    }

    public void doShowHelpAbout() {
        StimuliEditor.msg("-I- " + this.toString());
    }

    public void doShowHelpKeys() {
        SimpleTextViewer helpViewer = new SimpleTextViewer("StimuliEditor Usage", 25, 65);
        helpViewer.parseResource(helpResourceName);
        helpViewer.setVisible(true);
    }

    public String toString() {
        return versionString;
    }

    public static void dbg(String s) {
        if (debug) {
            System.err.println(s);
        }
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        System.out.println("StimuliEditor selftest...");
        Stimulus ST = new Stimulus();
        StimuliEditor SE = new StimuliEditor(ST);
        SE.pack();
        SE.setVisible(true);
        Stimulus S2 = new Stimulus();
        S2.setDataResourceName("/tmp/s2.hst");
        S2.setNumberOfOutputs(16);
        StimuliEditor E2 = new StimuliEditor(S2);
        E2.pack();
        E2.setVisible(true);
    }
}

