/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class SignalSetValueCommand
extends Command {
    SignalStdLogic1164 target;
    ObjectCanvas canvas;
    int value;

    public SignalSetValueCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.value = 0;
    }

    public void execute() {
        SimKernel simulator = this.editor.getDesign().getSimulator();
        SimEvent ev = new SimEvent(this.target, simulator.getSimTime(), new StdLogic1164(this.value));
        simulator.scheduleInteractiveEvent(ev);
    }

    public void undo() {
        this.message("-I- Cannot undo a manual Signal assignment!");
    }

    public void setValue(int v) {
        this.value = v;
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        FigObject tmp = this.editor.findSymbolOrSignal(WP);
        if (tmp instanceof WireSegment) {
            Signal signal = ((WireSegment)tmp).getSignal();
            if (signal instanceof SignalStdLogic1164) {
                this.target = (SignalStdLogic1164)signal;
                this.execute();
            } else {
                this.message("-E- Not a Signal of type StdLogic1164!");
            }
        } else {
            this.message("-I- Not a Signal!");
        }
        this.ready = true;
    }

    public String toString() {
        return "SignalSetValueCommand, value= " + this.value;
    }

    public String getDescription() {
        return "set signal value";
    }

    static {
        Command.versionString = "HADES SignalSetValueCommand 0.01 (01.06.97)";
    }
}

