/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.utils.EndsWithFilter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FilenameFilter;

public class SelectFileOrURLDialog
extends Dialog
implements ActionListener {
    String filename;
    int mode;
    Frame parent;
    Button cancelButton;
    Button openButton;
    Button chooseFileButton;
    TextField filenameTF;
    Panel filenamePanel;
    Panel buttonPanel;
    FileDialog fileDialog;
    FilenameFilter filenameFilter;

    public SelectFileOrURLDialog(Frame parent) {
        super(parent, "Select file or URL", true);
        this.parent = parent;
        this.filename = "";
        this.mode = 0;
        this.buildGUI();
        this.buildCallbacks();
    }

    public void buildGUI() {
        this.filenameTF = new TextField(this.filename, 40);
        this.chooseFileButton = new Button("Choose File");
        this.filenamePanel = new Panel();
        this.filenamePanel.setLayout(new BorderLayout());
        this.filenamePanel.add("Center", this.filenameTF);
        this.filenamePanel.add("East", this.chooseFileButton);
        this.cancelButton = new Button("Cancel");
        this.openButton = new Button("Open");
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.cancelButton);
        this.setLayout(new BorderLayout());
        this.add("North", this.filenamePanel);
        this.add("South", this.buttonPanel);
        this.pack();
    }

    public void buildCallbacks() {
        this.cancelButton.addActionListener(this);
        this.openButton.addActionListener(this);
        this.chooseFileButton.addActionListener(this);
        this.filenameTF.addActionListener(this);
        this.addWindowListener(new WindowCloser());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cancelButton) {
            this.setFilename(null);
            this.setVisible(false);
        } else if (source == this.openButton) {
            this.setFilename(this.filenameTF.getText());
            this.setVisible(false);
        } else if (source == this.filenameTF) {
            this.setFilename(this.filenameTF.getText());
            this.setVisible(false);
        } else if (source == this.chooseFileButton) {
            this.fileDialog = new FileDialog(this.parent, "Choose a file");
            this.fileDialog.setMode(this.mode);
            if (this.filenameFilter != null) {
                this.fileDialog.setFilenameFilter(this.filenameFilter);
            }
            this.fileDialog.setVisible(true);
            String dir = this.fileDialog.getDirectory();
            String name = this.fileDialog.getFile();
            if (name != null) {
                this.setFilename(dir + name);
            }
        }
    }

    public void setFileDialog(FileDialog fd) {
        this.fileDialog = fd;
    }

    public FileDialog getFileDialog() {
        return this.fileDialog;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String name) {
        this.filename = name;
        this.filenameTF.setText(name);
    }

    public void setFilenameFilter(FilenameFilter ff) {
        this.filenameFilter = ff;
    }

    public void setMode(int loadOrSave) {
        this.mode = loadOrSave;
        if (this.mode == 1) {
            this.openButton.setLabel("Save");
        } else {
            this.openButton.setLabel("Load");
        }
    }

    public void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        Frame ff = new Frame("dummy");
        ff.setSize(new Dimension(100, 100));
        ff.setVisible(true);
        SelectFileOrURLDialog dialog = new SelectFileOrURLDialog(ff);
        dialog.setFilenameFilter(new EndsWithFilter(".hds"));
        dialog.setTitle("Select Hades Design file:");
        dialog.setMode(1);
        dialog.setVisible(true);
        System.out.println(dialog.getFilename());
        System.exit(0);
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent we) {
            SelectFileOrURLDialog.this.setFilename(null);
            SelectFileOrURLDialog.this.setVisible(false);
        }
    }
}

