/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Console;
import hades.gui.MemoryHexEditorField;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.simulator.SimObject;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import jfig.gui.ImageHelper;
import jfig.gui.JTextViewer;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class MemoryEditorFrame
extends JFrame
implements ActionListener,
MemoryListener {
    public static final String versionString = "MemoryEditor 0.31";
    public static final String helpfilename = "/hades/doc/help/MemoryEditorKeyMapping.txt";
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu initMenu;
    private JMenu optionsMenu;
    private JMenu helpMenu;
    private JMenuItem openMI;
    private JMenuItem mergeMI;
    private JMenuItem reloadMI;
    private JMenuItem saveMI;
    private JMenuItem saveAsMI;
    private JMenuItem closeMI;
    private JMenuItem resizeMI;
    private JMenuItem moveBlockMI;
    private JMenuItem searchMI;
    private JMenuItem searchAgainMI;
    private JMenuItem initXXXMI;
    private JMenuItem initZeroMI;
    private JMenuItem initRandomMI;
    private JMenuItem initReloadMI;
    private JMenuItem initLinearMI;
    private JMenuItem initLinear2MI;
    private JMenuItem insertWordMI;
    private JMenuItem removeWordMI;
    private JMenuItem configMI;
    private JMenuItem aboutMI;
    private JMenuItem keysMI;
    private JMenuItem newinitMenu = null;
    private JCheckBoxMenuItem enableToolTipsMI;
    protected String title;
    protected String resourcename;
    private JScrollPane scrollPane;
    private PropertySheet propertySheet;
    private ResizeDialog resizeDialog;
    private MoveBlockDialog moveBlockDialog;
    private ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
    private Console console;
    private Memory memoryObject;
    private int n_words;
    private int n_bits_per_word;
    private int n_visibleRows;
    private int n_words_per_row;
    public MemoryHexEditorField hexEditorField;
    private boolean initialized = false;
    private boolean askOnClose = false;
    private String defaultExtension = ".rom";
    static long[] dummyData;

    public MemoryEditorFrame(Memory memory, int n, int n2, String string) {
        super(string);
        this.title = string;
        this.memoryObject = memory;
        this.n_words = memory.getSize();
        this.n_bits_per_word = memory.getBitsPerWord();
        this.n_visibleRows = n;
        this.n_words_per_row = n2;
    }

    public void disableDefaultScrollPaneKeyBindings(JScrollPane jScrollPane) {
        jScrollPane.setActionMap(null);
    }

    private void buildMemoryHexEditor() {
        this.hexEditorField = this.getDisplayComponent();
        this.toolTipManager.registerComponent(this.hexEditorField);
        this.scrollPane = new JScrollPane(this.hexEditorField);
        this.disableDefaultScrollPaneKeyBindings(this.scrollPane);
        Dimension dimension = this.hexEditorField.getMinimumSize(this.n_visibleRows);
        double d = 5.0;
        try {
            d = this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = (int)((double)dimension.height + d + 3.0);
        int n2 = (int)((double)dimension.width + d + 3.0);
        this.scrollPane.setPreferredSize(new Dimension(n2, n));
        this.getContentPane().add("Center", this.scrollPane);
    }

    protected MemoryHexEditorField getDisplayComponent() {
        if (this.hexEditorField == null) {
            return new MemoryHexEditorField(this.memoryObject, this.n_words_per_row);
        }
        return this.hexEditorField;
    }

    protected void buildMenus() {
        this.fileMenu = new JMenu("File");
        this.openMI = new JMenuItem("Open...");
        this.reloadMI = new JMenuItem("Reload");
        this.mergeMI = new JMenuItem("Merge...");
        this.saveMI = new JMenuItem("Save");
        this.saveAsMI = new JMenuItem("Save as...");
        this.closeMI = new JMenuItem("Close");
        if (this.memoryObject.getResourcename() == null) {
            this.reloadMI.setEnabled(false);
        }
        this.saveMI.setEnabled(false);
        this.reloadMI.setEnabled(false);
        this.fileMenu.add(this.openMI);
        this.fileMenu.add(this.reloadMI);
        this.fileMenu.add(this.mergeMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveMI);
        this.fileMenu.add(this.saveAsMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMI);
        this.editMenu = new JMenu("Edit");
        this.resizeMI = new JMenuItem("Specify memory size...");
        this.searchMI = new JMenuItem("Search...");
        this.searchAgainMI = new JMenuItem("Search again");
        this.moveBlockMI = new JMenuItem("Move memory block...");
        this.insertWordMI = new JMenuItem("Insert word (at cursor)");
        this.removeWordMI = new JMenuItem("Remove word (at cursor)");
        this.resizeMI.setEnabled(this.memoryObject.canChangeSize());
        this.initMenu = new JMenu("Initialize");
        this.initXXXMI = new JMenuItem("unknown (X)");
        this.initZeroMI = new JMenuItem("zero");
        this.initLinearMI = new JMenuItem("linear");
        this.initLinear2MI = new JMenuItem("linear+2");
        this.initRandomMI = new JMenuItem("random");
        this.initReloadMI = new JMenuItem("reload");
        this.initMenu.add(this.initXXXMI);
        this.initMenu.add(this.initZeroMI);
        this.initMenu.add(this.initLinearMI);
        this.initMenu.add(this.initLinear2MI);
        this.initMenu.add(this.initRandomMI);
        this.initMenu.add(this.initReloadMI);
        if (this.memoryObject.getResourcename() == null) {
            this.initReloadMI.setEnabled(false);
        }
        this.searchMI.setEnabled(false);
        this.searchAgainMI.setEnabled(false);
        this.editMenu.add(this.resizeMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.searchMI);
        this.editMenu.add(this.searchAgainMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.initMenu);
        this.editMenu.addSeparator();
        this.editMenu.add(this.insertWordMI);
        this.editMenu.add(this.removeWordMI);
        this.editMenu.add(this.moveBlockMI);
        this.optionsMenu = new JMenu("Options");
        this.configMI = new JMenuItem("Configure...");
        this.enableToolTipsMI = new JCheckBoxMenuItem("Enable Tooltips");
        this.enableToolTipsMI.setState(false);
        this.enableToolTipsMI.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MemoryEditorFrame.this.toolTipManager.setEnabled(MemoryEditorFrame.this.enableToolTipsMI.getState());
            }
        });
        this.optionsMenu.add(this.configMI);
        this.optionsMenu.addSeparator();
        this.optionsMenu.add(this.enableToolTipsMI);
        this.helpMenu = new JMenu("Help");
        this.aboutMI = new JMenuItem("About");
        this.keysMI = new JMenuItem("Key mapping");
        this.helpMenu.add(this.keysMI);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.optionsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void buildMenuShortcuts() {
        this.openMI.setMnemonic(70);
        this.reloadMI.setMnemonic(82);
        this.closeMI.setMnemonic(81);
        this.initXXXMI.setMnemonic(88);
        this.initZeroMI.setMnemonic(48);
        this.configMI.setMnemonic(67);
    }

    private void getIcon() {
        try {
            Image image = ImageHelper.loadResourceImage("/hades/gui/images/iconEditor.gif");
            this.setIconImage(image);
        }
        catch (Exception exception) {
            this.msg("-W- MemoryEditorFrame.getIcon(): " + exception);
            this.msg("... failed to set the editor icon.");
        }
    }

    protected void buildCallbacks() {
        this.openMI.addActionListener(this);
        this.reloadMI.addActionListener(this);
        this.mergeMI.addActionListener(this);
        this.saveMI.addActionListener(this);
        this.saveAsMI.addActionListener(this);
        this.closeMI.addActionListener(this);
        this.resizeMI.addActionListener(this);
        this.moveBlockMI.addActionListener(this);
        this.insertWordMI.addActionListener(this);
        this.removeWordMI.addActionListener(this);
        this.initZeroMI.addActionListener(this);
        this.initXXXMI.addActionListener(this);
        this.initLinearMI.addActionListener(this);
        this.initLinear2MI.addActionListener(this);
        this.initRandomMI.addActionListener(this);
        this.initReloadMI.addActionListener(this);
        this.configMI.addActionListener(this);
        this.aboutMI.addActionListener(this);
        this.keysMI.addActionListener(this);
        this.setDefaultCloseOperation(1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.openMI) {
            this.openFile();
        } else if (object == this.mergeMI) {
            this.mergeFile();
        } else if (object == this.reloadMI) {
            this.reloadMemory();
        } else if (object == this.saveMI) {
            this.saveDataToFile();
        } else if (object == this.saveAsMI) {
            this.saveDataToFileAs();
        } else if (object == this.closeMI) {
            this.setVisible(false);
        } else if (object == this.insertWordMI) {
            this.insertMemoryWordAtCursor();
        } else if (object == this.removeWordMI) {
            this.deleteMemoryWordAtCursor();
        } else if (object == this.resizeMI) {
            this.showResizeDialog();
        } else if (object == this.moveBlockMI) {
            this.showMoveBlockDialog();
        } else if (object == this.initZeroMI) {
            this.initMemoryWithZeroes();
        } else if (object == this.initRandomMI) {
            this.initMemoryWithRandomValues();
        } else if (object == this.initLinearMI) {
            this.initMemoryWithLinearValues();
        } else if (object == this.initLinear2MI) {
            this.initMemoryWithLinear2Values();
        } else if (object == this.initXXXMI) {
            this.initMemoryWithX();
        } else if (object == this.initReloadMI) {
            this.reloadMemory();
        } else if (object == this.configMI) {
            this.showConfigDialog();
        } else if (object == this.aboutMI) {
            this.showAboutMessage();
        } else if (object == this.keysMI) {
            this.showKeyMapping();
        } else {
            this.msg("-E- " + this.toString() + " unknown event source: " + actionEvent);
        }
    }

    private void showConfigDialog() {
        if (this.propertySheet == null) {
            this.propertySheet = this.memoryObject.getConfigDialog();
        }
        if (this.propertySheet == null) {
            this.propertySheet = PropertySheet.getInstanceNamePropertySheet((SimObject)((Object)this.memoryObject));
        }
        this.propertySheet.setVisible(true);
    }

    private void showResizeDialog() {
        if (this.resizeDialog == null) {
            this.resizeDialog = new ResizeDialog(this);
        }
        this.resizeDialog.setVisible(true);
    }

    private void showMoveBlockDialog() {
        if (this.moveBlockDialog == null) {
            this.moveBlockDialog = new MoveBlockDialog(this);
        }
        this.moveBlockDialog.setVisible(true);
    }

    @Override
    public void memoryRead(int n, long l) {
        if (this.hexEditorField != null) {
            this.hexEditorField.setReadHighlightAddress(n);
            if (this.hexEditorField.isShowing()) {
                this.hexEditorField.repaint(100L);
            }
        }
    }

    @Override
    public void memoryWrite(int n, long l, long l2) {
        if (this.hexEditorField != null) {
            this.hexEditorField.setWriteHighlightAddress(n);
            if (this.hexEditorField.isShowing()) {
                this.hexEditorField.repaint(100L);
            }
        }
    }

    private void openFile() {
        this.msg("-I- MEF.openFile...");
        DesignManager designManager = DesignManager.getDesignManager();
        String string = designManager.selectFileOrURLName("Load memory data...", this.getDefaultResourceName(), this.defaultExtension, 0);
        if (string == null) {
            return;
        }
        this.resourcename = string;
        this.memoryObject.setResourcename(this.resourcename);
        this.setTitle(this.title + " - " + this.resourcename);
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = designManager.getInputStream(this, this.resourcename);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.memoryObject.parse(bufferedReader);
            bufferedReader.close();
            inputStream.close();
            this.saveMI.setEnabled(true);
            this.reloadMI.setEnabled(true);
            this.initReloadMI.setEnabled(true);
        }
        catch (Exception exception) {
            this.msg("-F- Internal: " + exception);
            this.msg("    resourcename=" + this.resourcename);
            this.saveMI.setEnabled(false);
        }
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void mergeFile() {
        this.msg("-I- MEF.mergeFile...");
        DesignManager designManager = DesignManager.getDesignManager();
        String string = designManager.selectFileOrURLName("Load memory data...", this.getDefaultResourceName(), this.defaultExtension, 0);
        if (string == null) {
            return;
        }
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = designManager.getInputStream(this, string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.memoryObject.merge(bufferedReader);
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.msg("-F- Internal: " + exception);
            this.msg("    merged file name=" + string);
        }
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void saveDataToFile() {
        String string = this.memoryObject.getResourcename();
        this.msg("-W- saving memory data to :" + string);
        try {
            PrintWriter printWriter = new PrintWriter(DesignManager.getDesignManager().getOutputStream(this, string));
            this.memoryObject.save(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            this.msg("-F- Internal: " + exception);
            this.msg("    resourcename=" + string);
        }
        if (this.hexEditorField != null) {
            this.hexEditorField.setModified(false);
            this.hexEditorField.repaint();
        }
    }

    public void saveDataToFileAs() {
        DesignManager designManager = DesignManager.getDesignManager();
        String string = designManager.selectFileOrURLName("Save memory data...", this.getDefaultResourceName(), this.defaultExtension, 1);
        if (string == null) {
            return;
        }
        this.resourcename = string = designManager.checkAndAddFilenameExtension(string, this.defaultExtension);
        this.msg("-W- saving memory data to :" + this.resourcename);
        try {
            this.memoryObject.setResourcename(this.resourcename);
            PrintWriter printWriter = new PrintWriter(designManager.getOutputStream(this, this.resourcename));
            this.memoryObject.save(printWriter);
            printWriter.flush();
            printWriter.close();
            this.setTitle(this.title + " - " + this.resourcename);
            this.saveMI.setEnabled(true);
            this.reloadMI.setEnabled(true);
            this.initReloadMI.setEnabled(true);
        }
        catch (Exception exception) {
            this.msg("-F- Internal: " + exception);
            this.msg("    resourcename=" + this.resourcename);
            this.saveMI.setEnabled(false);
        }
        if (this.hexEditorField != null) {
            this.hexEditorField.setModified(false);
            this.hexEditorField.repaint();
        }
    }

    private String getDefaultResourceName() {
        String string = this.memoryObject.getResourcename();
        if (string == null) {
            string = "data.rom";
        }
        return string;
    }

    public void insertMemoryWordAtCursor() {
        try {
            int n = this.hexEditorField.getAddrFromCursorPosition();
            int n2 = this.memoryObject.getSize();
            for (int i = n2 - 1; i > n; --i) {
                this.memoryObject.setDataAt(i, this.memoryObject.getDataAt(i - 1));
            }
            this.memoryObject.setDataAt(n, 0L);
            this.hexEditorField.setModified(true);
            this.hexEditorField.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void deleteMemoryWordAtCursor() {
        try {
            int n = this.hexEditorField.getAddrFromCursorPosition();
            int n2 = this.memoryObject.getSize();
            for (int i = n; i < n2 - 1; ++i) {
                this.memoryObject.setDataAt(i, this.memoryObject.getDataAt(i + 1));
            }
            this.memoryObject.setDataAt(n2 - 1, 0L);
            this.hexEditorField.setModified(true);
            this.hexEditorField.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void initMemoryWithZeroes() {
        int n = this.memoryObject.getSize();
        for (int i = 0; i < n; ++i) {
            this.memoryObject.setDataAt(i, 0L);
        }
        this.hexEditorField.setModified(true);
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void initMemoryWithX() {
        int n = this.memoryObject.getSize();
        for (int i = 0; i < n; ++i) {
            this.memoryObject.setDataAt(i, -1L);
        }
        this.hexEditorField.setModified(true);
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void initMemoryWithRandomValues() {
        long l = -1L >>> (int)(64L - (long)this.n_bits_per_word);
        int n = this.memoryObject.getSize();
        for (int i = 0; i < n; ++i) {
            this.memoryObject.setDataAt(i, (long)(Math.random() * (double)l));
        }
        this.hexEditorField.setModified(true);
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void initMemoryWithLinearValues() {
        int n = this.memoryObject.getSize();
        for (int i = 0; i < n; ++i) {
            this.memoryObject.setDataAt(i, i);
        }
        this.hexEditorField.setModified(true);
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void initMemoryWithLinear2Values() {
        int n = this.memoryObject.getSize();
        for (int i = 0; i < n; ++i) {
            this.memoryObject.setDataAt(i, i + 2);
        }
        this.hexEditorField.setModified(true);
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
    }

    private void reloadMemory() {
        this.msg("-I- reloading from " + this.memoryObject.getResourcename() + "...");
        try {
            this.resourcename = this.memoryObject.getResourcename();
            this.memoryObject.parse(new BufferedReader(new InputStreamReader(DesignManager.getDesignManager().getInputStream(this, this.resourcename))));
        }
        catch (Exception exception) {
            this.msg("-F- Internal: " + exception);
            this.msg("    resourcename=" + this.resourcename);
        }
        if (this.hexEditorField != null) {
            this.hexEditorField.repaint();
        }
        this.msg("-I- reload ok.");
    }

    private void showAboutMessage() {
        this.console.println("-I- " + this.toString());
    }

    private void showKeyMapping() {
        JTextViewer jTextViewer = new JTextViewer("MemoryEditor Usage:", 25, 65);
        jTextViewer.parseResource(helpfilename);
        jTextViewer.setVisible(true);
    }

    private void msg(String string) {
        if (this.console == null) {
            this.console = Console.getConsole();
        }
        this.console.message(string);
    }

    @Override
    public String toString() {
        return versionString;
    }

    public static void main(String[] stringArray) {
        SetupManager.loadLocalProperties(".hadesrc");
        dummyData = new long[2048];
        for (int i = 0; i < dummyData.length; ++i) {
            MemoryEditorFrame.dummyData[i] = dummyData.length - i - 1;
        }
        Memory memory = new Memory(){

            @Override
            public int getSize() {
                return dummyData.length;
            }

            @Override
            public void setSize(int n) {
            }

            @Override
            public int getBitsPerWord() {
                return 16;
            }

            @Override
            public void setBitsPerWord(int n) {
            }

            @Override
            public boolean canChangeSize() {
                return false;
            }

            @Override
            public boolean resize(int n, int n2) {
                return false;
            }

            @Override
            public long[] getDataArray() {
                return dummyData;
            }

            @Override
            public void setDataArray(long[] lArray) {
            }

            @Override
            public void setDataAt(int n, long l) {
                MemoryEditorFrame.dummyData[n] = l;
            }

            @Override
            public long getDataAt(int n) {
                return dummyData[n];
            }

            @Override
            public boolean parse(BufferedReader bufferedReader) throws Exception {
                return true;
            }

            @Override
            public boolean merge(BufferedReader bufferedReader) throws Exception {
                return true;
            }

            @Override
            public boolean save(PrintWriter printWriter) throws Exception {
                return true;
            }

            @Override
            public String getResourcename() {
                return "/hades/hugo.rom";
            }

            @Override
            public void setResourcename(String string) {
            }

            @Override
            public void addMemoryListener(MemoryListener memoryListener) {
            }

            @Override
            public void removeMemoryListener(MemoryListener memoryListener) {
            }

            @Override
            public int getAddrOffset() {
                return 0;
            }

            @Override
            public PropertySheet getConfigDialog() {
                return null;
            }
        };
        MemoryEditorFrame memoryEditorFrame = new MemoryEditorFrame(memory, 16, 8, "Victim Cache");
        memoryEditorFrame.pack();
        memoryEditorFrame.setVisible(true);
        memoryEditorFrame.memoryRead(5, 255L);
        memoryEditorFrame.memoryWrite(7, 131L, 132L);
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenuItem getInsertItem() {
        return this.insertWordMI;
    }

    public JMenuItem getRemoveItem() {
        return this.removeWordMI;
    }

    public JMenuItem replaceInitItem() {
        if (this.newinitMenu == null) {
            this.newinitMenu = new JMenuItem("Init (Defaults)");
            this.editMenu.remove(this.initMenu);
            this.editMenu.insert(this.newinitMenu, 5);
        }
        return this.newinitMenu;
    }

    public void disableEditMenuItems() {
        this.resizeMI.setEnabled(false);
        this.searchMI.setEnabled(false);
        this.searchAgainMI.setEnabled(false);
        this.replaceInitItem();
        this.moveBlockMI.setEnabled(false);
    }

    public int getAddr() {
        return this.hexEditorField.getAddrFromCursorPosition();
    }

    @Override
    public void setVisible(boolean bl) {
        int n;
        if (bl && !this.initialized) {
            this.buildMemoryHexEditor();
            this.buildMenus();
            this.buildMenuShortcuts();
            this.buildCallbacks();
            this.getIcon();
            this.pack();
            this.initialized = true;
        }
        super.setVisible(bl);
        this.hexEditorField.requestFocus();
        if (!bl && this.askOnClose && this.hexEditorField.isModified() && (n = JOptionPane.showConfirmDialog(null, new String[]{"Mikroprogramm Speichern?"}, "Vorsicht", 0, 2)) == 0) {
            this.saveDataToFileAs();
        }
    }

    public void setAskBool(boolean bl) {
        this.askOnClose = bl;
    }

    public void setDefaultExtension(String string) {
        this.defaultExtension = string;
    }

    public void setSaveMIEnabled(boolean bl) {
        this.saveMI.setEnabled(bl);
    }

    public void setReloadEnabled(boolean bl) {
        this.reloadMI.setEnabled(bl);
    }

    public void setnewTitle(String string) {
        this.setTitle(this.title + " - " + string);
    }

    class MoveBlockDialog
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        JTextField blockStartTF;
        JTextField blockEndTF;
        JTextField nextStartTF;
        JPanel buttonPanel;
        JPanel resizePanel;

        public MoveBlockDialog(MemoryEditorFrame memoryEditorFrame2) {
            super(memoryEditorFrame2, "Move memory block", true);
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.buttonPanel = new JPanel(new FlowLayout(1));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(new JLabel(""));
            this.buttonPanel.add(this.okButton);
            this.blockStartTF = new JTextField("0x0000", 6);
            this.blockEndTF = new JTextField("0x0100", 6);
            this.nextStartTF = new JTextField("0x1000", 6);
            this.resizePanel = new JPanel(new GridLayout(0, 2));
            this.resizePanel.add(new JLabel("Hex-format addresses:"));
            this.resizePanel.add(new JLabel("[e.g. 0x7ffe]"));
            this.resizePanel.add(new JLabel("block start addr.", 4));
            this.resizePanel.add(this.blockStartTF);
            this.resizePanel.add(new JLabel("block end addr.", 4));
            this.resizePanel.add(this.blockEndTF);
            this.resizePanel.add(new JLabel("new start addr.", 4));
            this.resizePanel.add(this.nextStartTF);
            this.resizePanel.add(new JLabel(""));
            this.resizePanel.add(new JLabel(""));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.resizePanel);
            this.getContentPane().add("South", this.buttonPanel);
            this.pack();
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }

        private int parseValue(String string) {
            try {
                String string2 = string.trim();
                if (string2.startsWith("0x")) {
                    string2 = string2.substring(2);
                }
                return Integer.parseInt(string2, 16);
            }
            catch (Exception exception) {
                return 0;
            }
        }

        private void moveMemoryBlock(int n, int n2, int n3) {
            if (n >= n2) {
                MemoryEditorFrame.this.msg("-E- moveMemoryBlock: start address larger than end address.");
                return;
            }
            try {
                int n4 = n;
                int n5 = n3;
                while (n4 <= n2) {
                    long l = MemoryEditorFrame.this.memoryObject.getDataAt(n4);
                    MemoryEditorFrame.this.memoryObject.setDataAt(n5, l);
                    MemoryEditorFrame.this.hexEditorField.setModified(true);
                    ++n4;
                    ++n5;
                }
            }
            catch (Exception exception) {
                MemoryEditorFrame.this.msg("-E- " + exception);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton) {
                MemoryEditorFrame.this.msg("-#- GM.MVD.OK...");
                try {
                    int n = this.parseValue(this.blockStartTF.getText());
                    int n2 = this.parseValue(this.blockEndTF.getText());
                    int n3 = this.parseValue(this.nextStartTF.getText());
                    System.out.println("GM.MVD: " + n + " " + n2 + " " + n3);
                    this.moveMemoryBlock(n, n2, n3);
                    this.setVisible(false);
                }
                catch (Exception exception) {
                    MemoryEditorFrame.this.msg("-E- GM.MVD.OK: got " + exception);
                    ExceptionTracer.trace(exception);
                }
            } else if (actionEvent.getSource() == this.cancelButton) {
                MemoryEditorFrame.this.msg("-#- GM.MBD.Cancel...");
                this.setVisible(false);
            } else {
                MemoryEditorFrame.this.msg("-E- unknown event source: " + actionEvent);
            }
        }
    }

    class ResizeDialog
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton applyButton;
        JButton cancelButton;
        JTextField nWordsTF;
        JTextField nBitsTF;
        JPanel buttonPanel;
        JPanel resizePanel;

        public ResizeDialog(MemoryEditorFrame memoryEditorFrame2) {
            super(memoryEditorFrame2, "Change memory size", true);
            this.okButton = new JButton("OK");
            this.applyButton = new JButton("Apply");
            this.cancelButton = new JButton("Cancel");
            this.buttonPanel = new JPanel(new FlowLayout(1));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(new JLabel(""));
            this.buttonPanel.add(this.applyButton);
            this.buttonPanel.add(this.okButton);
            this.nWordsTF = new JTextField("" + MemoryEditorFrame.this.memoryObject.getSize(), 10);
            this.nBitsTF = new JTextField("" + MemoryEditorFrame.this.memoryObject.getBitsPerWord(), 10);
            this.resizePanel = new JPanel(new GridLayout(0, 2));
            this.resizePanel.add(new JLabel(""));
            this.resizePanel.add(new JLabel(""));
            this.resizePanel.add(new JLabel("number of words [0..1M]", 4));
            this.resizePanel.add(this.nWordsTF);
            this.resizePanel.add(new JLabel("bits per word [0..63]", 4));
            this.resizePanel.add(this.nBitsTF);
            this.resizePanel.add(new JLabel(""));
            this.resizePanel.add(new JLabel(""));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.resizePanel);
            this.getContentPane().add("South", this.buttonPanel);
            this.pack();
            this.okButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton || actionEvent.getSource() == this.applyButton) {
                MemoryEditorFrame.this.msg("-#- GM.MRD.OK...");
                try {
                    if (!MemoryEditorFrame.this.memoryObject.canChangeSize()) {
                        MemoryEditorFrame.this.msg("-E- Cannot change memory size!");
                        return;
                    }
                    MemoryEditorFrame.this.n_words = Integer.parseInt(this.nWordsTF.getText());
                    MemoryEditorFrame.this.n_bits_per_word = Integer.parseInt(this.nBitsTF.getText());
                    MemoryEditorFrame.this.memoryObject.resize(MemoryEditorFrame.this.n_words, MemoryEditorFrame.this.n_bits_per_word);
                    MemoryEditorFrame.this.hexEditorField.init();
                    MemoryEditorFrame.this.hexEditorField.revalidate();
                    MemoryEditorFrame.this.hexEditorField.repaint();
                    if (actionEvent.getSource() == this.okButton) {
                        this.setVisible(false);
                    }
                }
                catch (Exception exception) {
                    MemoryEditorFrame.this.msg("-E- ResizeDialog.OK: got " + exception);
                    ExceptionTracer.trace(exception);
                }
            } else if (actionEvent.getSource() == this.cancelButton) {
                MemoryEditorFrame.this.msg("-#- GM.MRD.Cancel...");
                this.setVisible(false);
            } else {
                MemoryEditorFrame.this.msg("-E- unknown event source: " + actionEvent);
            }
        }
    }
}

