/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.SelectURLDialog;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JSelectURLDialog
extends JDialog
implements SelectURLDialog,
ActionListener {
    private String urlName = null;
    private int status = 11;
    private JButton cancelButton;
    private JButton openButton;
    private JButton chooseFileButton;
    private JTextField filenameTF;
    private JPanel filenamePanel;
    private JPanel buttonPanel;

    public JSelectURLDialog(Frame parent, String title, String defaultUrlName) {
        super(parent, title, true);
        this.urlName = defaultUrlName;
        this.buildGUI();
        this.buildCallbacks();
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void setUrlName(String s) {
        this.urlName = s;
    }

    public int getStatus() {
        return this.status;
    }

    public Dialog getDialog() {
        return this;
    }

    public void setSelectFileEnabled(boolean b) {
        this.chooseFileButton.setEnabled(b);
    }

    public void buildGUI() {
        this.filenameTF = new JTextField(this.urlName, 40);
        this.chooseFileButton = new JButton("Choose File");
        this.filenamePanel = new JPanel();
        this.filenamePanel.setLayout(new BorderLayout());
        this.filenamePanel.add("Center", this.filenameTF);
        this.filenamePanel.add("East", this.chooseFileButton);
        this.cancelButton = new JButton("Cancel");
        this.openButton = new JButton("Open");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.filenamePanel);
        this.getContentPane().add("South", this.buttonPanel);
        this.pack();
    }

    public void buildCallbacks() {
        this.cancelButton.addActionListener(this);
        this.openButton.addActionListener(this);
        this.chooseFileButton.addActionListener(this);
        this.filenameTF.addActionListener(this);
        this.addWindowListener(new WindowCloser());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cancelButton) {
            this.urlName = null;
            this.status = 11;
            this.setVisible(false);
        } else if (source == this.openButton) {
            this.urlName = this.filenameTF.getText().trim();
            this.status = 13;
            this.setVisible(false);
        } else if (source == this.filenameTF) {
            this.urlName = this.filenameTF.getText().trim();
            this.status = 13;
            this.setVisible(false);
        } else if (source == this.chooseFileButton) {
            this.urlName = null;
            this.status = 15;
            this.setVisible(false);
        } else {
            Thread.dumpStack();
        }
    }

    public static void main(String[] argv) {
        JFrame ff = new JFrame("dummy");
        ff.setSize(new Dimension(100, 100));
        ff.setVisible(true);
        JSelectURLDialog dialog = new JSelectURLDialog((Frame)ff, "Select an URL:", "http://www.sun.com");
        dialog.setVisible(true);
        System.out.println(dialog.getStatus());
        System.out.println(dialog.getUrlName());
        System.exit(0);
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent we) {
            JSelectURLDialog.this.urlName = null;
            JSelectURLDialog.this.status = 11;
            JSelectURLDialog.this.setVisible(false);
        }
    }
}

