/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.PropertySheet;
import hades.gui.WindowCloser;
import hades.models.io.ClockGen;
import hades.simulator.SimObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JPropertySheet
extends PropertySheet
implements ActionListener {
    private SimObject simObject;
    private String[] fields;
    private JDialog dialog;
    private JTextArea helpTextArea;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel labelPanel;
    private JPanel tfPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton updateButton;
    private Color backgroundColor;
    private String[] variableNames;
    private JLabel[] labels;
    private Component[] components;
    private Method[] getters;
    private Method[] setters;
    static String[] dummy = new String[]{"instance name", "name", "preset time:", "t1", "active time:", "t2", "passive time:", "t3"};
    static /* synthetic */ Class class$java$lang$String;

    public JPropertySheet(SimObject obj, Frame frame, String[] _fields) {
        this.dialog = new JDialog(frame, this.buildTitle(obj), false);
        this.simObject = obj;
        this.fields = _fields;
        this.backgroundColor = SetupManager.getColor("Hades.PropertySheet.backgroundColor", new Color(220, 220, 220));
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setSize(200, 200);
        if (PropertySheet.debug) {
            System.out.println("JPropertySheet<init> #1");
        }
        this.buildTopPanel();
        this.buildCenterPanel();
        this.buildButtonPanel();
        if (PropertySheet.debug) {
            System.out.println("JPropertySheet<init> #2");
        }
        this.dialog.getContentPane().add("North", this.topPanel);
        this.dialog.getContentPane().add("Center", this.centerPanel);
        this.dialog.getContentPane().add("South", this.buttonPanel);
        this.dialog.pack();
        if (PropertySheet.debug) {
            System.out.println("JPropertySheet<init> #3");
        }
        this.dialog.addWindowListener(new WindowCloser(this.dialog));
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }

    public void dispose() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void tearDown() {
        System.err.println("AWTPropertySheet.tearDown...");
        this.simObject = null;
        this.fields = null;
        this.helpTextArea = null;
        this.topPanel = null;
        this.centerPanel = null;
        this.labelPanel = null;
        this.tfPanel = null;
        this.buttonPanel = null;
        this.okButton = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.updateButton = null;
        this.variableNames = null;
        this.labels = null;
        this.components = null;
        this.getters = null;
        this.setters = null;
        this.dispose();
        this.dialog = null;
    }

    public void buildTopPanel() {
        this.helpTextArea = new JTextArea(5, 30);
        this.helpTextArea.setFont(new Font("Monospaced", 0, 12));
        this.helpTextArea.setBackground(this.backgroundColor);
        this.helpTextArea.setText("Specify instance properties:");
        this.helpTextArea.setEditable(false);
        JScrollPane helpTextScroller = new JScrollPane(this.helpTextArea);
        this.topPanel = new JPanel();
        this.topPanel.setBorder(new EtchedBorder());
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add("Center", helpTextScroller);
    }

    public void setHelpText(String msg) {
        this.helpTextArea.setText(msg);
        if (msg == "") {
            this.topPanel.setVisible(false);
        } else {
            this.topPanel.setVisible(true);
        }
        this.dialog.invalidate();
        this.dialog.pack();
    }

    public void buildButtonPanel() {
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.cancelButton = new JButton("Cancel");
        this.updateButton = new JButton("Reload");
        this.updateButton.setVisible(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 0));
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.updateButton);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.updateButton.addActionListener(this);
    }

    public void enableUpdateButton(boolean enable) {
        this.updateButton.setVisible(enable);
        this.pack();
    }

    public void buildCenterPanel() {
        int n_rows = 0;
        BeanInfo beanInfo = null;
        if (this.fields == null) {
            try {
                beanInfo = Introspector.getBeanInfo(this.simObject.getClass());
                n_rows = beanInfo.getPropertyDescriptors().length;
            }
            catch (IntrospectionException e) {
                ExceptionTracer.trace(e);
            }
        } else {
            n_rows = this.fields.length / 2;
        }
        if (PropertySheet.debug) {
            System.out.println("PE: n_rows = " + n_rows);
        }
        this.variableNames = new String[n_rows];
        this.labels = new JLabel[n_rows];
        this.components = new Component[n_rows];
        this.getters = new Method[n_rows];
        this.setters = new Method[n_rows];
        this.labelPanel = new JPanel();
        this.labelPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.labelPanel.setLayout(new GridLayout(n_rows, 1, 2, 2));
        this.tfPanel = new JPanel();
        this.tfPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tfPanel.setLayout(new GridLayout(n_rows, 1, 2, 2));
        this.centerPanel = new JPanel();
        this.centerPanel.setBackground(this.backgroundColor);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add("West", this.labelPanel);
        this.centerPanel.add("Center", this.tfPanel);
        int i = 0;
        while (i < this.variableNames.length) {
            if (beanInfo != null) {
                PropertyDescriptor[] desc = beanInfo.getPropertyDescriptors();
                this.addRow(i, desc[i]);
            } else {
                this.addRow(i, this.fields[2 * i], this.fields[2 * i + 1]);
            }
            ++i;
        }
    }

    private void addRow(int i, PropertyDescriptor desc) {
        JComponent editorComponent = new JTextField();
        String value = null;
        this.variableNames[i] = desc.getName();
        this.getters[i] = desc.getReadMethod();
        this.setters[i] = desc.getWriteMethod();
        try {
            PropertyEditor editor;
            if (desc.getPropertyEditorClass() != null && (editor = (PropertyEditor)desc.getPropertyEditorClass().newInstance()).getTags() != null) {
                editorComponent = new JComboBox<String>(editor.getTags());
            }
            value = (String)this.getters[i].invoke((Object)this.simObject, new Object[0]);
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        if (editorComponent instanceof JComboBox) {
            ((JComboBox)editorComponent).setSelectedItem(value);
        } else {
            editorComponent.setText(value);
        }
        this.labels[i] = new JLabel(desc.getDisplayName(), 4);
        this.components[i] = editorComponent;
        this.addComponents(i);
    }

    public void addRow(int i, String label, String fieldname) {
        if (PropertySheet.debug) {
            System.out.println("PE.addRow(" + i + " " + label + "," + fieldname + ")");
        }
        try {
            this.variableNames[i] = fieldname;
            Object[] noArgs = new Class[]{};
            this.getters[i] = this.simObject.getClass().getMethod("get" + this.capitalize(fieldname), (Class<?>[])noArgs);
            Class[] oneStringArg = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JPropertySheet.class$("java.lang.String")) : class$java$lang$String};
            this.setters[i] = this.simObject.getClass().getMethod("set" + this.capitalize(fieldname), oneStringArg);
            String value = "" + this.getters[i].invoke((Object)this.simObject, noArgs);
            if (PropertySheet.debug) {
                System.out.println("PE.addRow(" + this.getters[i] + " " + this.setters[i] + " value is " + value);
            }
            this.labels[i] = new JLabel(label, 4);
            this.components[i] = new JTextField(value, 10);
            this.addComponents(i);
        }
        catch (InvocationTargetException ite) {
            Throwable original = ite.getTargetException();
            if (PropertySheet.debug) {
                PropertySheet.msg("-E- JPropertySheet.addRow: " + original);
            }
            ExceptionTracer.trace(original);
        }
        catch (Exception e) {
            if (PropertySheet.debug) {
                PropertySheet.msg("-E- JPropertySheet.addRow(): " + e);
            }
            ExceptionTracer.trace(e);
        }
    }

    private void addComponents(int i) {
        this.labels[i].setBackground(this.backgroundColor);
        this.components[i].setBackground(this.backgroundColor);
        this.labelPanel.add(this.labels[i]);
        this.tfPanel.add(this.components[i]);
    }

    public void applyValues() {
        int i = 0;
        while (i < this.variableNames.length) {
            try {
                String tmp = this.components[i] instanceof JComboBox ? (String)((JComboBox)this.components[i]).getSelectedItem() : ((JTextField)this.components[i]).getText();
                Object[] args = new String[]{tmp};
                this.setters[i].invoke((Object)this.simObject, args);
            }
            catch (InvocationTargetException ite) {
                Throwable original = ite.getTargetException();
                PropertySheet.msg("-E- JPropertySheet.applyValues: " + original);
                ExceptionTracer.trace(original);
            }
            catch (Exception e) {
                PropertySheet.msg("-E- JPropertySheet.applyValues(): caught " + e);
                ExceptionTracer.trace(e);
            }
            ++i;
        }
        try {
            Method method = this.simObject.getClass().getMethod("applyValuesHook", new Class[0]);
            method.invoke((Object)this.simObject, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.simObject.getEditor().doFullRedraw();
        }
        catch (Exception e) {}
    }

    public void updateValues() {
        int i = 0;
        while (i < this.getters.length) {
            Object[] noArgs = new Class[]{};
            String value = null;
            try {
                value = (String)this.getters[i].invoke((Object)this.simObject, noArgs);
            }
            catch (InvocationTargetException ite) {
                Throwable original = ite.getTargetException();
                PropertySheet.msg("-E- JPropertySheet.updateValues: " + original);
                ExceptionTracer.trace(original);
            }
            catch (Exception e) {
                PropertySheet.msg("-E- JPropertySheet.updateValues(): " + e);
                ExceptionTracer.trace(e);
            }
            if (this.components[i] instanceof JComboBox) {
                ((JComboBox)this.components[i]).setSelectedItem(value);
            } else {
                ((JTextField)this.components[i]).setText(value);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source;
        if (PropertySheet.debug) {
            System.out.println("PE.actionPerformed(): " + evt);
        }
        if ((source = evt.getSource()) == this.cancelButton) {
            this.hideWindow();
        } else if (source == this.applyButton) {
            this.applyValues();
        } else if (source == this.okButton) {
            this.applyValues();
            this.hideWindow();
        } else if (source == this.updateButton) {
            this.updateValues();
        } else if (source instanceof Component) {
            this.applyValues();
        } else {
            System.out.println("PE: unknown event source for: " + evt);
        }
    }

    public void hideWindow() {
        this.setVisible(false);
        try {
            this.simObject.getEditor().doFullRedraw();
        }
        catch (Exception e) {
            // empty catch block
        }
        PropertySheet._objectTable.remove(this.simObject);
    }

    public String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (s.length() > 1) {
            return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
        }
        return "we never arrive here, but the Java compiler sucks";
    }

    public static void main(String[] argv) {
        System.out.println("JPropertySheet main(): self test started...");
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        Frame frame = new Frame("JPropertySheet test");
        frame.setSize(new Dimension(100, 100));
        frame.setVisible(true);
        String[] fields = new String[]{"name:", "name", "period [sec]:", "period", "frac. [0..1]:", "dutycycle", "offset [sec]:", "offset"};
        PropertySheet ps = PropertySheet.getPropertySheet(new ClockGen(), frame, fields);
        ps.setHelpText("ClockGenerator timing parameters:   \n_____11111__________11111_______ ...\n0         1              2          \n| t0 | t1 | t0 | t1 | ...           \n");
        ps.enableUpdateButton(true);
        ps.pack();
        ps.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

