/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.JMultiLineToolTip;
import hades.gui.ObjectCanvas;
import hades.gui.SyncRedrawTimer;
import hades.gui.Trafo2D;
import hades.manager.DesignManager;
import hades.utils.ContextToolTip;
import hades.utils.NameMangler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigSwingCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ImageHelper;
import jfig.objects.FigBbox;
import jfig.utils.SetupManager;

public class JObjectCanvas
extends FigSwingCanvas
implements ObjectCanvas {
    static final String versionString = "HADES JObjectCanvas 0.1 (29.10.02)";
    private boolean enablePopup;
    private boolean enablePopupOnNextMouseRelease;
    private JPopupMenu popup;
    private Point popupPosition;
    private Point popupPositionWC;
    private Hashtable menuTable = new Hashtable();
    private boolean toolTipsEnabledFlag;
    private Editor editor;
    public static final int MAX_REPAINT_INDEX = 100;
    private FigDrawable[] repaintArray;
    private int repaintIndex;
    private boolean repaintOverflow;
    private SyncRedrawTimer syncRedrawTimer;
    private int n_syncrepaints = 0;
    private ContextToolTip contextToolTipProvider = null;
    private String contextToolTipText = "no help yet";
    protected int n_repaintTables = 0;
    protected int n_repaintTableEntries = 0;
    protected int n_repaintOverflows = 0;

    public JObjectCanvas(Editor _editor) {
        this.editor = _editor;
        this.setTrafo(new Trafo2D());
        if (SetupManager.getBoolean("Hades.Editor.ViewMode", false)) {
            this.showRulers(false);
            this.setGrid(0);
        }
        this.repaintArray = new FigDrawable[100];
        this.repaintIndex = 0;
        this.repaintOverflow = false;
        this.syncRedrawTimer = new SyncRedrawTimer(this);
        this.syncRedrawTimer.start();
        this.createPopup();
        this.enablePopupOnNextMouseRelease = false;
        this.setEnablePopup(true);
        this.setToolTipsEnabled(SetupManager.getBoolean("Hades.Editor.EnableToolTips", true));
    }

    public void createCustomNullCursor() {
        Cursor tmp;
        block4: {
            tmp = new Cursor(0);
            try {
                Image image = ImageHelper.createImage(1, 1);
                Graphics g = image.getGraphics();
                g.setColor(new Color(255, 255, 255, 255));
                g.fillRect(0, 0, 8, 8);
                g.setColor(new Color(255, 255, 0, 0));
                g.fillRect(0, 0, 8, 8);
                tmp = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "noCursor");
                if (this.debug) {
                    this.msg("-#- got a transparent default cursor: " + tmp);
                }
            }
            catch (Throwable t) {
                if (this.debug) {
                    this.msg("-E- JObjectCanvas.createCustomNullCursor: " + t);
                }
                if (!this.debug) break block4;
                this.msg("... using system default cursor instead.");
            }
        }
        this.defaultCursor = tmp;
        this.setCursor(this.defaultCursor);
    }

    public void setCursor(Cursor c) {
        super.setCursor(c);
        if (this.debug) {
            this.msg("-#- JObjectCanvas.setCursor: " + c);
            Thread.dumpStack();
        }
    }

    public SyncRedrawTimer getSyncRedrawTimer() {
        return this.syncRedrawTimer;
    }

    public JToolTip createToolTip() {
        if (this.contextToolTipText == null || "".equals(this.contextToolTipText)) {
            JToolTip jtt = new JToolTip();
            return jtt;
        }
        return new JMultiLineToolTip(this.contextToolTipText);
    }

    public Point getToolTipLocation(MouseEvent evt) {
        Point p = new Point(evt.getX() + 10, evt.getY() + 20);
        return p;
    }

    public String getToolTipText(MouseEvent evt) {
        Point p = new Point(evt.getX(), evt.getY());
        if (!this.toolTipsEnabledFlag) {
            this.contextToolTipText = null;
        } else if (this.contextToolTipProvider != null) {
            String s = this.contextToolTipProvider.getToolTip(p, 100L);
            if (s == null) {
                s = "";
            }
            this.contextToolTipText = s;
        } else {
            this.contextToolTipText = "no object here";
        }
        return this.contextToolTipText;
    }

    public void setContextToolTipProvider(ContextToolTip provider) {
        this.contextToolTipProvider = provider;
    }

    public boolean isToolTipsEnabled() {
        return this.toolTipsEnabledFlag;
    }

    public void setToolTipsEnabled(boolean b) {
        this.toolTipsEnabledFlag = b;
        this.setToolTipText(b ? "enabled" : null);
    }

    public void setRulerOffsets() {
        if (this.hasRulers) {
            this.BASE_ANCHOR_X = 781;
            this.BASE_ANCHOR_Y = -781;
            this.RULER_XL_OFFSET = 26;
            this.RULER_YT_OFFSET = 26;
            this.RULER_XR_OFFSET = 0;
            this.RULER_YB_OFFSET = 0;
        } else {
            this.BASE_ANCHOR_X = 0;
            this.BASE_ANCHOR_Y = 0;
            this.RULER_XL_OFFSET = 0;
            this.RULER_YT_OFFSET = 0;
            this.RULER_XR_OFFSET = 0;
            this.RULER_YB_OFFSET = 0;
        }
    }

    public boolean isRightYRuler() {
        return false;
    }

    public void drawRulers(Graphics g) {
        int y;
        String s;
        int x;
        double fzoom;
        double d_tic;
        double d_label;
        if (!this.hasRulers) {
            return;
        }
        if (this.debug) {
            this.msg("-#- FigCanvas.drawRulers...");
        }
        if (this.trafo.get_units() == 2) {
            d_label = 2400.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d_tic = 240.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            fzoom = 4.166666666666667E-4;
        } else if (this.trafo.get_units() == 1) {
            d_label = 1920.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d_tic = 192.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            fzoom = 0.0010416666666666667;
        } else {
            d_label = 1800.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d_tic = 180.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            fzoom = 0.0011111111111111111;
        }
        double d_label2 = 0.5 * d_label;
        int i_label = (int)d_label;
        int wxmin = this.trafo.getAnchor().x;
        int wymin = this.trafo.getAnchor().y;
        Point wp = this.getViewportWCmax();
        int wxmax = wp.x;
        int wymax = wp.y;
        int xmax = this.cur_width;
        int ymax = this.cur_height;
        wxmin = wxmin - wxmin % i_label - i_label;
        wxmax = wxmax - wxmax % i_label + i_label;
        wymin = wymin - wymin % i_label - i_label;
        wymax = wymax - wymax % i_label + i_label;
        if (this.debug) {
            this.msg("-#- drawRulers() wxmin " + wxmin + " wxmax " + wxmax + " d_label " + d_label + " wymin " + wymin + " wymax " + wymax);
        }
        int wxcenter = (wxmin + wxmax) / 2;
        int wycenter = (wymin + wymax) / 2;
        wxcenter = (int)(Math.floor((double)wxcenter / d_label) * d_label);
        wycenter = (int)(Math.floor((double)wycenter / d_label) * d_label);
        g.setPaintMode();
        g.setColor(this.gridColor);
        g.drawLine(0, 25, xmax, 25);
        g.drawLine(25, 0, 25, ymax);
        g.setColor(this.gridColor);
        double wx = wxcenter;
        while (wx < (double)wxmax) {
            x = this.trafo.wc_to_screen_x((int)wx);
            g.drawLine(x, 21, x, 25);
            wx += d_tic;
        }
        double wx2 = wxcenter;
        while (wx2 < (double)wxmax) {
            x = this.trafo.wc_to_screen_x((int)wx2);
            g.drawLine(x, 18, x, 25);
            wx2 += d_label2;
        }
        double wx3 = wxcenter;
        while (wx3 > (double)wxmin) {
            x = this.trafo.wc_to_screen_x((int)wx3);
            g.drawLine(x, 21, x, 25);
            wx3 -= d_tic;
        }
        double wx4 = wxcenter;
        while (wx4 > (double)wxmin) {
            x = this.trafo.wc_to_screen_x((int)wx4);
            g.drawLine(x, 18, x, 25);
            wx4 -= d_label2;
        }
        g.setFont(FigSwingCanvas.rulerFont);
        double wx5 = wxcenter;
        while (wx5 < (double)wxmax) {
            x = this.trafo.wc_to_screen_x((int)wx5);
            g.drawLine(x, 12, x, 25);
            s = Double.toString(Math.floor(wx5 * fzoom * 1024.0 + 0.5) / 1024.0);
            g.drawString(s, x + 4, 16);
            wx5 += d_label;
        }
        double wx6 = wxcenter;
        while (wx6 > (double)wxmin) {
            x = this.trafo.wc_to_screen_x((int)wx6);
            g.drawLine(x, 12, x, 25);
            s = Double.toString(Math.floor(wx6 * fzoom * 1024.0 + 0.5) / 1024.0);
            g.drawString(s, x + 4, 16);
            wx6 -= d_label;
        }
        xmax = 25;
        double wy = wycenter;
        while (wy < (double)wymax) {
            y = this.trafo.wc_to_screen_y((int)wy);
            g.drawLine(25, y, 21, y);
            wy += d_tic;
        }
        double wy2 = wycenter;
        while (wy2 < (double)wymax) {
            y = this.trafo.wc_to_screen_y((int)wy2);
            g.drawLine(25, y, 18, y);
            wy2 += d_label2;
        }
        double wy3 = wycenter;
        while (wy3 < (double)wymax) {
            y = this.trafo.wc_to_screen_y((int)wy3);
            g.drawLine(25, y, 12, y);
            s = Double.toString(Math.floor(wy3 * fzoom * 1024.0 + 0.5) / 1024.0);
            g.drawString(s, 4, y - 3);
            wy3 += d_label;
        }
        double wy4 = wycenter;
        while (wy4 > (double)wymin) {
            y = this.trafo.wc_to_screen_y((int)wy4);
            g.drawLine(25, y, 21, y);
            wy4 -= d_tic;
        }
        double wy5 = wycenter;
        while (wy5 > (double)wymin) {
            y = this.trafo.wc_to_screen_y((int)wy5);
            g.drawLine(25, y, 18, y);
            wy5 -= d_label2;
        }
        double wy6 = wycenter;
        while (wy6 > (double)wymin) {
            y = this.trafo.wc_to_screen_y((int)wy6);
            g.drawLine(25, y, 12, y);
            s = Double.toString(Math.floor(wy6 * fzoom * 1024.0 + 0.5) / 1024.0);
            g.drawString(s, 4, y - 3);
            wy6 -= d_label;
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, 25, 25);
        g.setColor(this.gridColor);
        g.setFont(FigSwingCanvas.rulerFont);
        g.drawString(this.trafo.get_units_string(), 4, 16);
        g.setColor(this.defaultColor);
    }

    public void paintNoChanges(Graphics g) {
        this.blitOffscreenBuffer(g);
        this.drawTmpObjects(g);
        g.setColor(Color.black);
        if (this.hasRulers) {
            g.drawLine(this.cur_x, 5, this.cur_x, 0);
            g.drawLine(0, this.cur_y, 5, this.cur_y);
        }
        this.rubberband.paintOnce(g, this.cur_x, this.cur_y);
        g.drawLine(this.cur_x - 3, this.cur_y, this.cur_x + 3, this.cur_y);
        g.drawLine(this.cur_x, this.cur_y - 3, this.cur_x, this.cur_y + 3);
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        if (this.debug) {
            this.msg("-Q- popup isLWPE: " + this.popup.isLightWeightPopupEnabled());
        }
        this.menuTable.put("popup", this.popup);
        try {
            String defaultMenuResource = this.editor.isViewMode() ? "/hades/gui/ViewModePopupMenu.txt" : "/hades/gui/PopupMenu.txt";
            String menuResourceName = SetupManager.getProperty("Hades.Editor.PopupMenuResource", defaultMenuResource);
            BufferedReader BR = new BufferedReader(new InputStreamReader(DesignManager.getDesignManager().getInputStream(null, menuResourceName)));
            String line = null;
            String menuname = null;
            String parentname = null;
            StringTokenizer st = null;
            JMenu menu = null;
            while ((line = BR.readLine()) != null) {
                try {
                    st = new StringTokenizer(line, " \t");
                    String opcode = st.nextToken();
                    if (line.startsWith("#")) continue;
                    if ("Menu".equals(opcode)) {
                        menuname = this.getToken(st);
                        menu = new JMenu(menuname);
                        this.menuTable.put(menuname, menu);
                        this.popup.add(menu);
                        continue;
                    }
                    if ("SubMenu".equals(opcode)) {
                        parentname = this.getToken(st);
                        menuname = this.getToken(st);
                        menu = new JMenu(menuname);
                        this.menuTable.put(menuname, menu);
                        this.createPopupSubMenu(parentname, menu);
                        continue;
                    }
                    if ("MenuSeparator".equals(opcode)) {
                        parentname = this.getToken(st);
                        this.createPopupSeparator(parentname);
                        continue;
                    }
                    if ("MenuItem".equals(opcode)) {
                        parentname = this.getToken(st);
                        String itemname = this.getToken(st);
                        String callback = this.getToken(st);
                        String argument = this.getToken(st);
                        JMenuItem item = new JMenuItem(itemname);
                        if (this.editor != null) {
                            item.addActionListener(this.editor);
                            this.editor.addCallback(itemname, callback, argument);
                        }
                        this.createPopupMenuItem(parentname, item);
                        continue;
                    }
                    System.err.println("-W- ignoring popup menu entry ': " + line + "'");
                }
                catch (Exception e) {
                    System.err.println("-E- invalid popup menu entry: '" + line + "'");
                    e.printStackTrace();
                }
            }
            BR.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.popupPosition = new Point(-1, -1);
        this.popupPositionWC = new Point(-1, -1);
        this.add(this.popup);
    }

    public String getToken(StringTokenizer st) throws Exception {
        return NameMangler.decodeUnicodeEscapes(st.nextToken());
    }

    private void createPopupSubMenu(String parentname, JMenu menu) {
        Object parent = this.menuTable.get(parentname);
        if (parent == null) {
            this.popup.add(menu);
            return;
        }
        if (parent instanceof JMenu) {
            ((JMenu)parent).add(menu);
            return;
        }
        if (parent instanceof JPopupMenu) {
            ((JPopupMenu)parent).add(menu);
            return;
        }
    }

    private void createPopupSeparator(String parentname) {
        Object parent = this.menuTable.get(parentname);
        if (parent == null) {
            this.popup.addSeparator();
            return;
        }
        if (parent instanceof JMenu) {
            ((JMenu)parent).addSeparator();
            return;
        }
        if (parent instanceof JPopupMenu) {
            ((JPopupMenu)parent).addSeparator();
            return;
        }
    }

    private void createPopupMenuItem(String parentname, JMenuItem item) {
        Object parent = this.menuTable.get(parentname);
        if (parent == null) {
            this.popup.add(item);
            return;
        }
        if (parent instanceof JMenu) {
            ((JMenu)parent).add(item);
            return;
        }
        if (parent instanceof JPopupMenu) {
            ((JPopupMenu)parent).add(item);
            return;
        }
    }

    public void createMenuShortcuts() {
    }

    public boolean isPopupShowing() {
        return this.popup.isVisible();
    }

    public Point getPopupPosition() {
        return this.popupPosition;
    }

    public Point getPopupPositionWC() {
        return this.popupPositionWC;
    }

    public Point getPopupPositionWCsnapped() {
        Point wp = new Point(0, 0);
        wp = this.getTrafo().screen_to_wc_snapped(this.popupPosition, wp);
        return wp;
    }

    public void setPopupPosition(Point sp, Point wp) {
        this.popupPosition = new Point(sp);
        this.popupPositionWC = new Point(wp);
    }

    public void setEnablePopup(boolean b) {
        this.enablePopup = b;
    }

    public boolean getEnablePopup() {
        return this.enablePopup;
    }

    public void setEnablePopupOnNextMouseRelease() {
        this.enablePopupOnNextMouseRelease = true;
    }

    public void mouseMoved(MouseEvent mme) {
        super.mouseMoved(mme);
    }

    public void mouseDragged(MouseEvent mme) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.debug) {
            this.msg("-Q- JObjectCanvas.mousePressed: " + e);
        }
        this.requestFocus();
        this.getCurrentCanvasSize();
        if (this.enablePopup && e.isPopupTrigger()) {
            this.popupPosition = new Point(e.getX(), e.getY());
            this.popupPositionWC = this.getTrafo().screen_to_wc_snapped(this.popupPosition, new Point(0, 0));
            this.writeLogShowPopupPosition();
            this.popup.show(this, e.getX(), e.getY());
        } else if (this.canvasListener != null) {
            this.ptmp = this.trafo.screen_to_wc_snapped(e.getX(), e.getY(), this.ptmp);
            this.tmp_sc = this.trafo.wc_to_screen(this.ptmp, this.tmp_sc);
            Point WP = new Point(this.ptmp);
            Point SP = new Point(this.tmp_sc);
            FigCanvasEvent fce = new FigCanvasEvent(e, SP, WP);
            this.writeLogMousePressed(fce);
            this.canvasListener.mousePressed(fce);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.enablePopupOnNextMouseRelease) {
            this.enablePopup = true;
            this.enablePopupOnNextMouseRelease = false;
            this.writeLogMouseReleased(e);
        } else if (this.enablePopup && e.isPopupTrigger()) {
            this.popupPosition = new Point(e.getX(), e.getY());
            this.popupPositionWC = this.getTrafo().screen_to_wc_snapped(this.popupPosition, new Point(0, 0));
            this.writeLogShowPopupPosition();
            this.popup.show(this, e.getX(), e.getY());
        } else {
            this.writeLogMouseReleased(e);
        }
    }

    private void writeLogShowPopupPosition() {
        if (this.editor == null) {
            return;
        }
        if (this.editor.getLogManager() == null) {
            return;
        }
        try {
            this.editor.getLogManager().writeShowPopupPosition(this.popupPosition, this.popupPositionWC);
        }
        catch (Throwable t) {}
    }

    private void writeLogMousePressed(FigCanvasEvent fce) {
        if (this.editor == null) {
            return;
        }
        if (this.editor.getLogManager() == null) {
            return;
        }
        try {
            this.editor.getLogManager().writeMousePressed(fce);
        }
        catch (Throwable t) {}
    }

    private void writeLogMouseReleased(MouseEvent e) {
        if (this.editor == null) {
            return;
        }
        if (this.editor.getLogManager() == null) {
            return;
        }
        try {
            this.editor.getLogManager().writeMouseReleased(e);
        }
        catch (Throwable t) {}
    }

    public synchronized void doPanning(int direction, boolean shift) {
        this.getCurrentCanvasSize();
        Point tmp_sc = new Point();
        Point tmp_wc = new Point();
        tmp_sc.x = this.cur_width;
        tmp_sc.y = this.cur_height;
        tmp_wc = this.trafo.screen_to_wc(tmp_sc, tmp_wc);
        Point anchor = this.trafo.getAnchor();
        if (this.debug) {
            this.msg("-#- JObjectCanvas.doPanning: anchor=" + anchor);
        }
        double w = shift ? 0.5 : 0.04;
        int dx = (int)((double)(tmp_wc.x - anchor.x) * w);
        int dy = (int)((double)(tmp_wc.y - anchor.y) * w);
        switch (direction) {
            case 0: {
                anchor.x = this.BASE_ANCHOR_X;
                anchor.y = this.BASE_ANCHOR_Y;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 2: {
                anchor.x += dx;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 1: {
                anchor.x -= dx;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 4: {
                anchor.y += dy;
                this.trafo.setAnchor(anchor);
                break;
            }
            case 3: {
                anchor.y -= dy;
                this.trafo.setAnchor(anchor);
                break;
            }
            default: {
                this.msg("-E- JObjectCanvas.doPanning: unknown direction " + direction);
            }
        }
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public void doZoomFit() {
        if (this.debug) {
            this.msg("-#- JObjectCanvas.doZoomFit: ");
            this.msg("    bounds = " + this.getBounds());
            this.msg("    bbox = " + this.editor.getDesignBoundingBox());
        }
        super.doZoomFit();
    }

    public synchronized void doZoomIn14() {
        if (this.debug) {
            this.msg("JObjectCanvas.doZoomIn14()");
        }
        if (this.trafo.getZoomFactor() >= this.trafo.getMaxZoomFactor()) {
            this.msg("already at maximum zoom factor...");
        } else {
            double f_zoom = this.trafo.getZoomFactor();
            if (this.debug) {
                System.out.println("zoom factor is=" + f_zoom);
            }
            this.setCursor(this.waitCursor);
            Rectangle r = this.getBounds();
            Point s_bottomright = new Point(r.width, r.height);
            Point w_bottomright = new Point(0, 0);
            w_bottomright = this.trafo.screen_to_wc(s_bottomright, w_bottomright);
            Point w_anchor = this.trafo.getAnchor();
            int w_dx = w_bottomright.x - w_anchor.x;
            int w_dy = w_bottomright.y - w_anchor.y;
            this.trafo.set_zoom_region(w_anchor.x + (int)(0.14645 * (double)w_dx), w_anchor.y + (int)(0.14645 * (double)w_dy), w_anchor.x + (int)(0.85355 * (double)w_dx), w_anchor.y + (int)(0.85355 * (double)w_dy), r.width, r.height);
            this.doFullRedraw();
            this.setCursor(this.defaultCursor);
            this.notifyZoomListeners();
        }
    }

    public synchronized void doZoomOut07() {
        if (this.debug) {
            this.msg("JObjectCanvas.doZoomOut07()");
        }
        if (this.trafo.getZoomFactor() <= this.trafo.getMinZoomFactor()) {
            this.msg("already at minimum zoom factor...");
        } else {
            double f_zoom = this.trafo.getZoomFactor();
            if (this.debug) {
                System.out.println("zoom factor is=" + f_zoom);
            }
            this.setCursor(this.waitCursor);
            Rectangle r = this.getBounds();
            Point s_bottomright = new Point(r.width, r.height);
            Point w_bottomright = new Point(0, 0);
            w_bottomright = this.trafo.screen_to_wc(s_bottomright, w_bottomright);
            Point w_anchor = this.trafo.getAnchor();
            int w_dx = w_bottomright.x - w_anchor.x;
            int w_dy = w_bottomright.y - w_anchor.y;
            this.trafo.set_zoom_region(w_anchor.x - (int)(0.2071 * (double)w_dx), w_anchor.y - (int)(0.2071 * (double)w_dy), w_anchor.x + (int)(1.2071 * (double)w_dx), w_anchor.y + (int)(1.2071 * (double)w_dy), r.width, r.height);
            this.doFullRedraw();
            this.setCursor(this.defaultCursor);
            this.notifyZoomListeners();
        }
    }

    public synchronized void doZoomRegionBroken(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- JObjectCanvas.doZoomRegion: " + bbox);
        }
        int xl = bbox.getXl();
        int xr = bbox.getXr();
        int yt = bbox.getYt();
        int yb = bbox.getYb();
        int wc_ruler_width = this.getTrafo().screen_to_wc(25);
        Rectangle r = this.getBounds();
        this.setCursor(this.waitCursor);
        this.trafo.set_zoom_region(xl -= 2 * wc_ruler_width, yt -= 2 * wc_ruler_width, xr += 1 * wc_ruler_width, yb += 1 * wc_ruler_width, r.width, r.height);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public synchronized void doZoomRegion(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- JObjectCanvas.doZoomRegion: " + bbox);
        }
        int border = 10;
        Rectangle r = this.getBounds();
        this.setCursor(this.waitCursor);
        ((Trafo2D)this.trafo).set_zoom_region_unconstrained(bbox.getXl(), bbox.getYt(), bbox.getXr(), bbox.getYb(), r.width, r.height, border);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public synchronized void doZoomLandscapeA4(FigBbox bbox) {
        if (this.debug) {
            this.msg("-I- JObjectCanvas.doZoomRegion: " + bbox);
        }
        int border = 50;
        Rectangle r = new Rectangle(840, 594);
        this.setCursor(this.waitCursor);
        ((Trafo2D)this.trafo).set_zoom_region_unconstrained(bbox.getXl(), bbox.getYt(), bbox.getXr(), bbox.getYb(), r.width, r.height, border);
        this.doFullRedraw();
        this.setCursor(this.defaultCursor);
        this.notifyZoomListeners();
    }

    public void paint(FigDrawable obj) {
        this.putIntoRepaintArray(obj);
        ++this.n_repaintTableEntries;
    }

    public void paint(FigDrawable obj, int millis) {
        this.putIntoRepaintArray(obj);
        ++this.n_repaintTableEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoRepaintArray(FigDrawable obj) {
        if (this.repaintOverflow) {
            return;
        }
        if (obj.getSyncRedrawFlag()) {
            return;
        }
        obj.setSyncRedrawFlag(true);
        FigDrawable[] figDrawableArray = this.repaintArray;
        synchronized (this.repaintArray) {
            this.repaintArray[this.repaintIndex] = obj;
            ++this.repaintIndex;
            if (this.repaintIndex >= 99) {
                if (this.debug) {
                    this.msg("-W- JObjectCanvas: repaintOverflow: " + this.repaintIndex);
                }
                ++this.n_repaintOverflows;
                this.repaintOverflow = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fastClearRepaintArray() {
        FigDrawable[] figDrawableArray = this.repaintArray;
        synchronized (this.repaintArray) {
            int i = 0;
            while (i < this.repaintIndex) {
                this.repaintArray[i].setSyncRedrawFlag(false);
                ++i;
            }
            this.repaintIndex = 0;
            this.repaintOverflow = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRepaintArray() {
        FigDrawable[] figDrawableArray = this.repaintArray;
        synchronized (this.repaintArray) {
            int i = 0;
            while (i < this.repaintIndex) {
                this.repaintArray[i] = null;
                ++i;
            }
            this.repaintIndex = 0;
            this.repaintOverflow = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String printRepaintStatus() {
        return "JObjectCanvas: repaintTables= " + this.n_repaintTables + " entries= " + this.n_repaintTableEntries + " overflows= " + this.n_repaintOverflows;
    }

    public int countPendingRepaints() {
        return this.repaintIndex;
    }

    public int countRepaintTableEntries() {
        return this.n_repaintTableEntries;
    }

    public int countSyncRepaintOverflows() {
        return this.n_repaintOverflows;
    }

    public int countExecutedSyncRepaints() {
        return this.n_syncrepaints;
    }

    public void doSyncRedraw() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._sync_redraw();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JObjectCanvas.this._sync_redraw();
                    }
                });
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                System.err.println("-E- internal in JOC.doSyncRedraw: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void _sync_redraw() {
        ++this.n_syncrepaints;
        if (!SwingUtilities.isEventDispatchThread()) {
            System.err.println("-E- JObjectCanvas._sync_redraw: WRONG THREAD!");
        }
        if (this.debug) {
            this.msg("-#- JObjectCanvas.doSyncRedraw: objectGR=" + this.objectGR);
        }
        if (this.objectGR == null) {
            return;
        }
        FigTrafo2D trafo = this.getTrafo();
        FigDrawable obj = null;
        if (this.debug) {
            this.msg("+++ doSynRedraw.repaintIndex: " + this.repaintIndex);
        }
        if (this.repaintOverflow) {
            if (this.debug) {
                System.err.print('*');
                System.err.flush();
            }
            this.fastClearRepaintArray();
            this.mode = -1;
            this.repaint();
        } else if (this.repaintIndex > 0) {
            if (this.debug) {
                System.err.print('.');
                System.err.flush();
            }
            FigBbox clip = null;
            FigDrawable[] figDrawableArray = this.repaintArray;
            // MONITORENTER : this.repaintArray
            int i = 0;
            while (i < this.repaintIndex) {
                obj = this.repaintArray[i];
                obj.paint(this.objectGR, trafo);
                obj.setSyncRedrawFlag(false);
                clip = i == 0 ? obj.getBbox() : clip.union(obj.getBbox());
                ++i;
            }
            this.repaintIndex = 0;
            // MONITOREXIT : figDrawableArray
            Rectangle r = clip.getRectangle();
            int x = trafo.wc_to_screen_x(r.x) - 2;
            int y = trafo.wc_to_screen_y(r.y) - 2;
            int w = trafo.wc_to_screen(r.width) + 5;
            int h = trafo.wc_to_screen(r.height) + 5;
            this.mode |= 7;
            this.repaint(x, y, w, h);
        }
        ++this.n_repaintTables;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("JObjectCanvas selftest");
        JObjectCanvas objectCanvas = new JObjectCanvas(null);
        frame.getContentPane().add("Center", objectCanvas);
        frame.setVisible(true);
        frame.setSize(400, 400);
        frame.validate();
    }
}

