/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JToolTip;
import jfig.gui.FontCache;

public class JMultiLineToolTip
extends JToolTip {
    protected String label;
    protected int margin_width;
    protected int margin_height;
    protected int alignment;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected int num_lines;
    protected String[] lines;
    protected int[] line_widths;
    protected int max_width;
    protected int line_height;
    protected int line_ascent;
    protected boolean measured = false;

    public JMultiLineToolTip(String label, int margin_width, int margin_height, int alignment) {
        this.label = label == null ? "" : label;
        this.margin_width = margin_width;
        this.margin_height = margin_height;
        this.alignment = alignment;
        this.newLabel();
    }

    public JMultiLineToolTip(String label) {
        this(label, 10, 10, 0);
    }

    public void setToolTipText(String label) {
        this.label = label == null ? "" : label;
        this.newLabel();
        this.measured = false;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measured = false;
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void setAlignment(int a) {
        this.alignment = a;
        this.repaint();
    }

    public void setMarginWidth(int mw) {
        this.margin_width = mw;
        this.repaint();
    }

    public void setMarginHeight(int mh) {
        this.margin_height = mh;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public Dimension getPreferredSize() {
        if (!this.measured) {
            this.measure();
        }
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        if (!this.measured) {
            this.measure();
        }
        int y = this.line_ascent + (size.height - this.num_lines * this.line_height) / 2;
        int i = 0;
        while (i < this.num_lines) {
            int x;
            switch (this.alignment) {
                default: {
                    x = this.margin_width;
                    break;
                }
                case 1: {
                    x = (size.width - this.line_widths[i]) / 2;
                    break;
                }
                case 2: {
                    x = size.width - this.margin_width - this.line_widths[i];
                }
            }
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }

    protected synchronized void newLabel() {
        StringTokenizer t = new StringTokenizer(this.label, "\n");
        this.num_lines = t.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int i = 0;
        while (i < this.num_lines) {
            this.lines[i] = t.nextToken();
            ++i;
        }
    }

    public synchronized void measure() {
        FontMetrics fm = FontCache.getFontCache().getFontMetrics(this.getFont());
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        int i = 0;
        while (i < this.num_lines) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] > this.max_width) {
                this.max_width = this.line_widths[i];
            }
            ++i;
        }
        this.measured = true;
    }
}

