/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.objects.FigObject;

public class InsertVertexIntoSignalCommand
extends Command {
    Signal signal;
    WireSegment originalSegment;
    WireSegment newSegment1;
    WireSegment newSegment2;
    ObjectCanvas canvas;
    Point newVertex;

    public InsertVertexIntoSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.statusMessage("Please click on the new vertex' position!");
        this.signal = null;
        this.originalSegment = null;
        this.newSegment1 = null;
        this.newSegment2 = null;
        this.newVertex = null;
        this.ready = false;
    }

    public void execute() {
        if (this.signal == null || this.originalSegment == null) {
            return;
        }
        Point[] op = this.originalSegment.getPoints();
        Point[] wp1 = new Point[]{op[0], this.newVertex};
        this.newSegment1 = new WireSegment(this.signal);
        this.newSegment1.setPoints(wp1);
        this.newSegment1.setTrafo(this.canvas.getTrafo());
        Point[] wp2 = new Point[]{op[1], this.newVertex};
        this.newSegment2 = new WireSegment(this.signal);
        this.newSegment2.setPoints(wp2);
        this.newSegment2.setTrafo(this.canvas.getTrafo());
        this.editor.deleteFromObjectList(this.signal);
        this.signal.deleteSegment(this.originalSegment);
        this.signal.addSegment(this.newSegment1);
        this.signal.addSegment(this.newSegment2);
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(this.signal);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.setTmpObject(null);
        this.statusMessage("Insert vertex ready... select a command");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.signal.deleteSegment(this.newSegment1);
        this.signal.deleteSegment(this.newSegment2);
        this.signal.addSegment(this.originalSegment);
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public void setPosition(Point SP, Point WP) {
        FigObject tmp = this.editor.findNearestWireSegment(WP, 200);
        if (tmp == null) {
            this.statusMessage("No object found at that position. Please try again!");
            this.ready = true;
            return;
        }
        if (!(tmp instanceof WireSegment)) {
            this.statusMessage("No signal found at that position. Please try again!");
            this.ready = true;
            return;
        }
        this.originalSegment = (WireSegment)tmp;
        this.signal = this.originalSegment.getSignal();
        this.newVertex = new Point(WP);
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "InsertVertexIntoSignalCommand: " + this.signal;
    }

    public String getDescription() {
        return "insert vertex";
    }
}

