/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jfig.gui.ImageHelper;
import jfig.utils.ExceptionTracer;

public class ImageCanvas
extends Canvas {
    protected Image icon = null;
    protected int x_offset = 0;
    protected int y_offset = 0;
    protected int x_align = 0;
    protected int y_align = 0;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTERX = 2;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int CENTERY = 2;

    public ImageCanvas(String name) {
        this.icon = this.loadIcon(name);
        this.repaint();
    }

    public ImageCanvas(Image icon) {
        this.icon = icon;
        this.repaint();
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.clearRect(0, 0, w, h);
        if (this.icon != null) {
            int x = this.x_offset;
            if (this.x_align == 0) {
                x = this.x_offset;
            } else if (this.x_align == 2) {
                x = (w - this.icon.getWidth(this)) / 2;
            } else if (this.x_align == 1) {
                x = w - this.icon.getWidth(this);
            }
            int y = this.y_offset;
            if (this.y_align == 0) {
                y = this.y_offset;
            } else if (this.y_align == 2) {
                y = (h - this.icon.getHeight(this)) / 2;
            } else if (this.y_align == 1) {
                y = h - this.icon.getHeight(this);
            }
            g.drawImage(this.icon, x, y, this);
        }
    }

    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.x_offset + this.icon.getWidth(this), this.y_offset + this.icon.getHeight(this));
        }
        return new Dimension(this.x_offset + 50, this.y_offset + 50);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setOffsets(int x, int y) {
        this.x_offset = x;
        this.y_offset = y;
        this.repaint();
    }

    public void setAlignment(int x_align, int y_align) {
        this.x_align = x_align;
        this.y_align = y_align;
    }

    public Image loadIcon(String iconname) {
        try {
            this.icon = ImageHelper.loadResourceImage(iconname);
        }
        catch (Throwable e) {
            ExceptionTracer.message("-E- DidYouKnowFrame: couldn't load the icon from " + iconname);
        }
        return this.icon;
    }

    public void setImage(Image icon) {
        if (icon == null) {
            return;
        }
        this.icon = icon;
        this.repaint();
    }
}

