/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.utils.HexFormat;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.gui.FontCache;
import jfig.utils.SetupManager;

public class HexTextField
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    protected long value;
    protected String svalue;
    protected Hashtable actionListenerTable;
    protected Font textFont;
    protected Color backgroundColor;
    protected Color textColor;
    protected Color highlightColor;
    protected Image offscreenBuffer;
    protected int n_chars;
    protected int n_cursor;
    protected int char_width;
    protected int char_height;
    protected int baseline;
    protected int border_width;
    protected int border_height;
    protected int width;
    protected int height;
    protected boolean shiftMode;
    private static int[] bitmasks = new int[]{0, 1, 16, 256, 4096, 65536, 0x100000, 0x1000000, 0x10000000};

    public HexTextField(int n_chars) {
        this.n_chars = n_chars;
        this.n_cursor = -1;
        this.shiftMode = false;
        this.actionListenerTable = new Hashtable();
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setValue(0L);
        this.prepareGUI();
    }

    protected long getValue() {
        return this.value;
    }

    protected void setValue(long value) {
        this.value = value;
        this.svalue = this.getHexString();
        this.notifyListeners();
        this.repaint();
    }

    protected void notifyListeners() {
        ActionEvent ie = new ActionEvent(this, 1001, this.getHexString());
        if (this.actionListenerTable == null) {
            return;
        }
        Enumeration E = this.actionListenerTable.keys();
        while (E.hasMoreElements()) {
            ((ActionListener)E.nextElement()).actionPerformed(ie);
        }
    }

    public void addActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.put(AL, AL);
    }

    public void removeActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.remove(AL);
    }

    protected String getHexString() {
        return HexFormat.getHexString(this.value, this.n_chars);
    }

    protected void prepareGUI() {
        this.backgroundColor = SetupManager.getColor("Hades.HexTextField.BackgroundColor", Color.white);
        this.textColor = SetupManager.getColor("Hades.HexTextField.TextColor", Color.blue);
        this.highlightColor = SetupManager.getColor("Hades.HexTextField.HighlightColor", Color.red);
        this.setBackground(this.backgroundColor);
        String fontname = SetupManager.getProperty("Hades.HexTextField.FontName", "Monospaced");
        int fontsize = SetupManager.getInteger("Hades.HexTextField.FontSize", 12);
        int fontstyle = SetupManager.getInteger("Hades.HexTextField.FontStyle", 0);
        this.setTextFont(new Font(fontname, fontstyle, fontsize));
    }

    public void setTextFont(Font f) {
        this.textFont = f;
        FontMetrics fm = FontCache.getFontCache().getFontMetrics(this.textFont);
        this.char_width = fm.charWidth('M');
        this.char_height = fm.getMaxDescent() + fm.getMaxAscent();
        this.baseline = fm.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_chars * this.char_width + 2 * this.border_width;
        this.height = this.char_height + 2 * this.border_height;
        this.repaint();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    protected void createOffscreenBuffer() {
    }

    public void paint(Graphics g) {
        if (this.textFont == null) {
            this.prepareGUI();
        }
        if (this.offscreenBuffer == null) {
            this.createOffscreenBuffer();
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.gray);
        g.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
        g.draw3DRect(1, 1, this.width - 3, this.height - 3, false);
        g.setColor(this.textColor);
        g.setFont(this.textFont);
        int x0 = this.border_width;
        int y0 = this.border_height + this.baseline;
        g.drawString(this.svalue, x0, y0);
        g.drawString("_", x0 + this.n_cursor * this.char_width, y0);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setCursorFromMousePosition(MouseEvent me) {
        int xpos = me.getX();
        this.n_cursor = (xpos - this.border_width) / this.char_width;
        this.shiftMode = false;
    }

    public void moveCursorRight() {
        ++this.n_cursor;
        if (this.n_cursor >= this.n_chars) {
            this.n_cursor = this.n_chars - 1;
        }
        this.shiftMode = false;
    }

    public void moveCursorLeft() {
        --this.n_cursor;
        if (this.n_cursor < 0) {
            this.n_cursor = 0;
        }
        this.shiftMode = false;
    }

    public void incrementValue() {
        if (this.n_cursor < 0 || this.n_cursor >= this.n_chars) {
            this.n_cursor = this.n_chars - 1;
        }
        this.setValue(this.getValue() + (long)bitmasks[this.n_chars - this.n_cursor]);
    }

    public void decrementValue() {
        if (this.n_cursor < 0 || this.n_cursor >= this.n_chars) {
            this.n_cursor = this.n_chars - 1;
        }
        this.setValue(this.getValue() - (long)bitmasks[this.n_chars - this.n_cursor]);
    }

    public void setDigitAtMousePosition(char c) {
        if (!HexTextField.isHexDigit(c)) {
            return;
        }
        if (this.n_cursor < 0 || this.n_cursor >= this.n_chars) {
            this.n_cursor = this.n_chars - 1;
        }
        StringBuffer buffer = new StringBuffer(this.getHexString());
        buffer.setCharAt(this.n_cursor, c);
        this.value = (int)Long.parseLong(buffer.toString(), 16);
    }

    public void insertDigitAtMousePosition(char c) {
        if (!HexTextField.isHexDigit(c)) {
            return;
        }
        if (this.n_cursor < 0 || this.n_cursor >= this.n_chars) {
            this.n_cursor = this.n_chars - 1;
        }
        String source = this.getHexString();
        StringBuffer buffer = new StringBuffer(source);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == 'X') {
                buffer.setCharAt(i, '0');
            }
            ++i;
        }
        if (!this.shiftMode) {
            buffer.setCharAt(this.n_cursor, c);
            if (this.n_cursor == this.n_chars - 1) {
                this.shiftMode = true;
            } else {
                this.moveCursorRight();
            }
        } else {
            int i2 = 0;
            while (i2 < this.n_cursor) {
                buffer.setCharAt(i2, source.charAt(i2 + 1));
                ++i2;
            }
            buffer.setCharAt(this.n_cursor, c);
        }
        this.setValue((int)Long.parseLong(buffer.toString(), 16));
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public void mousePressed(MouseEvent me) {
        this.setCursorFromMousePosition(me);
        if (me.isAltDown()) {
            this.incrementValue();
        } else if (me.isMetaDown()) {
            this.decrementValue();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
        this.requestFocus();
    }

    public void mouseMoved(MouseEvent me) {
        this.setCursorFromMousePosition(me);
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void keyPressed(KeyEvent ke) {
        char c = ke.getKeyChar();
        int code = ke.getKeyCode();
        if (ke.isActionKey()) {
            if (code == 39) {
                this.moveCursorRight();
            } else if (code == 37) {
                this.moveCursorLeft();
            } else if (code == 38) {
                this.incrementValue();
            } else if (code == 40) {
                this.decrementValue();
            }
        } else {
            this.insertDigitAtMousePosition(c);
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        HexTextField.msg("HexTextField selftest...");
        SetupManager.loadLocalProperties(".hadesrc");
        HexTextField htf = new HexTextField(7);
        htf.setValue(48879L);
        Frame f = new Frame("HexTextField Demo");
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
        f.setLayout(new FlowLayout());
        f.add(new Label("PC:"));
        f.add(htf);
        f.pack();
        htf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HexTextField.msg("-I- action event: " + evt.getActionCommand());
            }
        });
    }
}

