/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;

public class DisconnectPortCommand
extends Command {
    Point oldPos;
    Symbol symbol;
    SimObject target;
    Port targetPort;
    Signal signal;
    ObjectCanvas canvas;

    public DisconnectPortCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.statusMessage("Please click on the SimObject Port to disconnect:");
        this.ready = false;
        this.oldPos = null;
    }

    public void execute() {
        if (this.targetPort != null) {
            this.target = this.targetPort.getParent();
            this.signal = this.targetPort.getSignal();
            if (this.signal != null) {
                this.signal.disconnect(this.targetPort);
            }
        }
        this.statusMessage("Ready. Please select a command.");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.message("-W- Cannot undo an DisconnectPortCommand command. ");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.oldPos = new Point(WP);
        this.targetPort = this.editor.findPort(WP);
        if (this.targetPort == null) {
            this.message("-W- DisconnectPort: No port at that position! ");
            this.statusMessage("Disconnect port: please click directly on the port");
            this.ready = false;
            return;
        }
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "DisconnectPortCommand at: " + this.oldPos + " target: " + this.target;
    }

    public String getDescription() {
        return "autoconnect object";
    }

    static {
        Command.versionString = "HADES DisconnectPortCommand 0.1 (07.04.99)";
    }
}

