/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;

public class DeleteSelectionCommand
extends Command {
    Hashtable victims = new Hashtable();
    Hashtable victimSignals = new Hashtable();
    Hashtable victimSimObjects = new Hashtable();
    ObjectCanvas canvas;

    public DeleteSelectionCommand(Editor editor) {
        super(editor);
        this.execute();
        this.ready = true;
    }

    public void execute() {
        FigObject tmp;
        System.out.println("-#- DeleteSelectionCommand.execute...");
        Enumeration E = this.editor.getObjectList().elements();
        while (E.hasMoreElements()) {
            FigObject tmp2 = (FigObject)E.nextElement();
            if (!tmp2.isSelected()) continue;
            this.victims.put(tmp2, "raw");
        }
        FigObjectList OL = this.editor.getObjectList();
        E = this.victims.keys();
        while (E.hasMoreElements()) {
            tmp = (FigObject)E.nextElement();
            OL.delete(tmp);
        }
        E = this.victims.keys();
        while (E.hasMoreElements()) {
            tmp = (FigObject)E.nextElement();
            if (tmp instanceof Symbol) {
                this.deleteSimObject(((Symbol)tmp).getParent());
                continue;
            }
            if (!(tmp instanceof WireSegment)) continue;
            this.deleteSignal(((WireSegment)tmp).getSignal());
        }
        this.editor.getObjectCanvas().doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    private void deleteSimObject(SimObject simobject) {
        this.victimSimObjects.put(simobject, simobject);
        this.editor.getDesign().deleteComponent(simobject);
    }

    private void deleteSignal(Signal signal) {
        if (this.victimSignals.get(signal) != null) {
            return;
        }
        this.victimSignals.put(signal, signal);
        this.editor.getDesign().deleteSignal(signal);
    }

    public void undo() {
        this.editor.getObjectCanvas().doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.message("-E- don't call setPosition on a DeleteSelectionCommand!");
        this.ready = true;
    }

    public String toString() {
        return "DeleteSelectionCommand";
    }

    public String getDescription() {
        return "delete selection";
    }
}

