/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.styx.Waveform;
import hades.styx.WaveformViewer;
import hades.symbols.ProbeSymbol;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class DeleteProbeFromSignalCommand
extends Command {
    Point pos1;
    Signal signal;
    Waveform waveform;
    ObjectCanvas canvas;
    ProbeSymbol probeSymbol;

    public DeleteProbeFromSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
    }

    public void execute() {
        WaveformViewer sw = this.editor.getWaveformViewer();
        if (Command.debug) {
            this.message("DeleteProbeFromSignalCommand:execute...");
        }
        if (!this.signal.hasProbe()) {
            this.message("-W- No probe to remove on that signal!");
            this.ready = true;
            return;
        }
        this.waveform = this.signal.getProbe();
        this.probeSymbol = this.signal.getProbeSymbol();
        this.signal.removeProbe();
        this.signal.setProbeSymbol(null);
        sw.delWaveform(this.waveform);
        this.editor.getObjectList().delete(this.probeSymbol);
        this.editor.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.ready = true;
    }

    public void undo() {
        this.message("-E- Cannot undo remove probe() yet...");
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        FigObject obj = this.editor.findNearestWireSegment(WP);
        if (obj != null) {
            if (!(obj instanceof WireSegment)) {
                this.statusMessage("Must click on an existing Signal wire to remove its probe!");
                this.ready = true;
                return;
            }
        } else {
            this.statusMessage("Must click on an existing Signal wire to remove its probe!");
            this.ready = true;
            return;
        }
        this.signal = ((WireSegment)obj).getSignal();
        this.pos1 = WP;
        this.execute();
    }

    public String toString() {
        return "DeleteProbeFromSignalCommand: " + this.signal;
    }

    public String getDescription() {
        return "remove probe";
    }

    static {
        Command.versionString = "HADES DeleteProbeFromSignalCommand 0.1 (17.11.97)";
    }
}

