/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.models.Design;
import hades.signals.Signal;
import hades.simulator.SimObject;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.canvas.FigCanvasEvent;

public class DeleteAllCommand
extends Command {
    Hashtable c_table;
    Hashtable s_table;

    public DeleteAllCommand(Editor editor) {
        super(editor);
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void execute() {
        this.message("-W- Deleting all objects...");
        Design design = this.editor.getDesign();
        this.c_table = new Hashtable();
        Enumeration e = design.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            design.deleteComponent(tmp.getName());
            this.c_table.put(tmp.getName(), tmp);
        }
        this.s_table = new Hashtable();
        Enumeration e2 = design.getSignals();
        while (e2.hasMoreElements()) {
            Signal stmp = (Signal)e2.nextElement();
            design.deleteSignal(stmp.getName());
            this.s_table.put(stmp.getName(), stmp);
        }
        this.editor.getUndoStack().push(this);
        this.editor.rebuildObjectList(design);
    }

    public void undo() {
        String name;
        if (Command.debug) {
            this.message("-#- DeleteAllCommand.undo()...");
        }
        Design design = this.editor.getDesign();
        Enumeration E = this.c_table.keys();
        while (E.hasMoreElements()) {
            name = (String)E.nextElement();
            SimObject component = (SimObject)this.c_table.get(name);
            design.addComponent(component);
            if (!Command.debug) continue;
            this.message("-#- restored component: " + component);
        }
        Enumeration E2 = this.s_table.keys();
        while (E2.hasMoreElements()) {
            name = (String)E2.nextElement();
            Signal signal = (Signal)this.s_table.get(name);
            design.addSignal(signal);
            if (!Command.debug) continue;
            this.message("-#- restored signal: " + signal);
        }
        this.editor.rebuildObjectList(design);
        this.message("-E- Please autoconnect all objects manually, sorry...");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.execute();
    }

    public String toString() {
        return "DeleteAllCommand object";
    }

    public String getDescription() {
        return "delete object";
    }

    static {
        Command.versionString = "HADES DeleteAllCommand 0.02 (23.06.97)";
    }
}

