/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import jfig.canvas.FigCanvasEvent;

public class CreateSubdesignCommand
extends Command
implements ActionListener {
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    boolean hasName;
    String resname;

    public CreateSubdesignCommand(Editor editor, String designName) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.hasName = false;
        this.resname = null;
        try {
            DesignManager manager = DesignManager.getDesignManager();
            if (designName == null && (designName = manager.selectFileOrURLName("Select design... (*.hds)", "new.hds", ".hds", 0)) == null) {
                this.ready = true;
                return;
            }
            this.target = manager.getDesign(editor, designName, false);
            Symbol tmp = SymbolManager.getSymbolManager().getSymbol(this.target);
            this.target.setSymbol(tmp);
            this.statusMessage("click where to put the subdesign");
        }
        catch (Exception e) {
            this.message("-E- Couldn't load subdesign: " + designName);
            this.message("-E- Exception is: " + e);
            this.ready = true;
            return;
        }
        this.ready = false;
        this.newPos = null;
    }

    public void execute() {
        Design design = (Design)this.target;
        if (design == null) {
            this.message("-E- Internal error in CreateSubDesignCommand: design is null");
            this.target = null;
            return;
        }
        Symbol symbol = design.getSymbol();
        if (symbol == null) {
            this.message("-E- Internal error in CreateSubDesignCommand: design has no valid symbol: " + design);
            return;
        }
        this.editor.getDesign().addComponent(design);
        symbol.setTrafo(this.canvas.getTrafo());
        symbol.move(this.newPos.x, this.newPos.y);
        this.editor.insertIntoObjectList(symbol);
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        if (this.target != null) {
            this.editor.getDesign().deleteComponent(this.target);
            this.editor.rebuildObjectList(this.editor.getDesign());
            this.canvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.newPos = new Point(WP);
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "CreateSubdesignCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "create instance";
    }

    static {
        Command.versionString = "HADES CreateSubdesignCommand 0.4 (03.04.98)";
    }
}

