/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.manager.DesignManager;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.ExceptionTracer;

public class CreateByNameCommand
extends Command
implements ActionListener {
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    boolean hasName;
    String classname;

    public CreateByNameCommand(Editor editor, String className) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.hasName = false;
        this.classname = null;
        this.ready = false;
        this.newPos = null;
    }

    public void execute() {
        this.editor.getDesign().addComponent(this.target);
        this.target.getSymbol().setTrafo(this.canvas.getTrafo());
        this.target.getSymbol().move(this.newPos.x, this.newPos.y);
        this.editor.insertIntoObjectList(this.target.getSymbol());
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.editor.getDesign().deleteComponent(this.target);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.newPos = new Point(WP);
        this.stringDialog = StringDialog.createStringDialog(this.editor.getFrame(), "Enter the class name:", "");
        this.stringDialog.addActionListener(this);
        this.stringDialog.setText("hades.models.");
        Point Q = this.canvas.getComponent().getLocationOnScreen();
        Point P = new Point(Q.x + SP.x + 20, Q.y + SP.y - 40);
        this.stringDialog.getDialog().setLocation(P);
        this.stringDialog.selectText(true);
        this.stringDialog.getDialog().setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (Command.debug) {
            this.message("-W- CNC: actionPerformed: " + evt);
        }
        if (evt.getActionCommand().equals("Cancel")) {
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.ready = true;
            return;
        }
        if (evt.getActionCommand().equals("OK") || evt.getSource() == this.stringDialog.getTextComponent()) {
            if (Command.debug) {
                this.message("-W- CNC: actionPerformed[OK/TF]: " + evt);
            }
            this.classname = this.stringDialog.getText();
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.editor.getFrame().requestFocus();
            try {
                this.target = DesignManager.getDesignManager().getSimObject(this.classname);
                this.target.setEditor(this.editor);
                this.target.setVisible(true);
                Symbol tmp = SymbolManager.getSymbolManager().getSymbol(this.target);
                this.target.setSymbol(tmp);
            }
            catch (Exception e) {
                this.message("-E- Couldn't instantiate class " + this.classname);
                ExceptionTracer.trace(e);
                this.ready = true;
                return;
            }
            this.execute();
            this.ready = true;
        } else {
            this.message("-E- internal: unknown event source in CreateByNameCommand: " + evt);
        }
    }

    public String toString() {
        return "CreateByNameCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "create instance from classname";
    }

    static {
        Command.versionString = "HADES CreateByNameCommand 0.1 (11.09.97)";
    }
}

