/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.MouseMapper;

public class ColibriCreateCommand
extends Command {
    Point newPos;
    Point oldPos;
    SimObject target;
    ObjectCanvas canvas;

    public ColibriCreateCommand(Editor editor, SimObject simobj) {
        super(editor);
        if (editor.getCommand() != this) {
            editor.setCommand(this);
        }
        this.canvas = editor.getObjectCanvas();
        this.canvas.setEnablePopup(false);
        editor.getFrame().toFront();
        this.newPos = new Point(0, 0);
        this.ready = false;
        try {
            this.target = simobj;
            this.target.setEditor(editor);
            this.target.setVisible(true);
            Symbol tmp = SymbolManager.getSymbolManager().getSymbol(this.target);
            this.target.setSymbol(tmp);
            this.target.getSymbol().setTrafo(this.canvas.getTrafo());
            this.target.getSymbol().move(0, 0);
        }
        catch (Exception e) {
            System.out.println("-E- ColibriCreateCommand: " + e);
            e.printStackTrace();
            this.ready = true;
            return;
        }
        this.statusMessage("Left button: position object, middle/right: cancel");
        this.oldPos = null;
        this.setPosition(new Point(0, 0), new Point(0, 0));
    }

    public void execute() {
        this.editor.getDesign().addComponent(this.target);
        this.target.getSymbol().setTrafo(this.canvas.getTrafo());
        this.target.getSymbol().move(this.newPos.x, this.newPos.y);
        this.editor.insertIntoObjectList(this.target.getSymbol());
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.editor.setCommand(new ColibriCreateCommand(this.editor, this.target.copy()));
    }

    public void cancel() {
        this.editor.setTmpObject(null);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.doFullRedraw();
        this.statusMessage("CreateCommand canceled... select a command");
        this.ready = true;
    }

    public void mousePressed(FigCanvasEvent ME) {
        if (MouseMapper.isMiddleClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else if (MouseMapper.isRightClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            Point WP = ME.getWorldCoordinatePoint();
            Point SP = ME.getScreenCoordinatePoint();
            this.setPosition(SP, WP);
        }
    }

    public void setPosition(Point SP, Point WP) {
        if (this.oldPos == null) {
            this.oldPos = new Point(WP);
            this.canvas.setEnablePopup(false);
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(5, this.canvas.getTrafo(), this.target.getSymbol().getBbox());
            this.canvas.doFullRedraw();
            this.statusMessage("Left button: position object, middle/right: cancel");
        } else {
            this.newPos = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("ready... select a command");
            this.execute();
            this.ready = true;
        }
    }

    public void undo() {
        this.target.getSymbol().move(-this.newPos.x, -this.newPos.y);
        this.editor.getDesign().deleteComponent(this.target);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public String toString() {
        return "CreateCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "create instance";
    }

    public String getLogExtraArguments() {
        if (this.target != null) {
            return this.target.getClass().getName();
        }
        return "";
    }
}

